/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.helpers;

import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.yade.engine.commons.arguments.YADESourceTargetArguments;
import com.sos.yade.engine.commons.delegators.AYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.IYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEClientHelper;
import com.sos.yade.engine.exceptions.YADEEngineConnectionException;
import com.sos.yade.engine.exceptions.YADEEngineJumpHostConnectionException;
import com.sos.yade.engine.exceptions.YADEEngineSourceConnectionException;
import com.sos.yade.engine.exceptions.YADEEngineTargetConnectionException;

public class YADEProviderDelegatorHelper {
    public static void ensureConnected(ISOSLogger logger, AYADEProviderDelegator delegator) throws YADEEngineConnectionException {
        if (delegator == null) {
            return;
        }
        YADESourceTargetArguments args = delegator.getArgs();
        if (!args.isRetryOnConnectionErrorEnabled()) {
            try {
                delegator.getProvider().ensureConnected();
            }
            catch (Throwable e) {
                YADEProviderDelegatorHelper.throwConnectionException(delegator, e);
            }
            return;
        }
        int maxRetries = (Integer)args.getConnectionErrorRetryCountMax().getValue();
        long retryInterval = SOSArgumentHelper.asSeconds(args.getConnectionErrorRetryInterval(), (long)0L);
        for (int retryCounter = 0; retryCounter <= maxRetries; ++retryCounter) {
            try {
                delegator.getProvider().ensureConnected();
                return;
            }
            catch (Throwable e) {
                if (retryCounter == maxRetries) {
                    YADEProviderDelegatorHelper.throwConnectionException(delegator, e);
                }
                logger.info("[%s][retry=%s in %ss]%s", new Object[]{delegator.getLabel(), retryCounter + 1, retryInterval, e.toString(), e});
                YADEClientHelper.waitFor(retryInterval);
                continue;
            }
        }
    }

    public static void disconnect(IYADEProviderDelegator ... delegators) {
        for (IYADEProviderDelegator d : delegators) {
            if (d == null || d.getProvider() == null) continue;
            d.getProvider().disconnect();
        }
    }

    private static void throwConnectionException(AYADEProviderDelegator delegator, Throwable e) throws YADEEngineConnectionException {
        YADEEngineConnectionException ex = YADEProviderDelegatorHelper.getConnectionException(delegator, e);
        if (ex != null) {
            throw ex;
        }
    }

    public static YADEEngineConnectionException getConnectionException(AYADEProviderDelegator delegator, Throwable ex) {
        if (delegator == null) {
            return null;
        }
        if (delegator.isJumpHost()) {
            return new YADEEngineJumpHostConnectionException(ex.getMessage(), ex.getCause());
        }
        if (delegator instanceof YADESourceProviderDelegator) {
            return new YADEEngineSourceConnectionException(ex.getCause());
        }
        return new YADEEngineTargetConnectionException(ex.getMessage(), ex.getCause());
    }

    public static boolean isConnectionException(Throwable cause) {
        if (cause == null) {
            return false;
        }
        for (Throwable e = cause; e != null; e = e.getCause()) {
            if (!(e instanceof YADEEngineConnectionException)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSourceOrTargetNotConnected(IYADEProviderDelegator sourceDelegator, IYADEProviderDelegator targetDelegator) {
        return !sourceDelegator.getProvider().isConnected() || targetDelegator != null && !targetDelegator.getProvider().isConnected();
    }
}

