/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations.copymove.file;

import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.ftp.FTPProvider;
import com.sos.commons.vfs.ftp.commons.FTPProviderArguments;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.delegators.AYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEClientBannerWriter;
import com.sos.yade.engine.commons.helpers.YADEProviderDelegatorHelper;
import com.sos.yade.engine.exceptions.YADEEngineException;
import com.sos.yade.engine.exceptions.YADEEngineTransferFileException;
import com.sos.yade.engine.handlers.operations.copymove.YADECopyMoveOperationsConfig;
import com.sos.yade.engine.handlers.operations.copymove.YADECopyMoveOperationsHandler;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADEFileNameInfo;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADETargetProviderFile;
import com.sos.yade.engine.handlers.operations.copymove.file.helpers.YADEFileReplacementHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class YADEFileHandler {
    private static final long AZURE_BLOB_STORAGE_MAX_UPLOAD_FILESIZE = 0x3200000L;
    private static final long LOG_TRANSFER_START_IF_FILESIZE_GREATER_THAN = 0xC0000003L;
    private static final long USE_BUFFERED_STREAMS_IF_FILESIZE_GREATER_THAN = 0xA00000L;
    private final ISOSLogger logger;
    private final YADECopyMoveOperationsConfig config;
    private final YADESourceProviderDelegator sourceDelegator;
    private final YADETargetProviderDelegator targetDelegator;
    private final YADEProviderFile sourceFile;
    private final AtomicBoolean cancel;

    public YADEFileHandler(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile sourceFile, AtomicBoolean cancel) {
        this.logger = logger;
        this.config = config;
        this.sourceDelegator = sourceDelegator;
        this.targetDelegator = targetDelegator;
        this.sourceFile = sourceFile;
        this.cancel = cancel;
    }

    /*
     * Exception decompiling
     */
    public void run(boolean isMoveOperation, boolean useCumulativeTargetFile, boolean useLastModified) throws YADEEngineTransferFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void initializeTarget() throws ProviderException {
        YADEFileNameInfo fileNameInfo = this.getTargetFinalFilePathInfo();
        String finalFileName = fileNameInfo.getName();
        if (this.sourceDelegator.isHTTP() && !this.targetDelegator.isHTTP()) {
            finalFileName = HttpUtils.toValidFileSystemName((String)finalFileName, (boolean)this.targetDelegator.isWindows());
        }
        Object transferFileName = finalFileName;
        if (this.config.getTarget().getAtomic() != null) {
            transferFileName = this.config.getTarget().getAtomic().getPrefix() + finalFileName + this.config.getTarget().getAtomic().getSuffix();
        }
        String targetDirectory = this.sourceDelegator.getDirectoryMapper().getTargetDirectory(this.logger, this.config, this.sourceDelegator, this.targetDelegator, this.sourceFile, fileNameInfo);
        String transferFileFullPath = this.targetDelegator.appendPath(targetDirectory, (String)transferFileName);
        String httpOriginalParentFullPath = null;
        if (this.targetDelegator.isHTTP()) {
            httpOriginalParentFullPath = this.targetDelegator.getParentPath(transferFileFullPath);
        }
        YADETargetProviderFile target = new YADETargetProviderFile(this.targetDelegator, transferFileFullPath);
        if (this.targetDelegator.isHTTP()) {
            String httpFinalPath = this.targetDelegator.appendPath(httpOriginalParentFullPath, finalFileName);
            target.setFinalFullPath(httpFinalPath);
        } else {
            target.setFinalFullPath(this.targetDelegator, finalFileName);
        }
        target.setIndex(this.sourceFile.getIndex());
        target.setNameReplaced(fileNameInfo.isReplaced());
        this.sourceFile.setTarget(target);
    }

    public static Optional<YADEFileNameInfo> getReplacementResultIfDifferent(AYADEProviderDelegator delegator, YADEProviderFile file) {
        return YADEFileReplacementHelper.getReplacementResultIfDifferent(delegator, file.getName(), (String)delegator.getArgs().getReplacing().getValue(), (String)delegator.getArgs().getReplacement().getValue());
    }

    public static String getFinalFullPath(AYADEProviderDelegator delegator, YADEProviderFile file, YADEFileNameInfo newNameInfo) {
        if (newNameInfo.isAbsolutePath()) {
            return newNameInfo.getPath();
        }
        String finalFullPath = file.getParentFullPath();
        if (newNameInfo.needsParent()) {
            finalFullPath = delegator.appendPath(finalFullPath, newNameInfo.getParent());
        }
        return delegator.appendPath(finalFullPath, newNameInfo.getName());
    }

    private YADEFileNameInfo getTargetFinalFilePathInfo() {
        Optional<YADEFileNameInfo> newFileNameInfo;
        Object fileName = this.sourceFile.getName();
        if (this.config.getTarget().getCompress() != null) {
            fileName = (String)fileName + this.config.getTarget().getCompress().getFileExtension();
        }
        YADEFileNameInfo info = null;
        if (this.config.getTarget().isReplacementEnabled() && (newFileNameInfo = YADEFileHandler.getReplacementResultIfDifferent(this.targetDelegator, this.sourceFile)).isPresent()) {
            info = newFileNameInfo.get();
        }
        if (info == null) {
            info = new YADEFileNameInfo(this.targetDelegator, (String)fileName, false);
        }
        return info;
    }

    private void handleException(String fileTransferLogPrefix, YADETargetProviderFile targetFile, Throwable e, int attempts) throws YADEEngineException {
        boolean throwException = false;
        Object throwExceptionAdd = "";
        if (YADEProviderDelegatorHelper.isSourceOrTargetNotConnected(this.sourceDelegator, this.targetDelegator)) {
            if (attempts >= this.config.getMaxRetries()) {
                throwException = true;
                if (this.config.getMaxRetries() > 1) {
                    throwExceptionAdd = "[maximum retry attempts=" + this.config.getMaxRetries() + " reached]";
                }
            } else {
                YADEProviderDelegatorHelper.ensureConnected(this.logger, this.sourceDelegator);
                YADEProviderDelegatorHelper.ensureConnected(this.logger, this.targetDelegator);
                YADECopyMoveOperationsHandler.handleReusableResourcesBeforeTransfer(this.config, this.sourceDelegator, this.targetDelegator);
            }
        } else {
            throwException = true;
        }
        if (throwException) {
            this.throwException(fileTransferLogPrefix, targetFile, e, (String)throwExceptionAdd);
        } else {
            String msg = String.format("[%s][%s][%s=%s][%s][%s]%s", fileTransferLogPrefix, YADEClientBannerWriter.formatState(targetFile.getState()), this.sourceDelegator.getLabel(), this.sourceFile.getFullPath(), this.targetDelegator.getLabel(), targetFile.getFullPath(), (String)throwExceptionAdd + e);
            this.logger.warn((Object)msg);
        }
    }

    private void tryCleanupIfFailed(String fileTransferLogPrefix, YADETargetProviderFile targetFile, Throwable e) throws YADEEngineException {
        if (e == null) {
            return;
        }
        String msg = String.format("[tryCleanupIfFailed][%s][%s][%s][%s]", fileTransferLogPrefix, YADEClientBannerWriter.formatState(targetFile.getState()), this.targetDelegator.getLabel(), targetFile.getFullPath());
        try {
            FTPProvider ftp;
            if (!this.targetDelegator.getProvider().isConnected() && this.targetDelegator.getProvider() instanceof FTPProvider && !((FTPProviderArguments)(ftp = (FTPProvider)this.targetDelegator.getProvider()).getArguments()).isPassiveMode()) {
                ((FTPProviderArguments)ftp.getArguments()).getPassiveMode().setValue((Object)true);
                ftp.ensureConnected();
            }
            if (this.targetDelegator.getProvider().isConnected()) {
                if (this.targetDelegator.getProvider().deleteFileIfExists(targetFile.getFullPath())) {
                    targetFile.setState(Yade.TransferEntryState.ROLLED_BACK);
                    msg = String.format("[%s][%s][%s][%s]deleted", fileTransferLogPrefix, YADEClientBannerWriter.formatState(targetFile.getState()), this.targetDelegator.getLabel(), targetFile.getFullPath());
                    this.logger.info((Object)msg);
                } else {
                    this.logger.info((Object)(msg + "not found"));
                }
            } else {
                this.logger.info((Object)(msg + "not connected"));
            }
        }
        catch (Exception ex) {
            this.logger.warn(msg + ex, (Throwable)ex);
        }
    }

    private void throwException(String fileTransferLogPrefix, YADETargetProviderFile targetFile, Throwable e, String throwExceptionAdd) throws YADEEngineTransferFileException {
        String target = targetFile == null ? "null" : targetFile.getFullPath();
        String msg = String.format("[%s][%s=%s][%s][%s]%s", fileTransferLogPrefix, this.sourceDelegator.getLabel(), this.sourceFile.getFullPath(), this.targetDelegator.getLabel(), target, throwExceptionAdd + e);
        this.logger.error((Object)msg);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("  [StackTrace]" + SOSClassUtil.getStackTrace((Throwable)e)));
        }
        throw new YADEEngineTransferFileException(msg, e.getCause() == null ? e : e.getCause());
    }
}

