/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations.copymove.file.helpers;

import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.delegators.IYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.exceptions.YADEEngineTransferFileException;
import com.sos.yade.engine.exceptions.YADEEngineTransferFileSizeException;
import com.sos.yade.engine.handlers.command.YADECommandExecutor;
import com.sos.yade.engine.handlers.operations.copymove.YADECopyMoveOperationsConfig;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADETargetProviderFile;

public class YADEFileActionsExecuter {
    public static void postProcessingOnSuccess(ISOSLogger logger, String fileTransferLogPrefix, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile sourceFile, boolean isAtomicallyEnabled, boolean useLastModified) throws Exception {
        YADETargetProviderFile targetFile;
        boolean executeAfterFile = false;
        if (config.getTarget().needsFilePostProcessing() && (targetFile = sourceFile.getTarget()) != null) {
            executeAfterFile = true;
            if (targetFile.needsRename()) {
                YADEFileActionsExecuter.rename(logger, fileTransferLogPrefix, targetDelegator, sourceDelegator, targetDelegator, sourceFile, isAtomicallyEnabled, false);
            }
            if (useLastModified && config.getTarget().isKeepModificationDateEnabled()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[%s][%s][%s][setTargetFileModificationDate][UTC]%s", new Object[]{fileTransferLogPrefix, targetDelegator.getLabel(), targetFile.getFinalFullPath(), sourceFile.getLastModifiedAsUTCString()});
                }
                targetDelegator.getProvider().setFileLastModifiedFromMillis(targetFile.getFinalFullPath(), sourceFile.getLastModifiedMillis());
                logger.info("[%s][%s][%s][%s][UTC]%s", new Object[]{fileTransferLogPrefix, targetDelegator.getLabel(), targetDelegator.getArgs().getKeepModificationDate().getName(), targetFile.getFinalFullPath(), sourceFile.getLastModifiedAsUTCString()});
            }
            if (config.getTarget().isCreateIntegrityHashFileEnabled() && targetFile.getIntegrityHash() != null) {
                String path = targetFile.getFinalFullPath() + config.getIntegrityHashFileExtensionWithDot();
                targetDelegator.getProvider().writeFile(path, targetFile.getIntegrityHash());
                logger.info("[%s][%s][%s][%s]created", new Object[]{fileTransferLogPrefix, targetDelegator.getLabel(), targetDelegator.getArgs().getCreateIntegrityHashFile().getName(), path});
            }
        }
        if (config.getSource().needsFilePostProcessing()) {
            executeAfterFile = true;
            if (sourceFile.needsRename()) {
                YADEFileActionsExecuter.rename(logger, fileTransferLogPrefix, sourceDelegator, sourceDelegator, targetDelegator, sourceFile, isAtomicallyEnabled, true);
            }
        }
        if (executeAfterFile) {
            YADECommandExecutor.executeAfterFile(logger, sourceDelegator, targetDelegator, sourceFile);
        }
    }

    public static void finalizeTargetFileSize(YADETargetProviderDelegator delegator, YADETargetProviderFile targetFile, boolean isCompress) throws Exception {
        if (isCompress) {
            String filePath = targetFile.getFullPath();
            targetFile = (YADETargetProviderFile)delegator.getProvider().rereadFileIfExists((ProviderFile)targetFile);
            if (targetFile == null) {
                throw new YADEEngineTransferFileException((Throwable)new SOSNoSuchFileException(filePath, null));
            }
        } else {
            targetFile.finalizeFileSize();
        }
    }

    public static void checkTargetFileSize(ISOSLogger logger, String fileTransferLogPrefix, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile sourceFile) throws Exception {
        if (!config.isCheckFileSizeEnabled()) {
            return;
        }
        if (sourceFile.getSize() != sourceFile.getTarget().getSize()) {
            String msg = String.format("[%s][%s=%s, Bytes=%s][%s=%s, Bytes=%s]", fileTransferLogPrefix, sourceDelegator.getLabel(), sourceFile.getFullPath(), sourceFile.getSize(), targetDelegator.getLabel(), sourceFile.getTarget().getFullPath(), sourceFile.getTarget().getSize());
            targetDelegator.getProvider().deleteFileIfExists(sourceFile.getTarget().getFullPath());
            sourceFile.getTarget().setState(Yade.TransferEntryState.ROLLED_BACK);
            logger.info("%s[file size does not match]target file deleted", new Object[]{msg});
            throw new YADEEngineTransferFileSizeException(msg + "file size does not match");
        }
    }

    private static void rename(ISOSLogger logger, String fileTransferLogPrefix, IYADEProviderDelegator delegator, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile sourceFile, boolean isAtomicallyEnabled, boolean isSource) throws Exception {
        YADEProviderFile sourceOrTargetFile = isSource ? sourceFile : sourceFile.getTarget();
        String oldPath = sourceOrTargetFile.getFullPath();
        String newPath = sourceOrTargetFile.getFinalFullPath();
        YADECommandExecutor.executeBeforeRename(logger, delegator, sourceDelegator, targetDelegator, sourceFile, isSource);
        if (delegator.getProvider().renameFileIfSourceExists(oldPath, newPath)) {
            sourceOrTargetFile.setSubState(Yade.TransferEntryState.RENAMED);
            String renameCause = isAtomicallyEnabled ? "AtomicRename" : "Rename";
            logger.info("[%s][%s][%s][%s]->[%s]renamed", new Object[]{fileTransferLogPrefix, delegator.getLabel(), renameCause, oldPath, newPath});
        }
    }
}

