/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.FiberMonitor;
import cats.effect.unsafe.IORuntime;
import cats.effect.unsafe.IORuntime$;
import cats.effect.unsafe.IORuntimeConfig$;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.Scheduler;
import cats.effect.unsafe.Scheduler$;
import cats.effect.unsafe.WorkStealingThreadPool;
import cats.effect.unsafe.metrics.ComputePoolSampler;
import cats.effect.unsafe.metrics.LiveFiberSnapshotTrigger;
import cats.effect.unsafe.metrics.LocalQueueSampler;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public abstract class IORuntimeCompanionPlatform {
    private volatile IORuntime _global;

    public IORuntimeCompanionPlatform() {
        String DefaultBlockerPrefix = "io-compute-blocker";
        this._global = null;
    }

    public Tuple2<WorkStealingThreadPool, Function0<BoxedUnit>> createWorkStealingComputeThreadPool(int threads, String threadPrefix, String blockerThreadPrefix, Duration runtimeBlockingExpiration, Function1<Throwable, BoxedUnit> reportFailure) {
        return this.createWorkStealingComputeThreadPool(threads, threadPrefix, blockerThreadPrefix, runtimeBlockingExpiration, reportFailure, false);
    }

    public Tuple2<WorkStealingThreadPool, Function0<BoxedUnit>> createWorkStealingComputeThreadPool(int threads, String threadPrefix, String blockerThreadPrefix, Duration runtimeBlockingExpiration, Function1<Throwable, BoxedUnit> reportFailure, boolean blockedThreadDetectionEnabled) {
        JFunction0.mcV.sp & Serializable intersect;
        WorkStealingThreadPool threadPool = new WorkStealingThreadPool(threads, threadPrefix, blockerThreadPrefix, runtimeBlockingExpiration, blockedThreadDetectionEnabled && threads > 1, reportFailure);
        if (TracingConstants.isStackTracing) {
            MBeanServer mBeanServer = IORuntimeCompanionPlatform.liftedTree1$1();
            if (mBeanServer != null) {
                BoxedUnit boxedUnit;
                Set registeredMBeans = (Set)Set$.MODULE$.empty();
                String hash = RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(System.identityHashCode(threadPool)));
                try {
                    ObjectName computePoolSamplerName = new ObjectName(new StringBuilder(51).append("cats.effect.unsafe.metrics:type=ComputePoolSampler-").append(hash).toString());
                    ComputePoolSampler computePoolSampler = new ComputePoolSampler(threadPool);
                    mBeanServer.registerMBean(computePoolSampler, computePoolSamplerName);
                    boxedUnit = registeredMBeans.$plus$eq((Object)computePoolSamplerName);
                }
                catch (Throwable throwable) {
                    boxedUnit = BoxedUnit.UNIT;
                }
                LocalQueue[] localQueues = threadPool.localQueues();
                int len = localQueues.length;
                for (int i = 0; i < len; ++i) {
                    BoxedUnit boxedUnit2;
                    LocalQueue localQueue = localQueues[i];
                    try {
                        ObjectName localQueueSamplerName = new ObjectName(new StringBuilder(51).append("cats.effect.unsafe.metrics:type=LocalQueueSampler-").append(hash).append("-").append(i).toString());
                        LocalQueueSampler localQueueSampler = new LocalQueueSampler(localQueue);
                        mBeanServer.registerMBean(localQueueSampler, localQueueSamplerName);
                        boxedUnit2 = registeredMBeans.$plus$eq((Object)localQueueSamplerName);
                        continue;
                    }
                    catch (Throwable throwable) {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                }
                intersect = (JFunction0.mcV.sp & Serializable)() -> {
                    if (mBeanServer != null) {
                        registeredMBeans.foreach((Function1)(JProcedure1 & Serializable)mbean -> {
                            try {
                                mBeanServer.unregisterMBean((ObjectName)mbean);
                            }
                            catch (Throwable throwable) {}
                        });
                        return;
                    }
                };
            } else {
                intersect = (JFunction0.mcV.sp & Serializable)() -> {};
            }
        } else {
            intersect = (JFunction0.mcV.sp & Serializable)() -> {};
        }
        JFunction0.mcV.sp & Serializable unregisterMBeans = intersect;
        return Tuple2$.MODULE$.apply((Object)threadPool, () -> IORuntimeCompanionPlatform.createWorkStealingComputeThreadPool$$anonfun$1(threadPool, (Function0)unregisterMBeans));
    }

    public int createWorkStealingComputeThreadPool$default$1() {
        return Math.max(2, Runtime.getRuntime().availableProcessors());
    }

    public String createWorkStealingComputeThreadPool$default$2() {
        return "io-compute";
    }

    public String createWorkStealingComputeThreadPool$default$3() {
        return "io-compute-blocker";
    }

    public Duration createWorkStealingComputeThreadPool$default$4() {
        return new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds();
    }

    public Function1<Throwable, BoxedUnit> createWorkStealingComputeThreadPool$default$5() {
        return (JProcedure1 & Serializable)_$1 -> _$1.printStackTrace();
    }

    public boolean createWorkStealingComputeThreadPool$default$6() {
        return false;
    }

    public Tuple2<WorkStealingThreadPool, Function0<BoxedUnit>> createDefaultComputeThreadPool(Function0<IORuntime> self, int threads, String threadPrefix, String blockerThreadPrefix) {
        return this.createWorkStealingComputeThreadPool(threads, threadPrefix, blockerThreadPrefix, this.createWorkStealingComputeThreadPool$default$4(), this.createWorkStealingComputeThreadPool$default$5(), this.createWorkStealingComputeThreadPool$default$6());
    }

    public int createDefaultComputeThreadPool$default$2() {
        return Math.max(2, Runtime.getRuntime().availableProcessors());
    }

    public String createDefaultComputeThreadPool$default$3() {
        return "io-compute";
    }

    public String createDefaultComputeThreadPool$default$4() {
        return "io-compute-blocker";
    }

    public Tuple2<WorkStealingThreadPool, Function0<BoxedUnit>> createDefaultComputeThreadPool(Function0<IORuntime> self, int threads, String threadPrefix) {
        return this.createDefaultComputeThreadPool(self, threads, threadPrefix, this.createDefaultComputeThreadPool$default$4());
    }

    public Tuple2<ExecutionContext, Function0<BoxedUnit>> createDefaultBlockingExecutionContext(String threadPrefix) {
        return this.createDefaultBlockingExecutionContext(threadPrefix, (Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> _$2.printStackTrace());
    }

    public String createDefaultBlockingExecutionContext$default$1() {
        return "io-blocking";
    }

    public Tuple2<ExecutionContext, Function0<BoxedUnit>> createDefaultBlockingExecutionContext(String threadPrefix, Function1<Throwable, BoxedUnit> reportFailure) {
        AtomicInteger threadCount = new AtomicInteger(0);
        ExecutorService executor = Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r);
            t.setName(new StringBuilder(1).append(threadPrefix).append("-").append(threadCount.getAndIncrement()).toString());
            t.setDaemon(true);
            return t;
        });
        return Tuple2$.MODULE$.apply((Object)ExecutionContext$.MODULE$.fromExecutor((Executor)executor, reportFailure), (JFunction0.mcV.sp & Serializable)() -> executor.shutdown());
    }

    public Tuple2<Scheduler, Function0<BoxedUnit>> createDefaultScheduler(String threadPrefix) {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setName(threadPrefix);
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        });
        scheduler.setRemoveOnCancelPolicy(true);
        return Tuple2$.MODULE$.apply((Object)Scheduler$.MODULE$.fromScheduledExecutor(scheduler), (JFunction0.mcV.sp & Serializable)() -> scheduler.shutdown());
    }

    public String createDefaultScheduler$default$1() {
        return "io-scheduler";
    }

    public boolean installGlobal(Function0<IORuntime> global) {
        if (this._global == null) {
            this._global = (IORuntime)global.apply();
            return true;
        }
        return false;
    }

    public void resetGlobal() {
        this._global = null;
    }

    public IORuntime global() {
        if (this._global == null) {
            this.installGlobal((Function0<IORuntime>)((Function0 & Serializable)this::global$$anonfun$1));
        }
        return this._global;
    }

    public Function0<BoxedUnit> registerFiberMonitorMBean(FiberMonitor fiberMonitor) {
        if (TracingConstants.isStackTracing) {
            MBeanServer mBeanServer;
            MBeanServer mBeanServer2;
            try {
                mBeanServer2 = ManagementFactory.getPlatformMBeanServer();
            }
            catch (Throwable throwable) {
                mBeanServer2 = mBeanServer = null;
            }
            if (mBeanServer != null) {
                JFunction0.mcV.sp & Serializable intersect;
                String hash = RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(System.identityHashCode(fiberMonitor)));
                try {
                    ObjectName liveFiberSnapshotTriggerName = new ObjectName(new StringBuilder(57).append("cats.effect.unsafe.metrics:type=LiveFiberSnapshotTrigger-").append(hash).toString());
                    LiveFiberSnapshotTrigger liveFiberSnapshotTrigger = new LiveFiberSnapshotTrigger(fiberMonitor);
                    mBeanServer.registerMBean(liveFiberSnapshotTrigger, liveFiberSnapshotTriggerName);
                    intersect = (JFunction0.mcV.sp & Serializable)() -> {
                        try {
                            mBeanServer.unregisterMBean(liveFiberSnapshotTriggerName);
                        }
                        catch (Throwable throwable) {}
                    };
                }
                catch (Throwable throwable) {
                    intersect = (JFunction0.mcV.sp & Serializable)() -> {};
                }
                return intersect;
            }
            return (JFunction0.mcV.sp & Serializable)() -> {};
        }
        return (JFunction0.mcV.sp & Serializable)() -> {};
    }

    private static final MBeanServer liftedTree1$1() {
        MBeanServer mBeanServer;
        try {
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Throwable throwable) {
            mBeanServer = null;
        }
        return mBeanServer;
    }

    private static final /* synthetic */ void createWorkStealingComputeThreadPool$$anonfun$1(WorkStealingThreadPool threadPool$1, Function0 unregisterMBeans$1) {
        unregisterMBeans$1.apply$mcV$sp();
        threadPool$1.shutdown();
    }

    private final IORuntime global$$anonfun$1() {
        Tuple2<WorkStealingThreadPool, Function0<BoxedUnit>> tuple2 = this.createWorkStealingComputeThreadPool(this.createWorkStealingComputeThreadPool$default$1(), this.createWorkStealingComputeThreadPool$default$2(), this.createWorkStealingComputeThreadPool$default$3(), this.createWorkStealingComputeThreadPool$default$4(), this.createWorkStealingComputeThreadPool$default$5(), this.createWorkStealingComputeThreadPool$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WorkStealingThreadPool compute = (WorkStealingThreadPool)tuple2._1();
        Function0 computeDown = (Function0)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)compute, (Object)computeDown);
        WorkStealingThreadPool compute2 = (WorkStealingThreadPool)tuple22._1();
        Function0 computeDown2 = (Function0)tuple22._2();
        Tuple2<ExecutionContext, Function0<BoxedUnit>> tuple23 = this.createDefaultBlockingExecutionContext(this.createDefaultBlockingExecutionContext$default$1());
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        ExecutionContext blocking = (ExecutionContext)tuple23._1();
        Function0 blockingDown = (Function0)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)blocking, (Object)blockingDown);
        ExecutionContext blocking2 = (ExecutionContext)tuple24._1();
        Function0 blockingDown2 = (Function0)tuple24._2();
        JFunction0.mcV.sp & Serializable shutdown = (JFunction0.mcV.sp & Serializable)() -> {
            computeDown2.apply$mcV$sp();
            blockingDown2.apply$mcV$sp();
            this.resetGlobal();
        };
        return IORuntime$.MODULE$.apply(compute2, blocking2, compute2, (Function0<BoxedUnit>)shutdown, IORuntimeConfig$.MODULE$.apply());
    }
}

