/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thisptr.jackson.jq.Version;

public class VersionRange {
    private final Version minVersion;
    private final boolean minInclusive;
    private final Version maxVersion;
    private final boolean maxInclusive;
    public static Pattern VERSION_RANGE_PATTERN = Pattern.compile("([\\[\\(])\\s*([0-9]\\.[0-9])?\\s*,\\s*([0-9]\\.[0-9])?([\\]\\)])");

    public VersionRange(Version minVersion, boolean minInclusive, Version maxVersion, boolean maxInclusive) {
        this.minVersion = minVersion;
        this.minInclusive = minInclusive;
        this.maxVersion = maxVersion;
        this.maxInclusive = maxInclusive;
    }

    public boolean contains(Version version) {
        int r;
        if (this.minVersion != null && ((r = version.compareTo(this.minVersion)) < 0 || !this.minInclusive && r == 0)) {
            return false;
        }
        return this.maxVersion == null || (r = this.maxVersion.compareTo(version)) >= 0 && (this.maxInclusive || r != 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maxInclusive ? 1231 : 1237);
        result = 31 * result + (this.maxVersion == null ? 0 : this.maxVersion.hashCode());
        result = 31 * result + (this.minInclusive ? 1231 : 1237);
        result = 31 * result + (this.minVersion == null ? 0 : this.minVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        if (this.maxInclusive != other.maxInclusive) {
            return false;
        }
        if (this.maxVersion == null ? other.maxVersion != null : !this.maxVersion.equals(other.maxVersion)) {
            return false;
        }
        if (this.minInclusive != other.minInclusive) {
            return false;
        }
        return !(this.minVersion == null ? other.minVersion != null : !this.minVersion.equals(other.minVersion));
    }

    public static VersionRange valueOf(String text) {
        Matcher m = VERSION_RANGE_PATTERN.matcher(text);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid VersionRange: " + text);
        }
        String minInclusive = m.group(1);
        String minVersion = m.group(2);
        String maxVersion = m.group(3);
        String maxInclusive = m.group(4);
        return new VersionRange(minVersion != null && !minVersion.isEmpty() ? Version.valueOf(minVersion) : null, "[".equals(minInclusive), maxVersion != null && !maxVersion.isEmpty() ? Version.valueOf(maxVersion) : null, "]".equals(maxInclusive));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.minInclusive ? "[" : "(");
        builder.append(this.minVersion != null ? this.minVersion : "");
        builder.append(",");
        builder.append(this.maxVersion != null ? this.maxVersion : "");
        builder.append(this.maxInclusive ? "]" : ")");
        return builder.toString();
    }
}

