/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.auto.service.AutoService;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.functions.IndicesFunction;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"index/1"})
@AutoService(value={Function.class})
public class IndexFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        if (in.isNull()) {
            output.emit(NullNode.getInstance(), null);
            return;
        }
        args.get(0).apply(scope, in, needle -> {
            List<Integer> tmp = IndicesFunction.indices(needle, in);
            if (tmp.isEmpty()) {
                output.emit(NullNode.getInstance(), null);
            } else {
                output.emit(new IntNode(tmp.get(0)), null);
            }
        });
    }
}

