/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.operators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.operators.BinaryOperator;

public abstract class ComparisonOperator
implements BinaryOperator {
    private static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();
    private String image;

    public ComparisonOperator(String image) {
        this.image = image;
    }

    protected abstract boolean test(int var1);

    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        int r = comparator.compare(lhs, rhs);
        return BooleanNode.valueOf(this.test(r));
    }

    @Override
    public String image() {
        return this.image;
    }
}

