/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.tree.FieldConstruction;
import net.thisptr.jackson.jq.path.Path;

public class ObjectConstruction
implements Expression {
    public final List<FieldConstruction> fields = new ArrayList<FieldConstruction>();

    public void add(FieldConstruction field) {
        this.fields.add(field);
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path ipath, PathOutput output, boolean requirePath) throws JsonQueryException {
        LinkedHashMap<String, JsonNode> tmp = new LinkedHashMap<String, JsonNode>(this.fields.size());
        ObjectConstruction.applyRecursive(scope, in, output, this.fields, tmp);
    }

    private static void applyRecursive(Scope scope, JsonNode in, PathOutput output, List<FieldConstruction> fields, Map<String, JsonNode> tmp) throws JsonQueryException {
        if (fields.isEmpty()) {
            ObjectNode obj = scope.getObjectMapper().createObjectNode();
            for (Map.Entry<String, JsonNode> e : tmp.entrySet()) {
                obj.set(e.getKey(), e.getValue());
            }
            output.emit(obj, null);
            return;
        }
        fields.get(0).evaluate(scope, in, (k, v) -> {
            tmp.put(k, v);
            ObjectConstruction.applyRecursive(scope, in, output, fields.subList(1, fields.size()), tmp);
            tmp.remove(k);
        });
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        String sep = "";
        for (FieldConstruction field : this.fields) {
            builder.append(sep);
            builder.append(field);
            sep = ",";
        }
        builder.append("}");
        return builder.toString();
    }
}

