/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.azure.commons.auth.blob;

import com.sos.commons.httpclient.azure.commons.auth.AAzureStorageAuthProvider;
import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobSASAuthTokenResolver;
import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobStorageClientAuthMethod;
import com.sos.commons.util.loggers.base.ISOSLogger;
import java.util.Map;

public class AzureBlobSASAuthProvider
extends AAzureStorageAuthProvider {
    private final String sasToken;

    public AzureBlobSASAuthProvider(ISOSLogger logger, String accountName, String base64AccountKey, String apiVersion, String sasToken) throws Exception {
        super(logger, AzureBlobStorageClientAuthMethod.SAS_TOKEN, accountName, base64AccountKey, apiVersion);
        this.sasToken = this.format(sasToken);
    }

    @Override
    public Map<String, String> createAuthHeaders(String method, String url, String canonicalizedResource, Map<String, String> existingHeaders, long contentLength) throws Exception {
        return existingHeaders;
    }

    @Override
    public String appendToUrl(String rawUrl) {
        return rawUrl.contains("?") ? rawUrl + "&" + this.sasToken.substring(1) : rawUrl + this.sasToken;
    }

    private String format(String sasToken) throws Exception {
        String resolved = AzureBlobSASAuthTokenResolver.resolveToken(this, sasToken);
        return resolved.startsWith("?") ? resolved : "?" + resolved;
    }
}

