/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.azure.commons.auth.blob;

import com.sos.commons.httpclient.azure.AzureBlobStorageClient;
import com.sos.commons.httpclient.azure.commons.auth.AAzureStorageAuthProvider;
import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobStorageClientAuthMethod;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class AzureBlobSharedKeyAuthProvider
extends AAzureStorageAuthProvider {
    private static final String HEADER_X_MS_DATE = "x-ms-date";
    private static final String HEADER_X_MS_VERSION = "x-ms-version";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.ENGLISH).withZone(ZoneOffset.UTC);

    public AzureBlobSharedKeyAuthProvider(ISOSLogger logger, String accountName, String base64AccountKey, String apiVersion) {
        super(logger, AzureBlobStorageClientAuthMethod.SHARED_KEY, accountName, base64AccountKey, apiVersion);
    }

    @Override
    public Map<String, String> createAuthHeaders(String method, String url, String canonicalizedEncodedResource, Map<String, String> existingHeaders, long contentLength) throws Exception {
        Map headers = HttpUtils.normalizeHeaderKeys(existingHeaders);
        if (!headers.containsKey(HEADER_X_MS_DATE)) {
            headers.put(HEADER_X_MS_DATE, FORMATTER.format(ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(5L)));
        }
        if (!headers.containsKey(HEADER_X_MS_VERSION)) {
            headers.put(HEADER_X_MS_VERSION, this.getApiVersion());
        }
        String canonicalizedHeaders = this.buildCanonicalizedHeaders(headers);
        String stringToSign = this.buildStringToSign(method, headers, canonicalizedHeaders, canonicalizedEncodedResource, contentLength);
        if (this.getLogger().isDebugEnabled()) {
            // empty if block
        }
        String signature = this.signString(stringToSign);
        headers.put("authorization", "SharedKey " + this.getAccountName() + ":" + signature);
        return headers;
    }

    @Override
    public String appendToUrl(String rawUrl) {
        return rawUrl;
    }

    private String buildCanonicalizedHeaders(Map<String, String> headers) {
        TreeMap sorted = new TreeMap();
        headers.forEach((k, v) -> {
            if (k.startsWith("x-ms-")) {
                sorted.put(k, v.trim());
            }
        });
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : sorted.entrySet()) {
            sb.append((String)e.getKey()).append(":").append((String)e.getValue()).append("\n");
        }
        return sb.toString();
    }

    private String buildStringToSign(String method, Map<String, String> headers, String canonicalizedHeaders, String canonicalizedEncodedResource, long contentLength) {
        StringBuilder sb = new StringBuilder();
        sb.append(method).append("\n");
        sb.append(headers.getOrDefault("content-encoding", "")).append("\n");
        sb.append(headers.getOrDefault("content-language", "")).append("\n");
        if (contentLength > 0L) {
            sb.append(String.valueOf(contentLength)).append("\n");
        } else {
            sb.append(AzureBlobStorageClient.getContentLengthHeaderValue(headers.getOrDefault("content-length", ""))).append("\n");
        }
        sb.append(headers.getOrDefault("content-md5", "")).append("\n");
        sb.append(headers.getOrDefault("content-type", "")).append("\n");
        sb.append(headers.getOrDefault("date", "")).append("\n");
        sb.append(headers.getOrDefault("if-modified-since", "")).append("\n");
        sb.append(headers.getOrDefault("if-match", "")).append("\n");
        sb.append(headers.getOrDefault("if-none-match", "")).append("\n");
        sb.append(headers.getOrDefault("if-unmodified-since", "")).append("\n");
        sb.append(headers.getOrDefault("range", "")).append("\n");
        sb.append(canonicalizedHeaders).append(canonicalizedEncodedResource);
        return sb.toString();
    }
}

