/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSString;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.JobEnvironment;
import com.sos.js7.job.JobHelper;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.ValueSource;
import com.sos.js7.job.exception.JobArgumentException;
import com.sos.js7.job.exception.JobException;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;
import com.sos.js7.job.resolver.JobArgumentValueResolverCache;
import io.vavr.control.Either;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import js7.base.problem.Problem;
import js7.data.value.Value;
import js7.data_for_java.order.JOutcome;
import js7.launcher.forjava.internal.BlockingInternalJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job<A extends JobArguments>
implements BlockingInternalJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(Job.class);
    public static final String OPERATION_CANCEL_KILL = "cancel/kill";
    private JobEnvironment<A> jobEnvironment;

    @Deprecated
    public Job() {
        this(null);
    }

    public Job(BlockingInternalJob.JobContext jobContext) {
        this.jobEnvironment = new JobEnvironment(jobContext);
    }

    protected void setJobEnvironment(JobEnvironment<A> je) {
        this.jobEnvironment = je;
    }

    public void onStart() throws Exception {
    }

    public void onStop() throws Exception {
    }

    public void onOrderProcessCancel(OrderProcessStep<A> step) throws Exception {
    }

    public abstract void processOrder(OrderProcessStep<A> var1) throws Exception;

    public JobEnvironment<A> getJobEnvironment() {
        return this.jobEnvironment;
    }

    public Either<Problem, Void> start() {
        try {
            ArrayList<JobArgumentException> exceptions = new ArrayList<JobArgumentException>();
            this.jobEnvironment.setDeclaredArguments(this.createDeclaredJobArgumentsOnStart(exceptions));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[start]%s", this.jobEnvironment.getJobKey()));
            }
            this.onStart();
            return Either.right(null);
        }
        catch (Throwable e) {
            return Either.left((Object)Problem.fromThrowable((Throwable)((Object)new JobException("[onStart]" + e.toString(), e))));
        }
    }

    public void stop() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[stop]%s", this.jobEnvironment.getJobKey()));
        }
        this.onStop();
    }

    public A onCreateJobArguments(List<JobArgumentException> exceptions, OrderProcessStep<A> step) throws Exception {
        return null;
    }

    public BlockingInternalJob.OrderProcess toOrderProcess(final BlockingInternalJob.Step internalStep) {
        return new BlockingInternalJob.InterruptibleOrderProcess(){
            volatile boolean canceled = false;
            AtomicReference<OrderProcessStep<A>> orderProcessStepRef = null;

            public JOutcome.Completed runInterruptible() throws Exception {
                if (!this.canceled) {
                    JobArguments.MockLevel mockLevel = JobArguments.MockLevel.OFF;
                    OrderProcessStep step = new OrderProcessStep(Job.this.jobEnvironment, internalStep);
                    this.orderProcessStepRef = new AtomicReference(step);
                    try {
                        ArrayList<JobArgumentException> exceptions = new ArrayList<JobArgumentException>();
                        Object args = Job.this.onCreateJobArguments(exceptions, step);
                        args = Job.this.createDeclaredJobArguments(exceptions, step, args);
                        step.init(args);
                        mockLevel = (JobArguments.MockLevel)((Object)((JobArguments)step.getDeclaredArguments()).getMockLevel().getValue());
                        switch (mockLevel) {
                            case OFF: {
                                step.checkAndLogParameterization(exceptions, null);
                                Job.this.processOrder(step);
                                return step.processed();
                            }
                            case ERROR: {
                                step.checkAndLogParameterization(exceptions, String.format("Mock Execution: %s=%s.", new Object[]{((JobArguments)step.getDeclaredArguments()).getMockLevel().getName(), mockLevel}));
                                return step.success();
                            }
                        }
                        step.checkAndLogParameterization(null, String.format("Mock Execution: %s=%s.", new Object[]{((JobArguments)step.getDeclaredArguments()).getMockLevel().getName(), mockLevel}));
                        return step.success();
                    }
                    catch (Throwable e) {
                        switch (mockLevel) {
                            case OFF: 
                            case ERROR: {
                                return step.failed(e.toString(), e);
                            }
                        }
                        step.getLogger().info(String.format("Mock Execution: %s=%s, Exception: %s", new Object[]{((JobArguments)step.getDeclaredArguments()).getMockLevel().getName(), mockLevel, e.toString()}));
                        return step.success();
                    }
                }
                return JOutcome.failed((String)"Canceled");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel(boolean immediately) {
                try {
                    if (this.orderProcessStepRef != null && !this.canceled) {
                        Thread thread;
                        OrderProcessStep orderProcessStep = this.orderProcessStepRef.get();
                        boolean log = false;
                        if (orderProcessStep != null) {
                            log = true;
                            Job.this.cancelOrderProcessStep(orderProcessStep);
                        }
                        if ((thread = this.thread()) == null) {
                            if (log) {
                                orderProcessStep.getLogger().info("[cancel/kill][thread][skip interrupt]thread not found");
                            }
                        } else {
                            if (log) {
                                orderProcessStep.getLogger().info("[cancel/kill][thread][" + thread.getName() + "]interrupt ...");
                            }
                            thread.interrupt();
                        }
                    }
                }
                finally {
                    this.canceled = true;
                }
            }
        };
    }

    protected void cancelOrderProcessStep(OrderProcessStep<A> jobStep) {
        String jobName = this.getJobName(jobStep);
        try {
            this.onOrderProcessCancel(jobStep);
        }
        catch (Throwable e) {
            jobStep.getLogger().error(String.format("[%s][job name=%s][onOrderProcessCancel]%s", OPERATION_CANCEL_KILL, jobName, e.toString()), e);
        }
        jobStep.cancelExecuteJobs();
    }

    private String getJobName(OrderProcessStep<A> jobStep) {
        try {
            return jobStep == null ? "unknown" : jobStep.getJobName();
        }
        catch (Throwable e) {
            return "unknown";
        }
    }

    private Map<String, Object> mergeJobAndStepArguments(OrderProcessStep<A> step) {
        Set stepArgs = step.getInternalStep().arguments().entrySet();
        Set orderArgs = step.getInternalStep().order().arguments().entrySet();
        Stream stream = null;
        stream = SOSCollection.isEmpty(this.jobEnvironment.getEngineArguments()) ? Stream.concat(stepArgs.stream(), orderArgs.stream()) : Stream.concat(Stream.concat(this.jobEnvironment.getEngineArguments().entrySet().stream(), stepArgs.stream()), orderArgs.stream());
        return JobHelper.asJavaValues(stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> value2)));
    }

    private A createDeclaredJobArgumentsOnStart(List<JobArgumentException> exceptions) throws Exception {
        return this.createDeclaredJobArguments(exceptions, null, null);
    }

    protected A createDeclaredJobArguments(List<JobArgumentException> exceptions, OrderProcessStep<A> step, A instance) throws Exception {
        Object object = instance = instance == null ? (JobArguments)this.getJobArgumensClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : instance;
        if (this.jobEnvironment.getEngineArguments() == null && step == null) {
            return instance;
        }
        if (step == null) {
            Map<String, Object> map = this.jobEnvironment.getAllArgumentsAsNameValueMap();
            return this.setDeclaredJobArguments(exceptions, instance, map, null);
        }
        Map<String, Object> map = this.mergeJobAndStepArguments(step);
        return this.setDeclaredJobArguments(exceptions, instance, map, step);
    }

    protected A setDeclaredJobArguments(List<JobArgumentException> exceptions, A instance, Map<String, Object> args, OrderProcessStep<A> step) throws Exception {
        if (((JobArguments)instance).getIncludedArguments() != null && ((JobArguments)instance).getIncludedArguments().size() > 0) {
            for (Map.Entry entry : ((JobArguments)instance).getIncludedArguments().entrySet()) {
                for (JobArgument arg : (List)entry.getValue()) {
                    arg.setPayload((String)entry.getKey());
                    this.setDeclaredJobArgument(args, arg, null, step);
                }
            }
        }
        if (((JobArguments)instance).hasDynamicArgumentFields()) {
            for (JobArgument jobArgument : ((JobArguments)instance).getDynamicArgumentFields()) {
                jobArgument.reset();
                this.setDeclaredJobArgument(args, jobArgument, null, step);
            }
        }
        List<Field> fields = JobHelper.getJobArgumentFields(instance);
        for (Field field : fields) {
            try {
                JobArgument arg;
                field.setAccessible(true);
                arg = (JobArgument)((Object)field.get(instance));
                if (arg == null) continue;
                this.setDeclaredJobArgument(args, arg, field, step);
                field.set(instance, (Object)arg);
            }
            catch (JobRequiredArgumentMissingException e) {
                exceptions.add(e);
            }
            catch (Throwable e) {
                exceptions.add(new JobArgumentException(String.format("[%s.%s][can't get or set field]%s", this.getClass().getName(), field.getName(), e.toString()), e));
            }
        }
        return instance;
    }

    protected <V> void setDeclaredJobArgument(Map<String, Object> args, JobArgument<V> arg, Field field, OrderProcessStep<A> step) throws Exception {
        if (arg.getName() == null) {
            return;
        }
        if (!arg.isScopeAll()) {
            return;
        }
        if (step == null) {
            if (arg.getName() != null) {
                Object val;
                ArrayList<String> allNames = new ArrayList<String>(Arrays.asList(arg.getName()));
                if (arg.getNameAliases() != null) {
                    allNames.addAll(arg.getNameAliases());
                }
                if ((val = this.fromMap(this.jobEnvironment.getAllArgumentsAsNameValueMap(), allNames)) == null) {
                    arg.setValue(arg.getDefaultValue());
                    this.setDeclaredArgumentValueType(arg, field, arg.getValue());
                } else {
                    arg.setValue(this.getDeclaredArgumentValue(step, arg, field, val));
                    this.setValueSource(arg, new ValueSource(ValueSource.ValueSourceType.JOB_ARGUMENT));
                }
            }
        } else {
            DetailValue jdv;
            if (step.hasExecuteJobArguments() && step.getExecuteJobBean().getArguments().containsKey(arg.getName())) {
                JobArgument<?> a = step.getExecuteJobBean().getArguments().get(arg.getName());
                try {
                    arg.setValue(this.getDeclaredArgumentValue(step, arg, field, a.getValue()));
                    if (step.getExecuteJobBean().updateDeclaredArgumentsDefinition()) {
                        arg.setRequired(a.isRequired());
                        arg.setDefaultValue(a.getDefaultValue());
                        arg.setDisplayMode(a.getDisplayMode());
                        arg.setValueSource(a.getValueSource());
                    }
                    if (arg.isRequired() && arg.getValue() == null) {
                        throw new JobRequiredArgumentMissingException(arg.getName(), arg.getName());
                    }
                }
                catch (Throwable e) {
                    arg.setNotAcceptedValue(a.getValue(), e);
                }
                return;
            }
            ArrayList<String> allNames = new ArrayList<String>(Arrays.asList(arg.getName()));
            if (arg.getNameAliases() != null) {
                allNames.addAll(arg.getNameAliases());
            }
            if ((jdv = this.fromMap(step.getLastSucceededOutcomes(), allNames)) != null) {
                arg.setValue(this.getDeclaredArgumentValue(step, arg, field, jdv.getValue()));
                ValueSource vs = new ValueSource(ValueSource.ValueSourceType.LAST_SUCCEEDED_OUTCOME);
                vs.setSource(jdv.getSource());
                this.setValueSource(arg, vs);
            } else {
                Object val = step.getNamedValue(arg);
                boolean isNamedValue = false;
                if (val == null) {
                    val = this.fromMap(args, allNames);
                } else {
                    isNamedValue = true;
                }
                if (val == null || SOSString.isEmpty((String)val.toString())) {
                    arg.setValue(arg.getDefaultValue());
                    this.setDeclaredArgumentValueType(arg, field, arg.getValue());
                } else {
                    arg.setValue(this.getDeclaredArgumentValue(step, arg, field, val));
                }
                this.setDeclaredArgumentValueSource(step, field, arg, allNames, isNamedValue, step.getJobResourcesArgumentsAsNameDetailValueMap());
                if (arg.isRequired() && arg.getValue() == null) {
                    throw new JobRequiredArgumentMissingException(arg.getName(), arg.getName());
                }
            }
        }
    }

    private <T> T fromMap(Map<String, T> map, List<String> list) {
        if (map == null || list == null) {
            return null;
        }
        return list.stream().filter(map::containsKey).findFirst().map(map::get).orElse(null);
    }

    private String getClassName(Object val) {
        if (val == null) {
            return null;
        }
        try {
            return val.getClass().getName();
        }
        catch (Throwable e) {
            return e.toString();
        }
    }

    private <V> V getDeclaredArgumentValue(OrderProcessStep<A> step, JobArgument<V> arg, Field field, Object val) throws ClassNotFoundException {
        boolean isTraceEnabled;
        boolean bl = isTraceEnabled = step != null && step.getLogger().isTraceEnabled();
        if (isTraceEnabled) {
            step.getLogger().trace(String.format("[getDeclaredArgumentValue][%s][arg value=%s(%s),defaultValue=%s(%s)]val=%s(%s)", arg.getName(), arg.getValue(), this.getClassName(arg.getValue()), arg.getDefaultValue(), this.getClassName(arg.getDefaultValue()), val, this.getClassName(val)));
        }
        try {
            this.setDeclaredArgumentValueType(arg, field, val);
            if (isTraceEnabled) {
                step.getLogger().trace(String.format("    [getDeclaredArgumentValue][%s]clazzType=%s,argumentType=%s,argumentFlatType=%s", new Object[]{arg.getName(), arg.getClazzType(), arg.getArgumentType(), arg.getArgumentFlatType()}));
            }
            switch (arg.getArgumentType()) {
                case FLAT: {
                    if (this.hasValueStartsWith(step, val)) break;
                    val = JobArgument.convertFlatValue(arg, val);
                    break;
                }
                case LIST: {
                    if (val instanceof List) {
                        val = this.convertListValue(step, arg, val);
                        break;
                    }
                    val = this.convertCollectionStringValue(step, arg, val);
                    break;
                }
                case SET: {
                    val = this.convertCollectionStringValue(step, arg, val);
                    break;
                }
                case MAP: {
                    val = this.convertMapValue(step, arg, val);
                }
            }
        }
        catch (Throwable e) {
            arg.setNotAcceptedValue(val, e);
            arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
            val = arg.getDefaultValue();
        }
        return (V)val;
    }

    private <V> V convertCollectionStringValue(OrderProcessStep<A> step, JobArgument<V> arg, Object val) {
        String valAsString = val.toString();
        try {
            Stream<Object> stream = Stream.of(valAsString.split(";")).map(v -> {
                try {
                    if (this.hasValueStartsWith(step, v)) {
                        return v;
                    }
                    return JobArgument.convertFlatValue(arg, v);
                }
                catch (Throwable e) {
                    arg.setNotAcceptedValue(v + " of " + valAsString, e);
                    arg.getNotAcceptedValue().setSource(arg.getValueSource());
                    arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
                    return null;
                }
            }).filter(Objects::nonNull);
            val = arg.isSet() ? stream.collect(Collectors.toSet()) : stream.collect(Collectors.toList());
        }
        catch (Throwable e) {
            arg.setNotAcceptedValue(valAsString, e);
            arg.getNotAcceptedValue().setSource(arg.getValueSource());
            arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
            val = arg.getDefaultValue();
        }
        return (V)val;
    }

    private <V> V convertListValue(OrderProcessStep<A> step, JobArgument<V> arg, Object val) {
        String valAsString = val.toString();
        try {
            val = ((List)val).stream().map(entry -> {
                try {
                    if (this.hasValueStartsWith(step, entry)) {
                        return entry;
                    }
                    return JobArgument.convertFlatValue(arg, entry);
                }
                catch (Throwable e) {
                    arg.setNotAcceptedValue(entry + " of " + valAsString, e);
                    arg.getNotAcceptedValue().setSource(arg.getValueSource());
                    arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Throwable e) {
            arg.setNotAcceptedValue(valAsString, e);
            arg.getNotAcceptedValue().setSource(arg.getValueSource());
            arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
            val = arg.getDefaultValue();
        }
        return (V)val;
    }

    private <V> V convertMapValue(OrderProcessStep<A> step, JobArgument<V> arg, Object val) {
        String valAsString = val.toString();
        try {
            val = ((Map)val).entrySet().stream().map(entry -> {
                try {
                    if (this.hasValueStartsWith(step, entry.getValue())) {
                        return Map.entry((String)entry.getKey(), entry.getValue());
                    }
                    return Map.entry((String)entry.getKey(), JobArgument.convertFlatValue(arg, entry.getValue()));
                }
                catch (Throwable e) {
                    arg.setNotAcceptedValue(entry.getValue() + " of " + valAsString, e);
                    arg.getNotAcceptedValue().setSource(arg.getValueSource());
                    arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (Throwable e) {
            arg.setNotAcceptedValue(valAsString, e);
            arg.getNotAcceptedValue().setSource(arg.getValueSource());
            arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
            val = arg.getDefaultValue();
        }
        return (V)val;
    }

    private <V> boolean hasValueStartsWith(OrderProcessStep<A> step, Object val) {
        if (step == null) {
            return false;
        }
        String valueAsStr = val.toString();
        return step.getResolverPrefixes().parallelStream().anyMatch(valueAsStr::startsWith);
    }

    private <V> void setDeclaredArgumentValueType(JobArgument<V> arg, Field field, Object val) throws Exception {
        if (field == null) {
            this.setDeclaredArgumentValueType(arg, val);
            return;
        }
        arg.setClazzType(((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
        arg.setArgumentType();
    }

    private <V> void setDeclaredArgumentValueType(JobArgument<V> arg, Object val) throws Exception {
        if (arg.getClazzType() == null) {
            if (arg.getValue() != null) {
                try {
                    arg.setClazzType(arg.getValue().getClass());
                }
                catch (Throwable throwable) {}
            } else if (val != null) {
                try {
                    arg.setClazzType(val.getClass());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (arg.getClazzType() == null) {
                arg.setClazzType((Type)((Object)Object.class));
            }
        }
        arg.setArgumentType();
    }

    private <V> void setDeclaredArgumentValueSource(OrderProcessStep<A> step, Field field, JobArgument<V> arg, List<String> allNames, boolean isNamedValue, Map<String, DetailValue> jobResources) {
        ValueSource source;
        block9: {
            if (arg.getName() == null || step.getInternalStep() == null) {
                return;
            }
            source = null;
            Value v = null;
            if (isNamedValue) {
                v = (Value)this.fromMap(step.getInternalStep().order().arguments(), allNames);
                source = v == null ? new ValueSource(ValueSource.ValueSourceType.ORDER_OR_NODE) : new ValueSource(ValueSource.ValueSourceType.ORDER);
            } else {
                DetailValue dv;
                if (this.jobEnvironment.getEngineArguments() != null && (v = this.fromMap(this.jobEnvironment.getEngineArguments(), allNames)) != null) {
                    source = new ValueSource(ValueSource.ValueSourceType.JOB_ARGUMENT);
                }
                if ((v = (Value)this.fromMap(step.getInternalStep().arguments(), allNames)) != null) {
                    source = new ValueSource(ValueSource.ValueSourceType.JOB);
                }
                if (source == null && arg.getValueSource().isTypeJAVA() && (dv = this.fromMap(jobResources, allNames)) != null) {
                    try {
                        arg.setValue(this.getDeclaredArgumentValue(step, arg, field, dv.getValue()));
                        source = new ValueSource(ValueSource.ValueSourceType.JOB_RESOURCE);
                        source.setSource(dv.getSource());
                    }
                    catch (ClassNotFoundException e) {
                        if (step == null) break block9;
                        step.getLogger().error(String.format("[%s]%s", arg.getName(), e.toString()), e);
                    }
                }
            }
        }
        if (source != null) {
            this.setValueSource(arg, source);
        }
    }

    private <V> void setValueSource(JobArgument<V> arg, ValueSource source) {
        if (arg.getNotAcceptedValue() != null) {
            arg.getNotAcceptedValue().setSource(source);
            if (arg.getNotAcceptedValue().getUsedValueSource() == null) {
                arg.getNotAcceptedValue().setUsedValueSource(source);
            }
        } else {
            arg.setValueSource(source);
        }
    }

    protected Class<A> getJobArgumensClass() throws JobArgumentException {
        try {
            for (Class<?> clazz = this.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                ParameterizedType pt;
                Type rawType;
                Type genericSuperclass = clazz.getGenericSuperclass();
                if (!(genericSuperclass instanceof ParameterizedType) || !((rawType = (pt = (ParameterizedType)genericSuperclass).getRawType()) instanceof Class) || !Job.class.isAssignableFrom((Class)rawType)) continue;
                try {
                    return (Class)pt.getActualTypeArguments()[0];
                }
                catch (Throwable e) {
                    return JobArguments.class;
                }
            }
            throw new JobArgumentException(String.format("%s superclass with type parameter not found for %s", Job.class.getSimpleName(), this.getClass()));
        }
        catch (Throwable e) {
            throw new JobArgumentException(String.format("Can't evaluate JobArguments class for job %s: %s", this.getClass().getName(), e.toString()), e);
        }
    }

    static {
        JobArgumentValueResolverCache.initialize();
    }
}

