/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.sos.commons.util.SOSReflection;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.js7.job.JobArgumentValueIterator;
import com.sos.js7.job.ValueSource;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JobArgument<T>
extends SOSArgument<T> {
    private final List<String> nameAliases;
    private ValueSource valueSource;
    private NotAcceptedValue notAcceptedValue;
    private Type type = Type.DECLARED;
    private ArgumentType argumentType;
    private ArgumentFlatType argumentFlatType;
    private Scope scope;

    public JobArgument(String name) {
        this(name, false, null, SOSArgument.DisplayMode.UNMASKED, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required) {
        this(name, required, null, SOSArgument.DisplayMode.UNMASKED, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required, List<String> nameAliases) {
        this(name, required, null, SOSArgument.DisplayMode.UNMASKED, nameAliases, Scope.ALL);
    }

    public JobArgument(String name, boolean required, T defaultValue) {
        this(name, required, defaultValue, SOSArgument.DisplayMode.UNMASKED, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required, T defaultValue, List<String> nameAliases) {
        this(name, required, defaultValue, SOSArgument.DisplayMode.UNMASKED, nameAliases, Scope.ALL);
    }

    public JobArgument(String name, boolean required, SOSArgument.DisplayMode displayMode) {
        this(name, required, null, displayMode, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required, SOSArgument.DisplayMode displayMode, List<String> nameAliases) {
        this(name, required, null, displayMode, nameAliases, Scope.ALL);
    }

    public JobArgument(String name, boolean required, T defaultValue, SOSArgument.DisplayMode displayMode) {
        this(name, required, defaultValue, displayMode, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required, T defaultValue, SOSArgument.DisplayMode displayMode, List<String> nameAliases) {
        this(name, required, defaultValue, displayMode, nameAliases, Scope.ALL);
    }

    private JobArgument(String name, boolean required, T defaultValue, SOSArgument.DisplayMode displayMode, List<String> nameAliases, Scope scope) {
        super(name, required, defaultValue, displayMode);
        this.scope = scope;
        this.valueSource = new ValueSource(ValueSource.ValueSourceType.JAVA);
        this.nameAliases = nameAliases;
    }

    public boolean isFlat() {
        return ArgumentType.FLAT.equals((Object)this.argumentType);
    }

    public boolean isMap() {
        return ArgumentType.MAP.equals((Object)this.argumentType);
    }

    public boolean isList() {
        return ArgumentType.LIST.equals((Object)this.argumentType);
    }

    public boolean isSet() {
        return ArgumentType.SET.equals((Object)this.argumentType);
    }

    public boolean isCollection() {
        return this.isList() || this.isSet();
    }

    public void applyValue(String val) throws Exception {
        super.setValue(JobArgument.convertFlatValue(this, val));
    }

    public JobArgumentValueIterator newValueIterator() {
        return this.newValueIterator(null);
    }

    public JobArgumentValueIterator newValueIterator(String prefix) {
        return new JobArgumentValueIterator(this, prefix);
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public Type getType() {
        return this.type;
    }

    public ArgumentType getArgumentType() {
        return this.argumentType;
    }

    public ArgumentFlatType getArgumentFlatType() {
        return this.argumentFlatType;
    }

    public void setNotAcceptedValue(JobArgumentValueIterator iterator, Throwable exception) {
        this.setNotAcceptedValue(iterator.current(), exception);
    }

    public void setNotAcceptedValue(Object value, Throwable exception) {
        if (this.notAcceptedValue == null) {
            this.notAcceptedValue = new NotAcceptedValue(value, exception);
        } else {
            this.notAcceptedValue.getValues().add(value);
        }
    }

    private Scope getScope() {
        return this.scope;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean displayIfUnknown) {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("[");
        sb.append("value=");
        if (displayIfUnknown) {
            sb.append(this.getDisplayValueIgnoreUnknown());
        } else {
            sb.append(this.getDisplayValue());
        }
        if (this.valueSource != null && this.valueSource.getType() != null) {
            sb.append(" source=").append(this.valueSource.getType().name());
            if (this.valueSource.getSource() != null) {
                sb.append("(").append(this.valueSource.getSource()).append(")");
            }
        }
        if (this.isRequired()) {
            sb.append(" required=true");
        }
        sb.append(" modified=").append(this.isDirty());
        if (this.argumentType != null) {
            sb.append(" argumentType=").append((Object)this.argumentType);
        }
        if (this.argumentFlatType != null) {
            sb.append(" argumentFlatType=").append((Object)this.argumentFlatType);
        }
        if (this.getClazzType() != null) {
            sb.append(" ").append(this.getClazzType().getTypeName());
        }
        if (this.getPayload() != null) {
            sb.append(" class=").append(SOSArgumentHelper.getClassName((String)this.getPayload().toString()));
        }
        if (this.notAcceptedValue != null) {
            sb.append("(value=").append(this.notAcceptedValue.getDisplayValue()).append(" ignored");
            if (this.notAcceptedValue.exception != null) {
                sb.append("(").append(this.notAcceptedValue.exception.toString()).append(")");
            }
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    protected static <T> JobArgument<T> toUndeclaredExecuteJobArgument(String name, Object value) {
        JobArgument<Object> arg = new JobArgument<Object>(name, false, null, SOSArgument.DisplayMode.UNKNOWN, null, Scope.ALL);
        arg.applyValue(value);
        return arg.toUndeclaredExecuteJobArgument();
    }

    protected JobArgument<T> toUndeclaredExecuteJobArgument() {
        return this.toUndeclaredExecuteJobArgument(this);
    }

    protected List<String> getNameAliases() {
        return this.nameAliases;
    }

    protected static JobArgument<?> createUndeclaredArgument(String name, Object value, ValueSource valueSource) throws Exception {
        JobArgument<Object> arg = new JobArgument<Object>(name, false, null, SOSArgument.DisplayMode.UNKNOWN, null, Scope.ALL);
        arg.type = Type.UNDECLARED;
        arg.valueSource = valueSource;
        arg.setClazzType(value);
        arg.applyValue(value);
        arg.setArgumentType();
        return arg;
    }

    protected static <T> JobArgument<T> createDeclaredArgumentFromIncluded(SOSArgument<T> includedArg, Field field) throws Exception {
        JobArgument<Object> arg = new JobArgument<Object>(includedArg.getName(), includedArg.isRequired(), includedArg.getDefaultValue(), includedArg.getDisplayMode());
        arg.type = Type.DECLARED;
        arg.scope = Scope.ALL;
        arg.valueSource = new ValueSource(ValueSource.ValueSourceType.JAVA);
        arg.setValue(includedArg.getValue());
        arg.setClazzType(JobArgument.getArgumentFieldType(field));
        arg.setArgumentType();
        return arg;
    }

    protected void setValueSource(ValueSource val) {
        this.valueSource = val;
    }

    protected void reset() {
        this.setValue(null);
        this.valueSource = new ValueSource(ValueSource.ValueSourceType.JAVA);
        this.setIsDirty(false);
    }

    protected boolean hasValueStartsWith(String prefix) {
        if (this.getValue() == null) {
            return false;
        }
        if (this.isFlat()) {
            return this.getValue().toString().startsWith(prefix);
        }
        if (this.isMap()) {
            return ((Map)this.getValue()).entrySet().parallelStream().anyMatch(e -> e.getValue().toString().startsWith(prefix));
        }
        if (this.isCollection()) {
            return ((Collection)this.getValue()).parallelStream().anyMatch(e -> {
                if (e instanceof Map) {
                    return ((Map)e).entrySet().stream().anyMatch(m -> m.getValue().toString().startsWith(prefix));
                }
                return e.toString().startsWith(prefix);
            });
        }
        return this.getValue().toString().startsWith(prefix);
    }

    protected boolean isScopeAll() {
        return this.scope != null && this.scope.equals((Object)Scope.ALL);
    }

    protected boolean isScopeOrderPreparation() {
        return this.scope != null && this.scope.equals((Object)Scope.ORDER_PREPARATION);
    }

    protected void setArgumentType() throws Exception {
        try {
            this.setArgumentType(this.getClazzType());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.argumentType == null) {
            this.argumentType = ArgumentType.FLAT;
        }
        if (this.argumentFlatType == null) {
            this.argumentFlatType = ArgumentFlatType.OBJECT;
        }
    }

    protected NotAcceptedValue getNotAcceptedValue() {
        return this.notAcceptedValue;
    }

    protected void resetNotAcceptedValue() {
        this.notAcceptedValue = null;
    }

    protected static <V> Object convertFlatValue(JobArgument<V> arg, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        switch (arg.getArgumentFlatType()) {
            case STRING: {
                return value.toString();
            }
            case BOOLEAN: {
                return Boolean.valueOf(value.toString());
            }
            case INTEGER: {
                return Integer.valueOf(value.toString());
            }
            case LONG: {
                return Long.valueOf(value.toString());
            }
            case BIGDECIMAL: {
                return new BigDecimal(value.toString());
            }
            case PATH: {
                return Paths.get(value.toString(), new String[0]);
            }
            case FILE: {
                return new File(value.toString());
            }
            case URI: {
                return URI.create(value.toString());
            }
            case CHARSET: {
                return Charset.forName(value.toString());
            }
            case ENUM: {
                try {
                    java.lang.reflect.Type t = arg.isFlat() ? arg.getClazzType() : arg.getSubType(arg.getClazzType(), 0);
                    Enum v = SOSReflection.enumIgnoreCaseValueOf((String)t.getTypeName(), (String)value.toString());
                    if (v == null) {
                        arg.setNotAcceptedValue(value, null);
                        arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
                        return arg.getDefaultValue();
                    }
                    return v;
                }
                catch (ClassNotFoundException e) {
                    arg.setNotAcceptedValue(value, (Throwable)e);
                    arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
                    return arg.getDefaultValue();
                }
            }
        }
        return value;
    }

    private JobArgument<T> toUndeclaredExecuteJobArgument(JobArgument<T> arg) {
        arg.type = Type.UNDECLARED;
        arg.valueSource = new ValueSource(ValueSource.ValueSourceType.EXECUTE_JOB);
        arg.scope = Scope.ALL;
        return arg;
    }

    private void setArgumentType(java.lang.reflect.Type clazzType) throws Exception {
        if (clazzType == null || clazzType.equals(String.class)) {
            this.argumentFlatType = ArgumentFlatType.STRING;
        } else if (clazzType.equals(Boolean.class)) {
            this.argumentFlatType = ArgumentFlatType.BOOLEAN;
        } else if (clazzType.equals(Integer.class)) {
            this.argumentFlatType = ArgumentFlatType.INTEGER;
        } else if (clazzType.equals(Long.class)) {
            this.argumentFlatType = ArgumentFlatType.LONG;
        } else if (clazzType.equals(BigDecimal.class)) {
            this.argumentFlatType = ArgumentFlatType.BIGDECIMAL;
        } else if (clazzType.equals(Path.class)) {
            this.argumentFlatType = ArgumentFlatType.PATH;
        } else if (clazzType.equals(File.class)) {
            this.argumentFlatType = ArgumentFlatType.FILE;
        } else if (clazzType.equals(URI.class)) {
            this.argumentFlatType = ArgumentFlatType.URI;
        } else if (clazzType.equals(Charset.class)) {
            this.argumentFlatType = ArgumentFlatType.CHARSET;
        } else if (SOSReflection.isEnum((java.lang.reflect.Type)clazzType)) {
            this.argumentFlatType = ArgumentFlatType.ENUM;
        } else if (SOSReflection.isList((java.lang.reflect.Type)clazzType)) {
            Object o;
            this.argumentType = ArgumentType.LIST;
            this.argumentFlatType = null;
            if (this.getValue() != null && (o = ((List)this.getValue()).get(0)) != null && o instanceof Map) {
                this.argumentFlatType = ArgumentFlatType.LIST_VALUE_SINGLTON_MAP;
            }
            if (this.argumentFlatType == null) {
                this.setArgumentType(this.getSubType(clazzType, 0));
            }
        } else if (SOSReflection.isSet((java.lang.reflect.Type)clazzType)) {
            this.argumentType = ArgumentType.SET;
            this.setArgumentType(this.getSubType(clazzType, 0));
        } else if (SOSReflection.isMap((java.lang.reflect.Type)clazzType)) {
            if (this.isList()) {
                this.argumentFlatType = ArgumentFlatType.LIST_VALUE_SINGLTON_MAP;
            } else {
                this.argumentType = ArgumentType.MAP;
                this.setArgumentType(this.getSubType(clazzType, 1));
            }
        } else {
            this.argumentFlatType = ArgumentFlatType.OBJECT;
        }
    }

    private static java.lang.reflect.Type getArgumentFieldType(Field field) {
        if (field == null) {
            return null;
        }
        try {
            return ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    private java.lang.reflect.Type getSubType(java.lang.reflect.Type type, int paramIndex) {
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            try {
                return ((ParameterizedType)type).getActualTypeArguments()[paramIndex];
            }
            catch (Throwable e) {
                return Object.class;
            }
        }
        return Object.class;
    }

    public static enum Scope {
        ALL,
        ORDER_PREPARATION;

    }

    public static enum Type {
        DECLARED,
        UNDECLARED;

    }

    public static enum ArgumentType {
        SET,
        MAP,
        LIST,
        FLAT;

    }

    public static enum ArgumentFlatType {
        STRING,
        BOOLEAN,
        INTEGER,
        LONG,
        BIGDECIMAL,
        ENUM,
        URI,
        CHARSET,
        PATH,
        FILE,
        OBJECT,
        LIST_VALUE_SINGLTON_MAP;

    }

    protected class NotAcceptedValue {
        private final List<Object> values = new ArrayList<Object>();
        private final Throwable exception;
        private ValueSource source;
        private ValueSource usedValueSource;

        private NotAcceptedValue(Object value, Throwable exception) {
            this.values.add(value);
            this.exception = exception;
        }

        protected List<Object> getValues() {
            return this.values;
        }

        protected void setSource(ValueSource val) {
            this.source = val;
        }

        protected ValueSource getSource() {
            return this.source;
        }

        protected void setUsedValueSource(ValueSource val) {
            this.usedValueSource = val;
        }

        protected ValueSource getUsedValueSource() {
            return this.usedValueSource;
        }

        protected Throwable getException() {
            return this.exception;
        }

        protected String getDisplayValue() {
            return SOSArgumentHelper.getDisplayValue(this.values, (SOSArgument.DisplayMode)JobArgument.this.getDisplayMode());
        }
    }
}

