/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.sos.commons.util.SOSString;
import com.sos.js7.job.JobArgument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class JobArgumentValueIterator
implements Iterator<Object> {
    private final JobArgument<?> argument;
    private final String prefix;
    private final List<Object> filteredValues = new ArrayList<Object>();
    private final boolean isListValueSingltonMap;
    private boolean isTypeMap = false;
    private int currentIndex = 0;

    protected JobArgumentValueIterator(JobArgument<?> argument, String prefix) {
        this.argument = argument;
        this.prefix = prefix;
        this.isListValueSingltonMap = argument.getArgumentFlatType().equals((Object)JobArgument.ArgumentFlatType.LIST_VALUE_SINGLTON_MAP);
        this.initValues();
    }

    private void initValues() {
        switch (this.argument.getArgumentType()) {
            case FLAT: {
                if (!this.filterByPrefix(this.argument.getValue())) break;
                this.filteredValues.add(this.argument.getValue());
                break;
            }
            case LIST: {
                if (this.isListValueSingltonMap) {
                    int i = 0;
                    for (Object item : (List)this.argument.getValue()) {
                        for (Map.Entry entry : ((Map)item).entrySet()) {
                            if (!this.filterByPrefix(entry.getValue())) continue;
                            this.filteredValues.add(new SingltonMap(i, entry));
                            ++i;
                        }
                    }
                } else {
                    for (Object item : (List)this.argument.getValue()) {
                        if (!this.filterByPrefix(item)) continue;
                        this.filteredValues.add(item);
                    }
                }
                break;
            }
            case MAP: {
                this.isTypeMap = true;
                for (Map.Entry entry : ((Map)this.argument.getValue()).entrySet()) {
                    if (!this.filterByPrefix(entry.getValue())) continue;
                    this.filteredValues.add(entry);
                }
                break;
            }
            case SET: {
                for (Object item : (Set)this.argument.getValue()) {
                    if (!this.filterByPrefix(item)) continue;
                    this.filteredValues.add(item);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported argument type: " + this.argument.getArgumentType());
            }
        }
    }

    private boolean filterByPrefix(Object value) {
        if (this.prefix == null || this.prefix.isEmpty()) {
            return true;
        }
        return value.toString().startsWith(this.prefix);
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.filteredValues.size();
    }

    @Override
    public Object next() {
        Object o;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if ((o = this.filteredValues.get(this.currentIndex++)) == null) {
            return null;
        }
        if (this.isTypeMap) {
            return ((Map.Entry)o).getValue();
        }
        if (this.isListValueSingltonMap) {
            return ((SingltonMap)o).value;
        }
        return o;
    }

    public String nextWithoutPrefix() {
        return SOSString.removePrefix((Object)this.next(), (String)this.prefix);
    }

    public Object current() {
        try {
            return this.filteredValues.get(this.currentIndex - 1);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String getArgumentName() {
        return this.argument.getName();
    }

    public void set(Object newValue) throws Exception {
        if (this.currentIndex <= 0 || this.currentIndex > this.filteredValues.size()) {
            throw new IllegalStateException();
        }
        Object newValueConverted = JobArgument.convertFlatValue(this.argument, newValue);
        Object currentValue = this.filteredValues.get(this.currentIndex - 1);
        switch (this.argument.getArgumentType()) {
            case FLAT: {
                this.argument.applyValue(newValueConverted);
                break;
            }
            case LIST: {
                List list = (List)this.argument.getValue();
                if (this.isListValueSingltonMap) {
                    SingltonMap sm = (SingltonMap)currentValue;
                    Map map = (Map)list.get(sm.listIndex);
                    if (map == null || !map.containsKey(sm.key)) break;
                    map.put(sm.key, newValueConverted);
                    break;
                }
                int index = list.indexOf(currentValue);
                if (index == -1) break;
                list.set(index, newValueConverted);
                break;
            }
            case MAP: {
                Map map = (Map)this.argument.getValue();
                Map.Entry entry = (Map.Entry)currentValue;
                map.put((String)entry.getKey(), newValueConverted);
                break;
            }
            case SET: {
                Set set = (Set)this.argument.getValue();
                set.remove(currentValue);
                set.add(newValueConverted);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported argument type: " + this.argument.getArgumentType());
            }
        }
        this.filteredValues.set(this.currentIndex - 1, newValueConverted);
    }

    private class SingltonMap {
        private final int listIndex;
        private final String key;
        private final Object value;

        private SingltonMap(int listIndex, Map.Entry<?, ?> entry) {
            this.listIndex = listIndex;
            this.key = entry.getKey().toString();
            this.value = entry.getValue();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("listIndex=").append(this.listIndex);
            sb.append(",key=").append(this.key);
            sb.append(",value=").append(this.value);
            return sb.toString();
        }
    }
}

