/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.js7.job.JobArgument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JobArguments {
    private JobArgument<LogLevel> logLevel = new JobArgument<LogLevel>("log_level", false, LogLevel.INFO);
    private JobArgument<MockLevel> mockLevel = new JobArgument<MockLevel>("mock_level", false, MockLevel.OFF);
    private Map<String, List<JobArgument<?>>> includedArguments;
    private List<JobArgument<?>> dynamicArgumentFields;

    public JobArguments() {
    }

    public JobArguments(ASOSArguments ... args) {
        this.setIncludedArguments(args);
    }

    public void setDynamicArgumentFields(List<JobArgument<?>> val) {
        this.dynamicArgumentFields = val;
    }

    public List<JobArgument<?>> getDynamicArgumentFields() {
        return this.dynamicArgumentFields;
    }

    public boolean hasDynamicArgumentFields() {
        return this.dynamicArgumentFields != null && this.dynamicArgumentFields.size() > 0;
    }

    protected Map<String, List<JobArgument<?>>> getIncludedArguments() {
        return this.includedArguments;
    }

    private void setIncludedArguments(ASOSArguments ... args) {
        if (args == null || args.length == 0) {
            return;
        }
        this.includedArguments = new HashMap();
        for (ASOSArguments arg : args) {
            List l = arg.getArgumentFields().stream().map(f -> {
                f.setAccessible(true);
                try {
                    SOSArgument sa = (SOSArgument)f.get(arg);
                    if (sa.getName() == null) {
                        return null;
                    }
                    return JobArgument.createDeclaredArgumentFromIncluded(sa, f);
                }
                catch (Throwable e) {
                    try {
                        return null;
                    }
                    catch (Throwable e2) {
                        return null;
                    }
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.includedArguments.put(arg.getIdentifier(), l);
        }
    }

    public JobArgument<LogLevel> getLogLevel() {
        return this.logLevel;
    }

    public JobArgument<MockLevel> getMockLevel() {
        return this.mockLevel;
    }

    public static enum LogLevel {
        INFO,
        DEBUG,
        TRACE,
        WARN,
        ERROR;

    }

    public static enum MockLevel {
        OFF,
        INFO,
        ERROR;

    }
}

