/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

public class ValueSource {
    private final ValueSourceType type;
    private String source;

    protected ValueSource(ValueSourceType type) {
        this.type = type;
    }

    protected ValueSourceType getType() {
        return this.type;
    }

    public boolean isTypeJAVA() {
        return this.type != null && this.type.equals((Object)ValueSourceType.JAVA);
    }

    public boolean isTypeOrder() {
        return this.type != null && this.type.equals((Object)ValueSourceType.ORDER);
    }

    public boolean isTypeOrderOrNode() {
        return this.type != null && this.type.equals((Object)ValueSourceType.ORDER_OR_NODE);
    }

    public boolean isTypeOrderPreparation() {
        return this.type != null && this.type.equals((Object)ValueSourceType.ORDER_PREPARATION);
    }

    public boolean isTypeJob() {
        return this.type != null && this.type.equals((Object)ValueSourceType.JOB);
    }

    public boolean isTypeJobArgument() {
        return this.type != null && this.type.equals((Object)ValueSourceType.JOB_ARGUMENT);
    }

    public boolean isTypeJobResource() {
        return this.type != null && this.type.equals((Object)ValueSourceType.JOB_RESOURCE);
    }

    protected void setSource(String val) {
        this.source = val;
    }

    public String getSource() {
        return this.source;
    }

    public static enum ValueSourceType {
        JAVA("Resulting Arguments", "Resulting Argument"),
        ORDER("Order Variables", "Order Variable"),
        ORDER_OR_NODE("Default Order Variables or Node Arguments", "Default Order Variable or Node Argument"),
        JOB("Arguments", "Argument"),
        JOB_ARGUMENT("Job Arguments", "Job Argument"),
        JOB_RESOURCE("Job Resources", "Job Resource"),
        LAST_SUCCEEDED_OUTCOME("Last Succeeded Outcomes"),
        LAST_FAILED_OUTCOME("Last Failed Outcomes"),
        ORDER_PREPARATION("Default Order Variables"),
        EXECUTE_JOB("Execute Another Job Arguments", "Execute Another Job Argument");

        private final String header;
        private final String title;

        private ValueSourceType(String header) {
            this(header, header);
        }

        private ValueSourceType(String header, String title) {
            this.header = header;
            this.title = title;
        }

        public String getHeader() {
            return this.header;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

