/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job.jocapi;

import com.sos.commons.credentialstore.keepass.SOSKeePassResolver;
import com.sos.commons.encryption.common.EncryptedValue;
import com.sos.commons.encryption.decrypt.Decrypt;
import com.sos.commons.encryption.exception.SOSEncryptionException;
import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.httpclient.BaseHttpClient;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.httpclient.commons.auth.HttpClientAuthConfig;
import com.sos.commons.httpclient.commons.mulitpart.HttpFormData;
import com.sos.commons.httpclient.exception.SOSBadRequestException;
import com.sos.commons.httpclient.exception.SOSConnectionRefusedException;
import com.sos.commons.sign.keys.key.KeyUtil;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.keystore.KeyStoreContainer;
import com.sos.commons.util.keystore.KeyStoreType;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.util.proxy.ProxyConfig;
import com.sos.commons.util.ssl.SslArguments;
import com.sos.exception.SOSKeyException;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.jocapi.ApiResponse;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class ApiExecutor
implements AutoCloseable {
    private static final String X_ID_TOKEN = "X-ID-TOKEN";
    private static final String WS_API_LOGIN = "/joc/api/authentication/login";
    private static final String WS_API_LOGOUT = "/joc/api/authentication/logout";
    private static final String WS_API_PREFIX = "/joc/api";
    private static final String ACCESS_TOKEN_HEADER = "X-Access-Token";
    private static final String SOS_EXPORT_DIR_HEADER = "X-Export-Directory";
    private static final String SOS_IMPORT_FILEPATH_HEADER = "X-Import-File";
    private static final String AGENT_CONF_DIR_ENV_PARAM = "JS7_AGENT_CONFIG_DIR";
    private static final String PRIVATE_CONF_JS7_PARAM_CONFDIR = "js7.config-directory";
    private static final String PRIVATE_CONF_JS7_PARAM_API_SERVER = "js7.api-server";
    private static final String PRIVATE_CONF_JS7_PARAM_URL = "url";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_FILEPATH = "js7.web.https.keystore.file";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_KEYPWD = "js7.web.https.keystore.key-password";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_STOREPWD = "js7.web.https.keystore.store-password";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_ALIAS = "js7.web.https.keystore.alias";
    private static final String PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_ARRAY = "js7.web.https.truststores";
    private static final String PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH = "file";
    private static final String PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_STOREPWD = "store-password";
    private static final String PRIVATE_FOLDER_NAME = "private";
    private static final String PRIVATE_CONF_FILENAME = "private.conf";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_CS_FILE = "js7.api-server.cs-file";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_CS_KEYFILE = "js7.api-server.cs-key";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_CS_PWD = "js7.api-server.cs-password";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_USERNAME = "js7.api-server.username";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_TOKEN = "js7.api-server.token";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_PWD = "js7.api-server.password";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_PK_PATH = "js7.api-server.privatekey.path";
    private static final List<String> DO_NOT_LOG_KEY = Arrays.asList("js7.api-server.password", "js7.api-server.cs-password", "js7.web.https.keystore.store-password", "js7.web.https.keystore.key-password", "js7.web.https.keystore.alias", "js7.web.https.truststores", "store-password", "js7.api-server.privatekey.path");
    private static final String JOB_ARGUMENT_DELIMITER_REGEX = "\\|";
    private static final String JOB_ARGUMENT_KEYSTORE_FILE = "js7.web.https.keystore.file";
    private static final String JOB_ARGUMENT_KEYSTORE_KEY_PASSWD = "js7.web.https.keystore.key-password";
    private static final String JOB_ARGUMENT_KEYSTORE_STORE_PASSWD = "js7.web.https.keystore.store-password";
    private static final String JOB_ARGUMENT_KEYSTORE_ALIAS = "js7.web.https.keystore.alias";
    private static final String JOB_ARGUMENT_TRUSTSTORE_FILE = "js7.web.https.truststore.file";
    private static final String JOB_ARGUMENT_TRUSTSTORE_PWD = "js7.web.https.truststore.store-password";
    private static final String JOB_ARGUMENT_APISERVER_URL = "js7.api-server.url";
    private static final String JOB_ARGUMENT_APISERVER_CSFILE = "js7.api-server.cs-file";
    private static final String JOB_ARGUMENT_APISERVER_CSKEY = "js7.api-server.cs-key";
    private static final String JOB_ARGUMENT_APISERVER_CSPASSWD = "js7.api-server.cs-password";
    private static final String JOB_ARGUMENT_APISERVER_BASIC_AUTH_USERNAME = "js7.api-server.username";
    private static final String JOB_ARGUMENT_APISERVER_BASIC_AUTH_TOKEN = "js7.api-server.token";
    private static final String JOB_ARGUMENT_APISERVER_BASIC_AUTH_PWD = "js7.api-server.password";
    private static final String JOB_ARGUMENT_APISERVER_PRIVATEKEYPATH = "js7.api-server.privatekey.path";
    private final OrderProcessStep<?> step;
    private BaseHttpClient client;
    private URI jocUri;
    private List<String> jocUris;
    private Config config;
    private Map<String, DetailValue> jobResources;
    private Map<String, String> additionalHeaders;
    private Map<String, String> responseHeaders;

    public ApiExecutor(OrderProcessStep<?> step) {
        this.step = step;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public void setAdditionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void addAdditionalHeaders(String key, String value) {
        if (this.additionalHeaders == null) {
            this.additionalHeaders = new HashMap<String, String>();
        }
        this.additionalHeaders.put(key, value);
    }

    public void setJobResources(Map<String, DetailValue> jobResources) {
        this.jobResources = jobResources;
    }

    public ApiResponse login() throws Exception {
        return this.login(Duration.ofSeconds(30L));
    }

    public ApiResponse login(Duration connectTimeout) throws Exception {
        boolean isDebugEnabled = this.step.getLogger().isDebugEnabled();
        HashMap<String, String> loginRequestHeaders = new HashMap<String, String>();
        loginRequestHeaders.put("Accept", "application/json, text/plain");
        loginRequestHeaders.put("content-type", "application/json");
        this.step.getLogger().debug("***ApiExecutor***");
        this.jocUris = this.getUris();
        Object latestError = "";
        URI loginUri = null;
        Throwable latestException = null;
        for (String uri : this.jocUris) {
            try {
                int code;
                this.createClient(uri, connectTimeout);
                this.jocUri = URI.create(uri);
                loginUri = this.jocUri.resolve(WS_API_LOGIN);
                HttpExecutionResult result = this.client.executePOST(loginUri, this.client.mergeWithDefaultHeaders(loginRequestHeaders));
                if (isDebugEnabled) {
                    this.step.getLogger().debug("[login]" + BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
                }
                if (!HttpUtils.isSuccessful((int)(code = result.response().statusCode()))) {
                    if (HttpUtils.isServerError((int)code)) {
                        throw new SOSConnectionRefusedException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
                    }
                    if (HttpUtils.isUnauthorized((int)code)) {
                        String message = (String)this.client.getJsonProperty(result.response(), "message");
                        if (SOSString.isEmpty((String)message)) {
                            latestException = new Exception("login failed.");
                            throw latestException;
                        }
                        latestError = code + " : " + HttpUtils.getReasonPhrase((int)code) + " " + message;
                        throw new Exception((String)latestError);
                    }
                }
                this.setResponseHeaders(result.response());
                return new ApiResponse(code, HttpUtils.getReasonPhrase((int)code), (String)result.response().body(), this.client.getResponseHeader(result.response(), ACCESS_TOKEN_HEADER).orElse(null), null);
            }
            catch (SOSConnectionRefusedException | ConnectException e) {
                latestError = String.format("connection to URI %1$s failed, trying next Uri.", loginUri.toString());
                if (isDebugEnabled) {
                    this.step.getLogger().debug(latestError);
                }
                latestException = e;
            }
            catch (Exception e) {
                latestError = loginUri != null ? String.format("connection to URI %1$s: %2$s occurred: %3$s", loginUri, e.getClass(), e.getMessage()) : String.format("%1$s occurred: %2$s", e.getClass(), e.getMessage());
                if (isDebugEnabled) {
                    this.step.getLogger().debug(latestError);
                }
                latestException = e;
            }
        }
        this.step.getLogger().info("No connection attempt was successful. Check agents private.conf.");
        throw latestException;
    }

    public ApiResponse post(String token, String apiUrl, String body) throws SOSConnectionRefusedException, SOSBadRequestException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.putAll(Map.of(ACCESS_TOKEN_HEADER, token, "content-type", "application/json"));
        return this.post(token, apiUrl, body, requestHeaders);
    }

    public ApiResponse post(String token, String apiUrl, String body, Map<String, String> requestHeaders) throws SOSConnectionRefusedException, SOSBadRequestException {
        if (this.step.getLogger().isDebugEnabled()) {
            this.step.getLogger().debug("REQUEST: %s", apiUrl);
            this.step.getLogger().debug("PARAMS:\n%s", body);
        }
        requestHeaders.put(ACCESS_TOKEN_HEADER, token);
        return this.post(token, apiUrl, body == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(body), requestHeaders);
    }

    public ApiResponse post(String token, String apiUrl, HttpFormData formData) throws SOSConnectionRefusedException, SOSBadRequestException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.putAll(Map.of(ACCESS_TOKEN_HEADER, token, "content-type", formData.getContentType()));
        return this.post(token, apiUrl, formData, requestHeaders);
    }

    public ApiResponse post(String token, String apiUrl, HttpFormData formData, Map<String, String> requestHeaders) throws SOSConnectionRefusedException, SOSBadRequestException {
        if (this.step.getLogger().isDebugEnabled()) {
            this.step.getLogger().debug("REQUEST: %s", apiUrl);
            this.step.getLogger().debug("PARAMS: %s", "params are multipart/form-data");
        }
        requestHeaders.put(ACCESS_TOKEN_HEADER, token);
        return this.post(token, apiUrl, formData == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofByteArrays((Iterable<byte[]>)formData), requestHeaders);
    }

    private ApiResponse post(String token, String apiUrl, HttpRequest.BodyPublisher publisher, Map<String, String> requestHeaders) throws SOSConnectionRefusedException, SOSBadRequestException {
        if (token == null) {
            throw new SOSBadRequestException("no access token provided. permission denied.");
        }
        if (this.additionalHeaders != null) {
            this.additionalHeaders.entrySet().forEach(entry -> requestHeaders.putIfAbsent((String)entry.getKey(), (String)entry.getValue()));
        }
        if (this.jocUri != null) {
            boolean isDebugEnabled = this.step.getLogger().isDebugEnabled();
            try {
                if (!((String)apiUrl).toLowerCase().startsWith(WS_API_PREFIX)) {
                    apiUrl = WS_API_PREFIX + (String)apiUrl;
                }
                if (isDebugEnabled) {
                    this.step.getLogger().debug("resolvedUri: %s", this.jocUri.resolve((String)apiUrl).toString());
                }
                HttpExecutionResult result = this.client.executePOST(this.jocUri.resolve((String)apiUrl), requestHeaders, publisher, HttpResponse.BodyHandlers.ofInputStream());
                String responseBody = this.readPostResponseBody((HttpExecutionResult<InputStream>)result);
                if (this.step.getLogger().isDebugEnabled()) {
                    this.step.getLogger().debug("[post]" + BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
                }
                int code = result.response().statusCode();
                this.setResponseHeaders(result.response());
                if (responseBody.startsWith("outfile:")) {
                    this.step.getLogger().debug("set outcome variable: js7ApiExecutorOutfile=" + responseBody.substring("outfile:".length()));
                    this.step.getOutcome().putVariable("js7ApiExecutorOutfile", responseBody.substring("outfile:".length()));
                }
                return new ApiResponse(code, HttpUtils.getReasonPhrase((int)code), responseBody, token, null);
            }
            catch (Exception e) {
                return new ApiResponse(-1, e.getClass().getSimpleName(), null, token, e);
            }
        }
        throw new SOSConnectionRefusedException("No connection established through previous login api call.");
    }

    public ApiResponse logout(String token) throws SOSBadRequestException {
        HashMap<String, String> logoutRequestHeaders = new HashMap<String, String>();
        logoutRequestHeaders.put(ACCESS_TOKEN_HEADER, token);
        logoutRequestHeaders.put("content-type", "application/json");
        if (token != null && this.jocUri != null) {
            try {
                HttpExecutionResult result = this.client.executePOST(this.jocUri.resolve(WS_API_LOGOUT), logoutRequestHeaders);
                if (this.step.getLogger().isDebugEnabled()) {
                    this.step.getLogger().debug("[logout]" + BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
                }
                int code = result.response().statusCode();
                this.setResponseHeaders(result.response());
                return new ApiResponse(code, HttpUtils.getReasonPhrase((int)code), (String)result.response().body(), token, null);
            }
            catch (Exception e) {
                return new ApiResponse(-1, e.getClass().getSimpleName(), null, token, e);
            }
        }
        throw new SOSBadRequestException("no access token provided. permission denied.");
    }

    @Override
    public void close() {
        SOSClassUtil.closeQuietly((AutoCloseable)this.client);
        this.client = null;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    private SslArguments getSslArguments() throws KeyManagementException, SOSMissingDataException, NoSuchAlgorithmException, FileNotFoundException {
        SslArguments args = new SslArguments();
        List<KeyStoreContainer> trustStoreContainers = this.getTrustStoreContainersFromOrder();
        if (trustStoreContainers == null) {
            trustStoreContainers = this.getTrustStoreContainersFromConfig(this.config);
        }
        args.getTrustedSsl().setTrustStoreContainers(trustStoreContainers);
        KeyStoreContainer keyStoreContainer = this.getKeyStoreContainerFromOrder();
        if (keyStoreContainer == null) {
            keyStoreContainer = this.getKeyStoreContainerFromConfig(this.config);
        }
        args.getTrustedSsl().setKeyStoreContainer(keyStoreContainer);
        return args;
    }

    private void createClient(String jocUri, Duration connectTimeout) throws Exception {
        this.close();
        if (this.config == null) {
            this.readConfig();
        }
        this.step.getLogger().debug("initiate REST api client");
        BaseHttpClient.Builder builder = BaseHttpClient.withBuilder();
        builder = (BaseHttpClient.Builder)builder.withLogger((ISOSLogger)this.step.getLogger());
        builder = (BaseHttpClient.Builder)builder.withConnectTimeout(connectTimeout);
        builder = (BaseHttpClient.Builder)builder.withAuth(this.getAuthConfig());
        builder = (BaseHttpClient.Builder)builder.withProxyConfig(this.getProxyConfig());
        if (jocUri.toLowerCase().startsWith("https:")) {
            builder.withSSL(this.getSslArguments());
        }
        this.client = (BaseHttpClient)builder.build();
    }

    private ProxyConfig getProxyConfig() {
        return null;
    }

    private HttpClientAuthConfig getAuthConfig() throws Exception {
        String csFile = this.getValueOfArgument("js7.api-server.cs-file");
        String password = this.getValueOfArgument("js7.api-server.password");
        String username = this.getValueOfArgument("js7.api-server.username");
        if (csFile != null || username != null && password != null) {
            String token = this.getValueOfArgument("js7.api-server.token", "");
            String csPwd = this.getValueOfArgument("js7.api-server.cs-password");
            String csKeyFile = this.getValueOfArgument("js7.api-server.cs-key");
            if (!SOSString.isEmpty((String)csFile)) {
                csFile = this.getDecryptedValue(csFile, "js7.api-server.cs-file");
                SOSKeePassResolver resolver = new SOSKeePassResolver(csFile, csKeyFile, csPwd);
                username = resolver.resolve(username);
                password = resolver.resolve(password);
                token = resolver.resolve(token);
            }
            if (token.isEmpty()) {
                username = this.getDecryptedValue(username, "username");
                password = this.getDecryptedValue(password, "password");
            }
            if (!token.isEmpty() && this.jobResources != null) {
                this.step.getLogger().debug("get jobresource and variable from token:" + token);
                String[] tokenJobResource = token.split(":");
                if (tokenJobResource.length == 2) {
                    String variableName = tokenJobResource[1];
                    String jobResourceName = tokenJobResource[0];
                    DetailValue detailValue = this.jobResources.get(variableName);
                    if (this.step.getLogger().isDebugEnabled()) {
                        this.step.getLogger().debug(SOSString.toString((Object)detailValue));
                        this.step.getLogger().debug("variableName:" + variableName);
                        this.step.getLogger().debug("jobResourceName:" + jobResourceName);
                    }
                    if (detailValue != null) {
                        if (detailValue.getSource().equals(jobResourceName)) {
                            token = (String)detailValue.getValue();
                        } else {
                            this.step.getLogger().info("Name of JobResource: " + detailValue.getSource() + " does not match the " + tokenJobResource[0]);
                        }
                    }
                }
                if (this.additionalHeaders == null) {
                    this.additionalHeaders = new LinkedHashMap<String, String>();
                }
                this.additionalHeaders.put(X_ID_TOKEN, token);
            }
        } else {
            csFile = null;
            String csKeyFile = null;
            String csPwd = null;
            try {
                csFile = this.config.getString("js7.api-server.cs-file");
            }
            catch (Exception e) {
                this.step.getLogger().debug(e.getMessage());
            }
            try {
                csKeyFile = this.config.getString("js7.api-server.cs-key");
            }
            catch (Exception e) {
                this.step.getLogger().debug(e.getMessage());
            }
            try {
                csPwd = this.config.getString("js7.api-server.cs-password");
            }
            catch (Exception e) {
                this.step.getLogger().debug(e.getMessage());
            }
            username = "";
            password = "";
            String token = "";
            if (csFile != null && !csFile.isEmpty()) {
                SOSKeePassResolver resolver = new SOSKeePassResolver(csFile, csKeyFile, csPwd);
                username = resolver.resolve(this.config.getString("js7.api-server.username"));
                password = resolver.resolve(this.config.getString("js7.api-server.password"));
                token = resolver.resolve(this.config.getString("js7.api-server.token"));
            } else {
                try {
                    token = this.config.getString("js7.api-server.token");
                }
                catch (ConfigException e) {
                    this.step.getLogger().debug("no token found in private.conf.");
                }
                if (token.isEmpty()) {
                    try {
                        username = this.config.getString("js7.api-server.username");
                    }
                    catch (ConfigException e) {
                        this.step.getLogger().debug("no username found in private.conf.");
                    }
                    try {
                        password = this.config.getString("js7.api-server.password");
                    }
                    catch (ConfigException e) {
                        this.step.getLogger().debug("no (user-)password found in private.conf.");
                    }
                    String privateKeyPath = null;
                    username = this.getDecryptedValue(username, privateKeyPath, "username");
                    password = this.getDecryptedValue(password, privateKeyPath, "password");
                }
            }
            if (!token.isEmpty() && this.jobResources != null) {
                this.step.getLogger().debug("get jobresource and variable from token:" + token);
                String[] tokenJobResource = token.split(":");
                if (tokenJobResource.length == 2) {
                    String variableName = tokenJobResource[1];
                    String jobResourceName = tokenJobResource[0];
                    DetailValue detailValue = this.jobResources.get(variableName);
                    if (this.step.getLogger().isDebugEnabled()) {
                        this.step.getLogger().debug(SOSString.toString((Object)detailValue));
                        this.step.getLogger().debug("variableName:" + variableName);
                        this.step.getLogger().debug("jobResourceName:" + jobResourceName);
                    }
                    if (detailValue != null) {
                        if (detailValue.getSource().equals(jobResourceName)) {
                            token = (String)detailValue.getValue();
                        } else {
                            this.step.getLogger().info("Name of JobResource: " + detailValue.getSource() + " does not match the " + tokenJobResource[0]);
                        }
                    }
                }
                if (this.additionalHeaders == null) {
                    this.additionalHeaders = new LinkedHashMap<String, String>();
                }
                this.additionalHeaders.put(X_ID_TOKEN, token);
            }
        }
        if (SOSString.isEmpty((String)username) && SOSString.isEmpty((String)password)) {
            return null;
        }
        return new HttpClientAuthConfig(username, password);
    }

    private List<String> getUris() throws SOSMissingDataException {
        ArrayList<String> uris = new ArrayList();
        String apiServers = this.getDecrytedValueOfArgument(JOB_ARGUMENT_APISERVER_URL);
        if (apiServers != null) {
            String[] apiServersSplitted = apiServers.split(JOB_ARGUMENT_DELIMITER_REGEX);
            uris = Arrays.asList(apiServersSplitted).stream().peek(String::trim).toList();
        } else {
            if (this.config == null) {
                this.readConfig();
            }
            uris = this.config.getConfig(PRIVATE_CONF_JS7_PARAM_API_SERVER).getStringList(PRIVATE_CONF_JS7_PARAM_URL);
        }
        return uris;
    }

    private String readPostResponseBody(HttpExecutionResult<InputStream> result) throws Exception {
        Object responseBody = null;
        String contentEncoding = this.client.getResponseHeader(result.response(), "content-encoding").orElse("identity").toLowerCase(Locale.ROOT);
        Path responseBodyFile = this.getResponseBodyFile(result);
        try (InputStream in = ApiExecutor.decodeInputStream((InputStream)result.response().body(), contentEncoding);
             ByteArrayOutputStream out = responseBodyFile == null ? new ByteArrayOutputStream() : Files.newOutputStream(responseBodyFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            int length;
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            out.flush();
            responseBody = responseBodyFile == null ? out.toString(this.client.extractCharsetFromResponseContentType(result.response())) : "outfile:" + responseBodyFile.toString();
        }
        return responseBody;
    }

    private Path getResponseBodyFile(HttpExecutionResult<InputStream> result) throws Exception {
        String contentDisposition = this.client.getResponseHeader(result.response(), "content-disposition").orElse(null);
        if (contentDisposition == null || !contentDisposition.contains("filename")) {
            return null;
        }
        Optional targetPath = this.client.getRequestHeader(result.request(), SOS_EXPORT_DIR_HEADER);
        if (!targetPath.isPresent()) {
            targetPath = this.client.getRequestHeader(result.request(), SOS_EXPORT_DIR_HEADER.toLowerCase());
        }
        Path target = Paths.get(System.getProperty("user.dir"), new String[0]);
        if (targetPath.isPresent()) {
            target = target.resolve((String)targetPath.get());
        }
        Files.createDirectories(target, new FileAttribute[0]);
        String filename = ApiExecutor.decodeDisposition(contentDisposition);
        return target.resolve(filename);
    }

    private static InputStream decodeInputStream(InputStream in, String encoding) throws IOException {
        switch (encoding) {
            case "gzip": {
                return new GZIPInputStream(in);
            }
            case "deflate": {
                return new InflaterInputStream(in);
            }
        }
        return in;
    }

    private static String decodeDisposition(String disposition) throws UnsupportedEncodingException {
        String dispositionFilenameValue = disposition.replaceFirst("(?i)^.*filename(?:=\"?([^\"]+)\"?|\\*=([^;,]+)).*$", "$1$2");
        return ApiExecutor.decodeFromUriFormat(dispositionFilenameValue);
    }

    private static String decodeFromUriFormat(String parameter) throws UnsupportedEncodingException {
        Pattern filenamePattern = Pattern.compile("(?<charset>[^']+)'(?<lang>[a-z]{2,8}(-[a-z0-9-]+)?)?'(?<filename>.+)", 2);
        Matcher matcher = filenamePattern.matcher(parameter);
        if (matcher.matches()) {
            String filename = matcher.group("filename");
            String charset = matcher.group("charset");
            return URLDecoder.decode(filename.replaceAll("%25", "%"), charset);
        }
        return parameter;
    }

    private String getDecrytedValueOfArgument(String key) {
        return this.getDecrytedValueOfArgument(key, null);
    }

    private String getDecrytedValueOfArgument(String key, String _default) {
        return this.getDecryptedValue(this.getValueOfArgument(key, _default), key);
    }

    private String getValueOfArgument(String key) {
        return this.getValueOfArgument(key, null);
    }

    private String getValueOfArgument(String key, String _default) {
        if (this.step != null) {
            return this.getValueOfArgument(this.step.getAllArguments().get(key), _default);
        }
        return null;
    }

    private String getValueOfArgument(JobArgument<?> arg, String _default) {
        return Optional.ofNullable(arg).map(SOSArgument::getValue).filter(Objects::nonNull).map(Object::toString).orElse(_default);
    }

    private String getPrivateKeyPath() {
        try {
            String privateKeyPath = this.getValueOfArgument("js7.api-server.privatekey.path");
            if (privateKeyPath != null) {
                return privateKeyPath;
            }
            return this.config.getString("js7.api-server.privatekey.path");
        }
        catch (ConfigException e) {
            this.step.getLogger().error("no private key path found in private.conf.");
            return "";
        }
    }

    private String getDecryptedValue(String in, String propertyName) {
        return this.getDecryptedValue(in, null, propertyName);
    }

    private String getDecryptedValue(String in, String privateKeyPath, String propertyName) {
        if (in != null && in.startsWith("enc:")) {
            String encryptedIn = in;
            encryptedIn = encryptedIn.startsWith("enc://") ? encryptedIn.substring("enc://".length()) : encryptedIn.substring("enc:".length());
            if (privateKeyPath == null) {
                privateKeyPath = this.getPrivateKeyPath();
            }
            try {
                in = this.decryptValue(encryptedIn, propertyName, privateKeyPath);
            }
            catch (SOSEncryptionException | SOSMissingDataException | SOSKeyException e) {
                this.step.getLogger().error("error occurred decrypting ".concat(propertyName).concat(" !"), e);
            }
        }
        return in;
    }

    private Config readConfig() throws SOSMissingDataException {
        boolean isDebugEnabled = this.step.getLogger().isDebugEnabled();
        String agentConfDirPath = System.getenv(AGENT_CONF_DIR_ENV_PARAM);
        if (agentConfDirPath == null) {
            agentConfDirPath = System.getProperty(AGENT_CONF_DIR_ENV_PARAM);
        }
        if (agentConfDirPath == null) {
            throw new SOSMissingDataException(String.format("Environment variable %1$s not set. Can\u00b4t read credentials from agents private.conf file.", AGENT_CONF_DIR_ENV_PARAM));
        }
        if (isDebugEnabled) {
            this.step.getLogger().debug("agentConfDirPath: %s", agentConfDirPath);
        }
        Path agentConfDir = Paths.get(agentConfDirPath, new String[0]);
        Config defaultConfig = ConfigFactory.load();
        Properties props = new Properties();
        props.setProperty(PRIVATE_CONF_JS7_PARAM_CONFDIR, agentConfDir.toString());
        Path privatFolderPath = agentConfDir.resolve(PRIVATE_FOLDER_NAME);
        if (isDebugEnabled) {
            this.step.getLogger().debug("agents private folder: %s", privatFolderPath.toString());
        }
        Config defaultConfigWithAgentConfDir = ConfigFactory.parseProperties((Properties)props).withFallback((ConfigMergeable)defaultConfig).resolve();
        if (isDebugEnabled) {
            this.step.getLogger().debug("js7.config-directory (Config): " + defaultConfigWithAgentConfDir.getString(PRIVATE_CONF_JS7_PARAM_CONFDIR));
        }
        if (Files.exists(privatFolderPath.resolve(PRIVATE_CONF_FILENAME), new LinkOption[0])) {
            this.config = ConfigFactory.parseFile((File)privatFolderPath.resolve(PRIVATE_CONF_FILENAME).toFile()).withFallback((ConfigMergeable)defaultConfigWithAgentConfDir).resolve();
            if (this.config != null) {
                for (Map.Entry entry : this.config.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("js7") || DO_NOT_LOG_KEY.contains(entry.getKey()) || !isDebugEnabled) continue;
                    this.step.getLogger().debug((String)entry.getKey() + ": " + ((ConfigValue)entry.getValue()).toString());
                }
            }
        } else {
            throw new SOSMissingDataException(String.format("File %1$s does not exists. Can\u00b4t read credentials from agents private.conf file.", privatFolderPath.resolve(PRIVATE_CONF_FILENAME).toString()));
        }
        return this.config;
    }

    private List<KeyStoreContainer> getTrustStoreContainersFromOrder() {
        String trustStores = this.getDecrytedValueOfArgument(JOB_ARGUMENT_TRUSTSTORE_FILE);
        if (SOSString.isEmpty((String)trustStores)) {
            return null;
        }
        String[] arr = trustStores.split(JOB_ARGUMENT_DELIMITER_REGEX);
        String password = this.getDecrytedValueOfArgument(JOB_ARGUMENT_TRUSTSTORE_PWD, "");
        String pass = SOSString.isEmpty((String)password) ? null : password;
        return Arrays.asList(arr).stream().peek(String::trim).map(path -> {
            if (SOSString.isEmpty((String)path)) {
                return null;
            }
            KeyStoreContainer c = new KeyStoreContainer(KeyStoreType.PKCS12, SOSPath.toAbsolutePath((String)path));
            if (!Files.exists(c.getPath(), new LinkOption[0])) {
                this.step.getLogger().warn("[order][TrustStore][%s]not found", c.getPath());
                return null;
            }
            c.setPassword(pass);
            return c;
        }).filter(Objects::nonNull).toList();
    }

    private List<KeyStoreContainer> getTrustStoreContainersFromConfig(Config config) {
        try {
            if (this.step.getLogger().isDebugEnabled()) {
                this.step.getLogger().debug("read Truststore from: %s", ((Config)config.getConfigList(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_ARRAY).get(0)).getString(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH));
            }
            return config.getConfigList(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_ARRAY).stream().map(item -> {
                String path = item.getString(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH);
                if (SOSString.isEmpty((String)path)) {
                    return null;
                }
                KeyStoreContainer c = new KeyStoreContainer(KeyStoreType.PKCS12, SOSPath.toAbsolutePath((String)path));
                if (!Files.exists(c.getPath(), new LinkOption[0])) {
                    this.step.getLogger().warn("[config][TrustStore][%s]not found", c.getPath());
                    return null;
                }
                c.setPassword(item.getString(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_STOREPWD));
                return c;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (ConfigException e) {
            this.step.getLogger().debug("[config]no truststore credentials found in private.conf.");
            return null;
        }
    }

    private KeyStoreContainer getKeyStoreContainerFromOrder() {
        String path = this.getDecrytedValueOfArgument("js7.web.https.keystore.file");
        if (SOSString.isEmpty((String)path)) {
            return null;
        }
        String alias = this.getDecrytedValueOfArgument("js7.web.https.keystore.alias", "");
        KeyStoreContainer c = new KeyStoreContainer(KeyStoreType.PKCS12, SOSPath.toAbsolutePath((String)path));
        if (!Files.exists(c.getPath(), new LinkOption[0])) {
            this.step.getLogger().warn("[order][KeyStore][%s]not found", c.getPath());
            return null;
        }
        c.setPassword(this.getDecrytedValueOfArgument("js7.web.https.keystore.store-password", ""));
        c.setKeyPassword(this.getDecrytedValueOfArgument("js7.web.https.keystore.key-password", ""));
        c.setAliases(SOSString.isEmpty((String)alias) ? null : List.of(alias));
        return c;
    }

    private KeyStoreContainer getKeyStoreContainerFromConfig(Config config) {
        Path path = null;
        try {
            String keystorePath = config.getString("js7.web.https.keystore.file");
            if (this.step.getLogger().isDebugEnabled()) {
                this.step.getLogger().debug("[config][%s]read KeyStore...", config.getString("js7.web.https.keystore.file"));
            }
            if (SOSString.isEmpty((String)keystorePath)) {
                return null;
            }
            path = SOSPath.toAbsolutePath((String)keystorePath);
            if (!Files.exists(path, new LinkOption[0])) {
                this.step.getLogger().warn("[config][KeyStore][%s]not found", path);
                return null;
            }
        }
        catch (ConfigException e) {
            this.step.getLogger().debug("[config]no keystore file found in private.conf.");
            return null;
        }
        KeyStoreContainer c = new KeyStoreContainer(KeyStoreType.PKCS12, path);
        try {
            c.setPassword(config.getString("js7.web.https.keystore.store-password"));
        }
        catch (ConfigException e) {
            this.step.getLogger().debug("[config]no keystore store-password found in private.conf.");
        }
        try {
            c.setKeyPassword(config.getString("js7.web.https.keystore.key-password"));
        }
        catch (ConfigException e) {
            this.step.getLogger().debug("[config]no keystore key-password found in private.conf.");
        }
        try {
            String alias = config.getString("js7.web.https.keystore.alias");
            c.setAliases(SOSString.isEmpty((String)alias) ? null : List.of(alias));
        }
        catch (ConfigException e) {
            this.step.getLogger().debug("[config]no (key-)alias found in private.conf.");
        }
        return c;
    }

    private String decryptValue(String encryptedValue, String propertyName, String privateKeyPath) throws SOSKeyException, SOSMissingDataException, SOSEncryptionException {
        return this.decryptValue(encryptedValue, propertyName, Paths.get(privateKeyPath, new String[0]));
    }

    private String decryptValue(String encryptedValue, String propertyName, Path privateKeyPath) throws SOSKeyException, SOSMissingDataException, SOSEncryptionException {
        PrivateKey pk = KeyUtil.getPrivateKey((Path)privateKeyPath);
        if (pk == null) {
            throw new SOSMissingDataException("encrypted values found, but no private key provided or path wrong for decryption!");
        }
        EncryptedValue encrypted = EncryptedValue.getInstance((String)propertyName, (String)encryptedValue);
        return Decrypt.decrypt((EncryptedValue)encrypted, (PrivateKey)pk);
    }

    private void setResponseHeaders(HttpResponse<?> response) {
        if (response == null) {
            return;
        }
        this.responseHeaders = this.client.toJoinedValueResponseHeaders(response);
    }
}

