/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job.resolver;

import com.sos.commons.encryption.common.EncryptedValue;
import com.sos.commons.encryption.decrypt.Decrypt;
import com.sos.commons.sign.keys.key.KeyUtil;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.exception.SOSKeyException;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobArgumentValueIterator;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.exception.JobArgumentException;
import com.sos.js7.job.resolver.JobArgumentValueResolver;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;

public class StandardEncryptionResolver
extends JobArgumentValueResolver {
    public static final String ARG_NAME_ENCIPHERMENT_CERTIFICATE = "encipherment_certificate";
    public static final String ARG_NAME_ENCIPHERMENT_PRIVATE_KEY_PATH = "encipherment_private_key_path";
    private static final String IDENTIFIER = StandardEncryptionResolver.class.getSimpleName();

    public static String getPrefix() {
        return "enc:";
    }

    public static void resolve(OrderProcessStepLogger logger, List<JobArgument<?>> argumentsToResolve, Map<String, JobArgument<?>> allArguments) throws Exception {
        PrivateKey privKey = StandardEncryptionResolver.getPrivateKey(allArguments);
        if (!StandardEncryptionResolver.validate(allArguments.get(ARG_NAME_ENCIPHERMENT_CERTIFICATE), privKey)) {
            throw new SOSKeyException("Private key and certificate do not match");
        }
        for (JobArgument<?> arg : argumentsToResolve) {
            StandardEncryptionResolver.debugArgument(logger, IDENTIFIER, arg);
            JobArgumentValueIterator iterator = arg.newValueIterator(StandardEncryptionResolver.getPrefix());
            while (iterator.hasNext()) {
                try {
                    iterator.set(Decrypt.decrypt((EncryptedValue)EncryptedValue.getInstance((String)arg.getName(), (String)iterator.nextWithoutPrefix()), (PrivateKey)privKey));
                }
                catch (Throwable e) {
                    throw new JobArgumentException(iterator, e);
                }
            }
            arg.setDisplayMode(SOSArgument.DisplayMode.MASKED);
        }
    }

    private static PrivateKey getPrivateKey(Map<String, JobArgument<?>> allArguments) throws Exception {
        JobArgument<?> arg = allArguments.get(ARG_NAME_ENCIPHERMENT_PRIVATE_KEY_PATH);
        try {
            PrivateKey pk = KeyUtil.getPrivateKey(arg == null || arg.getValue() == null ? null : arg.getValue().toString());
            arg.setDisplayMode(SOSArgument.DisplayMode.UNMASKED);
            return pk;
        }
        catch (Throwable e) {
            String m = arg == null || arg.getValue() == null ? " missing" : "=" + arg.getValue().toString();
            throw new SOSKeyException("[argument encipherment_private_key_path" + m + "]" + e.toString(), e);
        }
    }

    private static boolean validate(JobArgument<?> argCertificate, PrivateKey privKey) throws Exception {
        if (argCertificate == null || argCertificate.getValue() == null) {
            return true;
        }
        return true;
    }
}

