/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate;

import com.sos.commons.hibernate.SOSHibernate;
import java.sql.DatabaseMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateDatabaseMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateDatabaseMetaData.class);
    private final SOSHibernate.Dbms dbms;
    private String productName;
    private String productVersion;
    private int majorVersion;
    private int minorVersion;
    private boolean metaDataAvailable;
    private Oracle oracle = null;

    protected SOSHibernateDatabaseMetaData(SOSHibernate.Dbms dbms) {
        this(dbms, null);
    }

    public SOSHibernateDatabaseMetaData(SOSHibernate.Dbms dbms, DatabaseMetaData metaData) {
        this.dbms = dbms;
        this.setMetaData(metaData);
        this.setJsonSupport();
    }

    private void setMetaData(DatabaseMetaData metaData) {
        this.metaDataAvailable = false;
        if (metaData == null) {
            return;
        }
        try {
            this.productName = metaData.getDatabaseProductName();
            this.productVersion = metaData.getDatabaseProductVersion();
            this.majorVersion = metaData.getDatabaseMajorVersion();
            this.minorVersion = metaData.getDatabaseMinorVersion();
            this.metaDataAvailable = true;
        }
        catch (Throwable e) {
            LOGGER.warn(String.format("[setMetaData][%s]%s", new Object[]{this.dbms, e.toString()}), e);
        }
    }

    private void setJsonSupport() {
        if (this.dbms.equals((Object)SOSHibernate.Dbms.ORACLE)) {
            this.oracle = new Oracle();
        }
    }

    public SOSHibernate.Dbms getDbms() {
        return this.dbms;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean metaDataAvailable() {
        return this.metaDataAvailable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[metaDataAvailable=").append(this.metaDataAvailable).append("]");
        sb.append("majorVersion=").append(this.majorVersion);
        sb.append(",minorVersion=").append(this.minorVersion);
        sb.append(",productName=").append(this.productName);
        sb.append(",productVersion=").append(this.productVersion);
        if (this.oracle != null) {
            sb.append(",[json]");
            sb.append("returningClobEnabled=").append(this.oracle.json.returningClobEnabled);
            sb.append(",fallbackToRegex=").append(this.oracle.json.fallbackToRegex);
        }
        return sb.toString();
    }

    public Oracle getOracle() {
        return this.oracle;
    }

    public class Oracle {
        private Json json = null;

        private Oracle() {
            this.json = new Json(SOSHibernateDatabaseMetaData.this.majorVersion, SOSHibernateDatabaseMetaData.this.minorVersion);
        }

        public Json getJson() {
            return this.json;
        }

        public class Json {
            private static final int ORACLE_MIN_VERSION_SUPPORT_JSON_RETURNING_CLOB = 18;
            private boolean returningClobEnabled;
            private boolean fallbackToRegex;

            private Json(int majorVersion, int minorVersion) {
                if (majorVersion >= 12) {
                    if (majorVersion == 12) {
                        if (minorVersion <= 1) {
                            this.fallbackToRegex = true;
                        }
                    } else if (majorVersion >= 18) {
                        this.returningClobEnabled = true;
                    }
                }
            }

            public boolean returningClobEnabled() {
                return this.returningClobEnabled;
            }

            public boolean fallbackToRegex() {
                return this.fallbackToRegex;
            }
        }
    }
}

