/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate;

import com.sos.commons.hibernate.SOSHibernate;
import com.sos.commons.hibernate.SOSHibernateFactory;
import com.sos.commons.hibernate.SOSHibernateSQLExecutor;
import com.sos.commons.hibernate.exception.SOSHibernateConfigurationException;
import com.sos.commons.hibernate.exception.SOSHibernateConnectionException;
import com.sos.commons.hibernate.exception.SOSHibernateException;
import com.sos.commons.hibernate.exception.SOSHibernateInvalidSessionException;
import com.sos.commons.hibernate.exception.SOSHibernateLockAcquisitionException;
import com.sos.commons.hibernate.exception.SOSHibernateObjectOperationException;
import com.sos.commons.hibernate.exception.SOSHibernateObjectOperationStaleStateException;
import com.sos.commons.hibernate.exception.SOSHibernateOpenSessionException;
import com.sos.commons.hibernate.exception.SOSHibernateQueryException;
import com.sos.commons.hibernate.exception.SOSHibernateQueryNonUniqueResultException;
import com.sos.commons.hibernate.exception.SOSHibernateSessionException;
import com.sos.commons.hibernate.exception.SOSHibernateTransactionException;
import com.sos.commons.hibernate.transform.SOSAliasToBeanResultTransformer;
import com.sos.commons.hibernate.transform.SOSNativeQueryAliasToMapTransformer;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSString;
import com.zaxxer.hikari.pool.ProxyConnection;
import com.zaxxer.hikari.util.FastList;
import jakarta.persistence.Entity;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.StaleStateException;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.jdbc.Work;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateSession
implements Serializable,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateSession.class);
    private static final Logger CONNECTION_POOL_LOGGER = LoggerFactory.getLogger((String)"ConnectionPool");
    private static final long serialVersionUID = 1L;
    private static final String DECLARED_FIELD_HIBERNATE_JDBCCOORDINATOR_LASTQUERY = "lastQuery";
    private static final String DECLARED_FIELD_HIKARY_PROXYCONNECTION_OPENSTATEMENTS = "openStatements";
    private final SOSHibernateFactory factory;
    private SharedSessionContract currentSession;
    private FlushMode defaultHibernateFlushMode = FlushMode.ALWAYS;
    private boolean autoCommit = false;
    private String identifier;
    private String logIdentifier;
    private boolean isGetCurrentSession = false;
    private boolean isStatelessSession = false;
    private boolean isTransactionOpened = false;
    private boolean isTerminateInProgress = false;
    private SOSHibernateSQLExecutor sqlExecutor;
    private Statement currentStatement;

    protected SOSHibernateSession(SOSHibernateFactory hibernateFactory) {
        this.setIdentifier(null);
        this.factory = hibernateFactory;
    }

    protected void openSession() throws SOSHibernateOpenSessionException {
        String method;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        String string = method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "openSession") : "";
        if (this.currentSession != null) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%sclose currentSession", method));
            }
            this.closeSession();
        }
        if (this.factory == null || this.factory.getSessionFactory() == null) {
            throw new SOSHibernateOpenSessionException("no valid session factory available");
        }
        try {
            String sessionName = null;
            if (this.isStatelessSession) {
                this.currentSession = this.factory.getSessionFactory().openStatelessSession();
                sessionName = "StatelessSession";
            } else {
                Session session = null;
                if (this.isGetCurrentSession) {
                    session = this.factory.getSessionFactory().getCurrentSession();
                    sessionName = "getCurrentSession";
                } else {
                    session = this.factory.getSessionFactory().openSession();
                    sessionName = "Session";
                }
                if (this.defaultHibernateFlushMode != null) {
                    session.setHibernateFlushMode(this.defaultHibernateFlushMode);
                }
                this.currentSession = session;
            }
            try {
                this.autoCommit = this.factory.getAutoCommit();
            }
            catch (SOSHibernateConfigurationException e) {
                throw new SOSHibernateOpenSessionException("can't get configured autocommit", (Throwable)((Object)e));
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s%s, autoCommit=%s", method, sessionName, this.autoCommit));
            }
        }
        catch (IllegalStateException e) {
            throw new SOSHibernateOpenSessionException(e);
        }
        catch (PersistenceException e) {
            throw new SOSHibernateOpenSessionException(e);
        }
    }

    protected void setIsGetCurrentSession(boolean val) {
        this.isGetCurrentSession = val;
    }

    protected void setIsStatelessSession(boolean val) {
        this.isStatelessSession = val;
    }

    public void beginTransaction() throws SOSHibernateException {
        String method;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        String string = method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "beginTransaction") : "";
        if (this.autoCommit) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]autoCommit=true", method));
            }
            return;
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (this.isTransactionOpened) {
            LOGGER.warn(String.format("%s[skip]transaction is already opened", method));
            return;
        }
        LOGGER.debug(method);
        try {
            try {
                this.currentSession.beginTransaction();
            }
            catch (NullPointerException e) {
                throw new SOSHibernateOpenSessionException("session/connection can't be acquired", e.getCause());
            }
            this.isTransactionOpened = true;
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
    }

    public void clearSession() throws SOSHibernateException {
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "clearSession"));
        }
        try {
            if (!this.isStatelessSession) {
                Session session = (Session)this.currentSession;
                session.clear();
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
    }

    public void doWork(Work work) throws SOSHibernateException {
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "doWork"));
        }
        try {
            this.currentSession.doWork(work);
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
    }

    @Override
    public void close() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(SOSHibernate.getMethodName(this.logIdentifier, "close"));
        }
        if (this.isTerminateInProgress) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[skip]termination is in process", SOSHibernate.getMethodName(this.logIdentifier, "close")));
            }
            return;
        }
        CONNECTION_POOL_LOGGER.debug("--------> RELEASE CONNECTION: " + this.getIdentifier() + " (" + SOSClassUtil.getMethodName((int)3) + ") --------");
        this.closeTransaction();
        this.closeSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean terminate() {
        boolean terminated;
        block37: {
            terminated = false;
            try {
                if (this.currentSession == null) break block37;
                String method = SOSHibernate.getMethodName(this.logIdentifier, "terminate");
                try {
                    this.isTerminateInProgress = false;
                    if (this.currentStatement != null) {
                        this.isTerminateInProgress = true;
                        try {
                            this.currentStatement.cancel();
                            LOGGER.info(method + "[currentStatement][cancel]executed");
                        }
                        catch (Throwable t) {
                            LOGGER.info(method + "[currentStatement][cancel]" + t);
                        }
                    }
                    SharedSessionContractImplementor impl = (SharedSessionContractImplementor)this.currentSession;
                    JdbcCoordinator jdbcCoordinator = impl.getJdbcCoordinator();
                    try {
                        Field lastQueryField = jdbcCoordinator.getClass().getDeclaredField(DECLARED_FIELD_HIBERNATE_JDBCCOORDINATOR_LASTQUERY);
                        lastQueryField.setAccessible(true);
                        Statement statement = (Statement)lastQueryField.get(jdbcCoordinator);
                        if (statement != null && !statement.isClosed()) {
                            this.isTerminateInProgress = true;
                            try {
                                statement.cancel();
                                LOGGER.info(method + "[hibernate][JdbcCoordinator][statement][cancel]executed");
                            }
                            catch (Throwable t) {
                                LOGGER.info(method + "[hibernate][JdbcCoordinator][statement][cancel]" + t);
                            }
                        }
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        try {
                            jdbcCoordinator.cancelLastQuery();
                            this.isTerminateInProgress = true;
                            LOGGER.info(method + "[hibernate][JdbcCoordinator][cancelLastQuery]executed");
                        }
                        catch (Throwable ex) {
                            LOGGER.info(method + "[hibernate][JdbcCoordinator][cancelLastQuery]" + ex);
                        }
                    }
                    if (!this.isTerminateInProgress) {
                        ProxyConnection pc = (ProxyConnection)this.getConnection();
                        try {
                            Field os = ProxyConnection.class.getDeclaredField(DECLARED_FIELD_HIKARY_PROXYCONNECTION_OPENSTATEMENTS);
                            os.setAccessible(true);
                            FastList l = (FastList)os.get(pc);
                            if (l != null && l.size() > 0) {
                                this.isTerminateInProgress = true;
                                for (Statement s : l) {
                                    try {
                                        if (s.isClosed()) continue;
                                        s.cancel();
                                        LOGGER.info(method + "[hikari][ProxyConnection][statement][cancel]executed");
                                    }
                                    catch (Throwable t) {
                                        LOGGER.info(method + "[hikari][ProxyConnection][statement][cancel]" + t);
                                    }
                                }
                            }
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            LOGGER.info(method + "[hikari][ProxyConnection][field=openStatements]" + e);
                        }
                    }
                    if (this.isTerminateInProgress) {
                        Connection connection;
                        boolean useSessionRollback = true;
                        if (useSessionRollback) {
                            try {
                                this.doRollback();
                                LOGGER.info(method + "[session][rollback]executed");
                            }
                            catch (Throwable r) {
                                LOGGER.info(method + "[session][rollback]" + r);
                            }
                        }
                        if ((connection = this.getConnection()) != null) {
                            if (!useSessionRollback) {
                                try {
                                    connection.rollback();
                                    LOGGER.info(method + "[connection][rollback]executed");
                                }
                                catch (Throwable r) {
                                    LOGGER.info(method + "[connection][rollback]" + r);
                                }
                            }
                            try {
                                connection.close();
                                LOGGER.info(method + "[connection][close]executed");
                            }
                            catch (Throwable ex) {
                                LOGGER.info(method + "[connection][close]" + ex);
                            }
                        }
                    }
                    terminated = this.isTerminateInProgress;
                    this.isTerminateInProgress = false;
                    this.close();
                }
                catch (Throwable e) {
                    try {
                        LOGGER.warn(String.format("%s%s", method, e.toString()), e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        terminated = this.isTerminateInProgress;
                        this.isTerminateInProgress = false;
                        this.close();
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.warn(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "terminate"), e.toString()), e);
            }
            finally {
                this.isTerminateInProgress = false;
            }
        }
        return terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SOSHibernateException {
        String method;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        String string = method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "commit") : "";
        if (this.autoCommit) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]autoCommit=true", method));
            }
            return;
        }
        if (this.isTerminateInProgress) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]termination is in process", method));
            }
            return;
        }
        LOGGER.debug(method);
        Transaction tr = this.getTransaction();
        if (tr == null) {
            this.isTransactionOpened = false;
            throw new SOSHibernateTransactionException("transaction is NULL");
        }
        try {
            if (!this.isStatelessSession) {
                ((Session)this.currentSession).flush();
            }
            tr.commit();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        finally {
            this.isTransactionOpened = false;
        }
    }

    public NativeQuery<Object[]> createNativeQuery(String sql) throws SOSHibernateException {
        return this.createNativeQuery(sql, Object[].class);
    }

    public <T> NativeQuery<T> createNativeQuery(String sql, @Nonnull Class<T> resultType) throws SOSHibernateException {
        if (SOSString.isEmpty((String)sql)) {
            throw new SOSHibernateQueryException("sql statement is empty");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", sql);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("%s[sql][%s]", SOSHibernate.getMethodName(this.logIdentifier, "createNativeQuery"), sql));
        }
        NativeQuery q = null;
        try {
            q = this.currentSession.createNativeQuery(sql, resultType);
            if (!resultType.getPackageName().startsWith("java.")) {
                q.setTupleTransformer(new SOSAliasToBeanResultTransformer<T>(resultType));
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, sql));
        }
        catch (IllegalArgumentException e) {
            throw new SOSHibernateQueryException(e, sql);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, sql));
        }
        return q;
    }

    public <T> Query<T> createQuery(StringBuilder hql) throws SOSHibernateException {
        return this.createQuery(hql.toString(), null);
    }

    public <T> Query<T> createQuery(String hql) throws SOSHibernateException {
        return this.createQuery(hql, null);
    }

    public <T> Query<T> createQuery(String hql, Class<T> resultType) throws SOSHibernateException {
        if (SOSString.isEmpty((String)hql)) {
            throw new SOSHibernateQueryException("hql statement is empty");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", hql);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("%s[hql][%s]", SOSHibernate.getMethodName(this.logIdentifier, "createQuery"), hql));
        }
        Query q = null;
        try {
            if (resultType == null) {
                q = this.currentSession.createQuery(hql, null);
            } else {
                q = this.currentSession.createQuery(hql, null);
                q.setTupleTransformer(new SOSAliasToBeanResultTransformer<T>(resultType));
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, hql));
        }
        catch (IllegalArgumentException e) {
            throw new SOSHibernateQueryException(e, hql);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, hql));
        }
        return q;
    }

    public <T> void setParameter(Query<T> query, String parameter, Object argument) throws SOSHibernateException {
        try {
            query.setParameter(parameter, argument);
        }
        catch (IllegalArgumentException e) {
            throw new SOSHibernateQueryException(e, query);
        }
    }

    public void delete(Object item) throws SOSHibernateException {
        if (item == null) {
            throw new SOSHibernateObjectOperationException("item is NULL", item);
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "delete"), SOSHibernate.toString(item)));
        }
        try {
            if (this.isStatelessSession) {
                StatelessSession session = (StatelessSession)this.currentSession;
                session.delete(item);
            } else {
                Session session = (Session)this.currentSession;
                session.remove(item);
                session.flush();
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
    }

    public int executeUpdate(Query<?> query) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        this.debugQuery("executeUpdate", query, null);
        try {
            return query.executeUpdate();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return 0;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return 0;
        }
    }

    public int executeUpdate(String hql) throws SOSHibernateException {
        return this.executeUpdate(this.createQuery(hql));
    }

    public int executeUpdateNativeQuery(String sql) throws SOSHibernateException {
        return this.executeUpdate((Query<?>)this.createNativeQuery(sql));
    }

    public <T> T get(Class<T> entityClass, Serializable id) throws SOSHibernateException {
        if (entityClass == null) {
            throw new SOSHibernateObjectOperationException("entityClass is NULL", (Object)null);
        }
        if (id == null) {
            throw new SOSHibernateObjectOperationException("id is NULL", (Object)null);
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%sentityClass=%s, id=%s", SOSHibernate.getMethodName(this.logIdentifier, "get"), entityClass.getName(), id));
        }
        Object item = null;
        try {
            item = this.isStatelessSession ? ((StatelessSession)this.currentSession).get(entityClass, (Object)id) : ((Session)this.currentSession).get(entityClass, (Object)id);
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
            return null;
        }
        return (T)item;
    }

    public CacheMode getCacheMode() {
        if (!this.isStatelessSession && this.currentSession != null) {
            Session session = (Session)this.currentSession;
            return session.getCacheMode();
        }
        return null;
    }

    public Connection getConnection() throws SOSHibernateException {
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        try {
            SharedSessionContractImplementor impl = (SharedSessionContractImplementor)this.currentSession;
            try {
                return impl.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
            }
            catch (NullPointerException e) {
                throw new SOSHibernateConnectionException("can't get the SQL connection from the SharedSessionContractImplementor(NullPointerException)");
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateConnectionException(e));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateConnectionException(e));
            return null;
        }
    }

    public SharedSessionContract getCurrentSession() {
        return this.currentSession;
    }

    public SOSHibernateFactory getFactory() {
        return this.factory;
    }

    public FlushMode getHibernateFlushMode() {
        if (!this.isStatelessSession && this.currentSession != null) {
            Session session = (Session)this.currentSession;
            return session.getHibernateFlushMode();
        }
        return null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getLastSequenceValue(String sequenceName) throws SOSHibernateException {
        String stmt = this.factory.getSequenceLastValString(sequenceName);
        return stmt == null ? null : this.getSingleValueNativeQuery(stmt, String.class);
    }

    public <T> List<T> getResultList(Query<T> query) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", query);
        }
        this.debugQuery("getResultList", query, null);
        try {
            return query.getResultList();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return null;
        }
    }

    public <T> List<T> getResultList(String hql) throws SOSHibernateException {
        Query<T> query = this.createQuery(hql);
        return this.getResultList(query);
    }

    public <T> List<Map<String, Object>> getResultListAsMaps(NativeQuery<T> nativeQuery) throws SOSHibernateException {
        if (nativeQuery == null) {
            throw new SOSHibernateQueryException("nativeQuery is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", (Query<?>)nativeQuery);
        }
        this.debugQuery("getResultListAsMaps", (Query<T>)nativeQuery, null);
        try {
            nativeQuery.setTupleTransformer(new SOSNativeQueryAliasToMapTransformer());
            return nativeQuery.getResultList();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
            return null;
        }
    }

    public <T> List<Map<String, String>> getResultListAsStringMaps(NativeQuery<T> nativeQuery, String dateTimeFormat) throws SOSHibernateException {
        if (nativeQuery == null) {
            throw new SOSHibernateQueryException("nativeQuery is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", (Query<?>)nativeQuery);
        }
        this.debugQuery("getResultListAsStringMaps", (Query<T>)nativeQuery, "dateTimeFormat=" + dateTimeFormat);
        try {
            nativeQuery.setTupleTransformer(new SOSNativeQueryAliasToMapTransformer(true, dateTimeFormat));
            return nativeQuery.getResultList();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
            return null;
        }
    }

    public <T> List<Map<String, String>> getResultListAsStringMaps(NativeQuery<T> nativeQuery) throws SOSHibernateException {
        return this.getResultListAsStringMaps(nativeQuery, null);
    }

    public <T> List<T> getResultListNativeQuery(String sql, Class<T> resultType) throws SOSHibernateException {
        return this.getResultList((Query<T>)this.createNativeQuery(sql, resultType));
    }

    public List<String> getResultListNativeQuery(String sql) throws SOSHibernateException {
        return this.getResultList((Query)this.createNativeQuery(sql, String.class));
    }

    public <T> List<Map<String, Object>> getResultListNativeQueryAsMaps(String sql) throws SOSHibernateException {
        return this.getResultListAsMaps(this.createNativeQuery(sql));
    }

    public <T> List<Map<String, String>> getResultListNativeQueryAsStringMaps(String sql) throws SOSHibernateException {
        return this.getResultListAsStringMaps(this.createNativeQuery(sql), null);
    }

    public <T> List<Map<String, String>> getResultListNativeQueryAsStringMaps(String sql, String dateTimeFormat) throws SOSHibernateException {
        return this.getResultListAsStringMaps(this.createNativeQuery(sql), dateTimeFormat);
    }

    public <T> T getSingleResult(Query<T> query) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", query);
        }
        this.debugQuery("getSingleResult", query, null);
        Object result = null;
        try {
            result = query.getSingleResult();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new SOSHibernateQueryNonUniqueResultException(e, query);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
        }
        return (T)result;
    }

    public <T> T getSingleResult(String hql) throws SOSHibernateException {
        return this.getSingleResult(this.createQuery(hql));
    }

    public <T> Map<String, Object> getSingleResultAsMap(NativeQuery<T> nativeQuery) throws SOSHibernateException {
        if (nativeQuery == null) {
            throw new SOSHibernateQueryException("nativeQuery is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", (Query<?>)nativeQuery);
        }
        this.debugQuery("getSingleResultAsMap", (Query<T>)nativeQuery, null);
        nativeQuery.setTupleTransformer(new SOSNativeQueryAliasToMapTransformer());
        Map result = null;
        try {
            result = (Map)nativeQuery.getSingleResult();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new SOSHibernateQueryNonUniqueResultException(e, (Query<?>)nativeQuery);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
        }
        return result;
    }

    public <T> Map<String, String> getSingleResultAsStringMap(NativeQuery<T> query) throws SOSHibernateException {
        return this.getSingleResultAsStringMap(query, null);
    }

    public <T> Map<String, String> getSingleResultAsStringMap(NativeQuery<T> nativeQuery, String dateTimeFormat) throws SOSHibernateException {
        if (nativeQuery == null) {
            throw new SOSHibernateQueryException("nativeQuery is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", (Query<?>)nativeQuery);
        }
        this.debugQuery("getSingleResultAsStringMap", (Query<T>)nativeQuery, "dateTimeFormat=" + dateTimeFormat);
        nativeQuery.setTupleTransformer(new SOSNativeQueryAliasToMapTransformer(true, dateTimeFormat));
        Map result = null;
        try {
            result = (Map)nativeQuery.getSingleResult();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new SOSHibernateQueryNonUniqueResultException(e, (Query<?>)nativeQuery);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
        }
        return result;
    }

    public <T> T getSingleResultNativeQuery(String sql, Class<T> resultType) throws SOSHibernateException {
        return this.getSingleResult((Query<T>)this.createNativeQuery(sql, resultType));
    }

    public <T> Map<String, Object> getSingleResultNativeQueryAsMap(String sql) throws SOSHibernateException {
        return this.getSingleResultAsMap(this.createNativeQuery(sql));
    }

    public <T> Map<String, String> getSingleResultNativeQueryAsStringMap(String sql) throws SOSHibernateException {
        return this.getSingleResultAsStringMap(this.createNativeQuery(sql), null);
    }

    public <T> Map<String, String> getSingleResultNativeQueryAsStringMap(String sql, String dateTimeFormat) throws SOSHibernateException {
        return this.getSingleResultAsStringMap(this.createNativeQuery(sql), dateTimeFormat);
    }

    public <T> T getSingleValue(Query<T> query) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        this.debugQuery("getSingleValue", query, null);
        T result = this.getSingleResult(query);
        if (result != null) {
            if (query instanceof NativeQuery) {
                if (result instanceof Object[]) {
                    throw new SOSHibernateQueryNonUniqueResultException("query return a row and not a unique field result", query);
                }
            } else if (result.getClass().getAnnotation(Entity.class) != null) {
                throw new SOSHibernateQueryNonUniqueResultException("query return an entity object and not a unique field result", query);
            }
            return result;
        }
        return null;
    }

    public <T> T getSingleValue(String hql) throws SOSHibernateException {
        return this.getSingleValue(this.createQuery(hql));
    }

    public <T> String getSingleValueAsString(Query<T> query) throws SOSHibernateException {
        T result = this.getSingleValue(query);
        if (result != null) {
            return "" + result;
        }
        return null;
    }

    public <T> String getSingleValueAsString(String hql) throws SOSHibernateException {
        T result = this.getSingleValue(hql);
        if (result != null) {
            return "" + result;
        }
        return null;
    }

    public <T> T getSingleValueNativeQuery(String sql, Class<T> returnType) throws SOSHibernateException {
        return this.getSingleValue((Query<T>)this.createNativeQuery(sql, returnType));
    }

    public String getSingleValueNativeQueryAsString(String sql) throws SOSHibernateException {
        String result = this.getSingleValueNativeQuery(sql, String.class);
        if (result != null) {
            return result;
        }
        return null;
    }

    public SOSHibernateSQLExecutor getSQLExecutor() {
        if (this.sqlExecutor == null) {
            this.sqlExecutor = new SOSHibernateSQLExecutor(this);
        }
        return this.sqlExecutor;
    }

    public Transaction getTransaction() throws SOSHibernateException {
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        Transaction tr = null;
        try {
            tr = this.currentSession.getTransaction();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        return tr;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isConnected() {
        if (this.currentSession != null) {
            return this.currentSession.isConnected();
        }
        return false;
    }

    public boolean isGetCurrentSession() {
        return this.isGetCurrentSession;
    }

    public boolean isOpen() {
        if (this.currentSession != null) {
            return this.currentSession.isOpen();
        }
        return false;
    }

    public boolean isStatelessSession() {
        return this.isStatelessSession;
    }

    public void refresh(Object item) throws SOSHibernateException {
        this.refresh(null, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void refresh(String entityName, Object item) throws SOSHibernateException {
        block15: {
            if (item == null) {
                throw new SOSHibernateObjectOperationException("item is NULL", item);
            }
            if (this.currentSession == null) {
                throw new SOSHibernateInvalidSessionException("currentSession is NULL");
            }
            try {
                if (this.isStatelessSession) {
                    StatelessSession session = (StatelessSession)this.currentSession;
                    if (entityName == null) {
                        session.refresh(item);
                    } else {
                        session.refresh(entityName, item);
                    }
                    break block15;
                }
                Session session = (Session)this.currentSession;
                session.refresh(item);
            }
            catch (IllegalStateException e) {
                this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "refresh"), SOSHibernate.toString(item)));
                }
            }
            catch (PersistenceException e2) {
                this.throwException(e2, (SOSHibernateException)new SOSHibernateObjectOperationException(e2, item));
                {
                    catch (Throwable throwable) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "refresh"), SOSHibernate.toString(item)));
                        }
                        throw throwable;
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "refresh"), SOSHibernate.toString(item)));
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "refresh"), SOSHibernate.toString(item)));
        }
    }

    public void reopen() throws SOSHibernateOpenSessionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%sisStatelessSession=%s", SOSHibernate.getMethodName(this.logIdentifier, "reopen"), this.isStatelessSession));
        }
        this.closeSession();
        this.openSession();
    }

    public void rollback() throws SOSHibernateException {
        if (this.isTerminateInProgress) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[skip]termination is in process", SOSHibernate.getMethodName(this.logIdentifier, "rollback")));
            }
            return;
        }
        this.doRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollback() throws SOSHibernateException {
        String method;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        String string = method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "rollback") : "";
        if (this.autoCommit) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]autoCommit=true", method));
            }
            return;
        }
        LOGGER.debug(method);
        Transaction tr = this.getTransaction();
        if (tr == null) {
            this.isTransactionOpened = false;
            throw new SOSHibernateTransactionException("transaction is NULL");
        }
        try {
            tr.rollback();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        finally {
            this.isTransactionOpened = false;
        }
    }

    /*
     * Loose catch block
     */
    public void save(Object item) throws SOSHibernateException {
        block13: {
            if (item == null) {
                throw new SOSHibernateObjectOperationException("item is NULL", item);
            }
            if (this.currentSession == null) {
                throw new SOSHibernateInvalidSessionException("currentSession is NULL");
            }
            try {
                if (this.isStatelessSession) {
                    StatelessSession session = (StatelessSession)this.currentSession;
                    session.insert(item);
                    break block13;
                }
                Session session = (Session)this.currentSession;
                session.persist(item);
                session.flush();
            }
            catch (IllegalStateException e) {
                this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "save"), SOSHibernate.toString(item)));
                }
            }
            catch (PersistenceException e2) {
                this.throwException(e2, (SOSHibernateException)new SOSHibernateObjectOperationException(e2, item));
                {
                    catch (Throwable throwable) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "save"), SOSHibernate.toString(item)));
                        }
                        throw throwable;
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "save"), SOSHibernate.toString(item)));
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "save"), SOSHibernate.toString(item)));
        }
    }

    public <T> ScrollableResults<T> scroll(Query<T> query) throws SOSHibernateException {
        return this.scroll(query, ScrollMode.FORWARD_ONLY);
    }

    public <T> ScrollableResults<T> scroll(Query<T> query, ScrollMode scrollMode) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", query);
        }
        this.debugQuery("scroll", query, "scrollMode=" + scrollMode);
        try {
            return query.scroll(scrollMode);
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return null;
        }
    }

    public void sessionDoWork(Work work) throws SOSHibernateException {
        if (work == null) {
            throw new SOSHibernateSessionException("work is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "sessionDoWork"));
        }
        try {
            if (!this.isStatelessSession) {
                Session session = (Session)this.currentSession;
                session.doWork(work);
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
    }

    public void setAutoCommit(boolean val) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "setAutoCommit"), val));
        }
        this.autoCommit = val;
        try {
            this.getConnection().setAutoCommit(this.autoCommit);
        }
        catch (SQLException e) {
            throw new SOSHibernateTransactionException(e);
        }
    }

    public void setCacheMode(CacheMode cacheMode) {
        if (this.currentSession instanceof Session) {
            Session session = (Session)this.currentSession;
            session.setCacheMode(cacheMode);
        }
    }

    public void setHibernateFlushMode(FlushMode flushMode) {
        if (this.currentSession instanceof Session) {
            Session session = (Session)this.currentSession;
            session.setHibernateFlushMode(flushMode);
        }
    }

    public void setIdentifier(String val) {
        this.identifier = val;
        this.logIdentifier = SOSHibernate.getLogIdentifier(this.identifier);
    }

    /*
     * Loose catch block
     */
    public void update(Object item) throws SOSHibernateException {
        block13: {
            if (item == null) {
                throw new SOSHibernateObjectOperationException("item is NULL", item);
            }
            if (this.currentSession == null) {
                throw new SOSHibernateInvalidSessionException("currentSession is NULL");
            }
            try {
                if (this.isStatelessSession) {
                    StatelessSession session = (StatelessSession)this.currentSession;
                    session.update(item);
                    break block13;
                }
                Session session = (Session)this.currentSession;
                session.merge(item);
                session.flush();
            }
            catch (IllegalStateException e) {
                this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "update"), SOSHibernate.toString(item)));
                }
            }
            catch (PersistenceException e2) {
                this.throwException(e2, (SOSHibernateException)new SOSHibernateObjectOperationException(e2, item));
                {
                    catch (Throwable throwable) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "update"), SOSHibernate.toString(item)));
                        }
                        throw throwable;
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "update"), SOSHibernate.toString(item)));
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "update"), SOSHibernate.toString(item)));
        }
    }

    public boolean isTransactionOpened() {
        return this.isTransactionOpened;
    }

    private void closeSession() {
        try {
            if (this.currentSession != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s", SOSHibernate.getMethodName(this.logIdentifier, "closeSession")));
                }
                this.currentSession.close();
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[skip]currentSession=null", SOSHibernate.getMethodName(this.logIdentifier, "closeSession")));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.currentSession = null;
    }

    private void closeTransaction() {
        try {
            if (this.currentSession != null) {
                Transaction tr = this.getTransaction();
                if (tr != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("%s[rollback]%s", SOSHibernate.getMethodName(this.logIdentifier, "closeTransaction"), tr.getStatus()));
                    }
                    tr.rollback();
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s[skip][rollback]transaction is null", SOSHibernate.getMethodName(this.logIdentifier, "closeTransaction")));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void throwException(IllegalStateException cause, SOSHibernateException ex) throws SOSHibernateException {
        if (cause.getCause() == null) {
            throw new SOSHibernateInvalidSessionException(cause, ex.getStatement());
        }
        throw ex;
    }

    private void throwException(SQLException cause, SOSHibernateException ex) throws SOSHibernateException {
        if (cause.getCause() == null) {
            throw new SOSHibernateInvalidSessionException(cause, ex.getStatement());
        }
        throw ex;
    }

    private void throwException(PersistenceException cause, SOSHibernateException ex) throws SOSHibernateException {
        for (Throwable e = cause; e != null; e = e.getCause()) {
            SQLException se;
            if (e instanceof JDBCConnectionException) {
                throw new SOSHibernateInvalidSessionException((PersistenceException)((JDBCConnectionException)e), ex.getStatement());
            }
            if (e instanceof SQLNonTransientConnectionException) {
                throw new SOSHibernateInvalidSessionException((SQLException)((SQLNonTransientConnectionException)e), ex.getStatement());
            }
            if (e instanceof LockAcquisitionException) {
                throw new SOSHibernateLockAcquisitionException((PersistenceException)((LockAcquisitionException)e), ex.getStatement());
            }
            if (e instanceof StaleStateException) {
                throw new SOSHibernateObjectOperationStaleStateException((PersistenceException)((StaleStateException)e), ex.getDbItem());
            }
            if (!(e instanceof SQLException) || !SOSHibernate.Dbms.MYSQL.equals((Object)this.getFactory().getDbms()) || (se = (SQLException)e).getErrorCode() != 1205 && se.getErrorCode() != 1213) continue;
            throw new SOSHibernateLockAcquisitionException(se, ex.getStatement());
        }
        throw ex;
    }

    private <T> void debugQuery(String method, Query<T> query, String infos) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(SOSHibernate.getMethodName(this.logIdentifier, method));
            if (query != null) {
                int limit;
                String params = SOSHibernate.getQueryParametersAsString(query);
                if (params != null) {
                    sb.append("[");
                    sb.append(params);
                    sb.append("]");
                }
                if ((limit = query.getMaxResults()) != Integer.MAX_VALUE) {
                    sb.append("[limit=").append(limit).append("]");
                }
                sb.append("[").append(query.getQueryString()).append("]");
            }
            if (infos != null) {
                sb.append(infos);
            }
            LOGGER.debug(sb.toString());
        }
    }

    public DatabaseMetaData getDatabaseMetaData() throws SOSHibernateException {
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        DatabaseMetaData metaData = null;
        try {
            SharedSessionContractImplementor impl = (SharedSessionContractImplementor)this.currentSession;
            metaData = impl.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().getMetaData();
        }
        catch (SQLException e) {
            throw new SOSHibernateException(e);
        }
        return metaData;
    }

    public Date getCurrentDateTime() throws SOSHibernateException {
        return this.getSingleResultNativeQuery(this.factory.getCurrentTimestampSelectString(), Date.class);
    }

    public Date getCurrentUTCDateTime() throws SOSHibernateException {
        return this.getSingleResultNativeQuery(this.factory.getCurrentUTCTimestampSelectString(), Date.class);
    }

    public void setCurrentStatement(Statement val) {
        this.currentStatement = val;
    }

    public void resetCurrentStatement() {
        this.currentStatement = null;
    }

    public Statement getCurrentStatement() {
        return this.currentStatement;
    }
}

