/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.configuration.resolver;

import com.sos.commons.credentialstore.keepass.SOSKeePassResolver;
import com.sos.commons.hibernate.configuration.resolver.ISOSHibernateConfigurationResolver;
import com.sos.commons.hibernate.exception.SOSHibernateConfigurationException;
import org.hibernate.cfg.Configuration;

public class SOSHibernateCredentiaStoreResolver
implements ISOSHibernateConfigurationResolver {
    @Override
    public Configuration resolve(Configuration configuration) throws SOSHibernateConfigurationException {
        if (configuration == null) {
            return configuration;
        }
        try {
            String password;
            String username;
            String f = configuration.getProperty("hibernate.sos.credential_store_file");
            String kf = configuration.getProperty("hibernate.sos.credential_store_key_file");
            String p = configuration.getProperty("hibernate.sos.credential_store_password");
            String ep = configuration.getProperty("hibernate.sos.credential_store_entry_path");
            SOSKeePassResolver r = new SOSKeePassResolver(f, kf, p);
            r.setEntryPath(ep);
            String url = configuration.getProperty("jakarta.persistence.jdbc.url");
            if (url != null) {
                configuration.setProperty("jakarta.persistence.jdbc.url", r.resolve(url));
            }
            if ((username = configuration.getProperty("jakarta.persistence.jdbc.user")) != null) {
                configuration.setProperty("jakarta.persistence.jdbc.user", r.resolve(username));
            }
            if ((password = configuration.getProperty("jakarta.persistence.jdbc.password")) != null) {
                configuration.setProperty("jakarta.persistence.jdbc.password", r.resolve(password));
            }
            return configuration;
        }
        catch (Throwable e) {
            throw new SOSHibernateConfigurationException(e.toString(), e);
        }
    }
}

