/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.configuration.resolver;

import com.sos.commons.encryption.common.EncryptedValue;
import com.sos.commons.encryption.decrypt.Decrypt;
import com.sos.commons.encryption.exception.SOSEncryptionException;
import com.sos.commons.hibernate.configuration.resolver.ISOSHibernateConfigurationResolver;
import com.sos.commons.hibernate.exception.SOSHibernateConfigurationException;
import com.sos.commons.sign.keys.key.KeyUtil;
import com.sos.commons.util.SOSString;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.PrivateKey;
import org.hibernate.cfg.Configuration;

public class SOSHibernateEncryptionResolver
implements ISOSHibernateConfigurationResolver {
    private String keystorePath;
    private String keystoreType;
    private String keystorePassword;
    private String keystoreKeyPassword;
    private String keystoreKeyAlias;

    @Override
    public Configuration resolve(Configuration configuration) throws SOSHibernateConfigurationException {
        if (configuration == null) {
            return configuration;
        }
        EncryptedValue url = null;
        EncryptedValue username = null;
        EncryptedValue password = null;
        try {
            if (this.hasEncryptedValue(configuration.getProperty("jakarta.persistence.jdbc.url"))) {
                url = EncryptedValue.getInstance((String)"jakarta.persistence.jdbc.url", (String)configuration.getProperty("jakarta.persistence.jdbc.url"));
            }
            if (this.hasEncryptedValue(configuration.getProperty("jakarta.persistence.jdbc.user"))) {
                username = EncryptedValue.getInstance((String)"jakarta.persistence.jdbc.user", (String)configuration.getProperty("jakarta.persistence.jdbc.user"));
            }
            if (this.hasEncryptedValue(configuration.getProperty("jakarta.persistence.jdbc.password"))) {
                password = EncryptedValue.getInstance((String)"jakarta.persistence.jdbc.password", (String)configuration.getProperty("jakarta.persistence.jdbc.password"));
            }
        }
        catch (SOSEncryptionException e) {
            throw new SOSHibernateConfigurationException(e.toString(), e);
        }
        if (password != null || url != null || username != null) {
            try {
                PrivateKey privKey = this.getPrivateKey(configuration);
                if (privKey == null) {
                    throw new SOSHibernateConfigurationException("encrypted values found, but no private key provided for decryption!");
                }
                if (url != null) {
                    configuration.setProperty("jakarta.persistence.jdbc.url", Decrypt.decrypt((EncryptedValue)url, (PrivateKey)privKey));
                }
                if (username != null) {
                    configuration.setProperty("jakarta.persistence.jdbc.user", Decrypt.decrypt((EncryptedValue)username, (PrivateKey)privKey));
                }
                if (password != null) {
                    configuration.setProperty("jakarta.persistence.jdbc.password", Decrypt.decrypt((EncryptedValue)password, (PrivateKey)privKey));
                }
            }
            catch (SOSHibernateConfigurationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new SOSHibernateConfigurationException(e.toString(), e);
            }
        }
        return configuration;
    }

    private PrivateKey getPrivateKey(Configuration configuration) throws SOSHibernateConfigurationException {
        String privateKeyPath = configuration.getProperty("hibernate.sos.decryption_key");
        String keystorePath = this.getValue(configuration.getProperty("hibernate.sos.keystore_path"), this.getKeystorePath());
        String privateKeyPwd = configuration.getProperty("hibernate.sos.decryption_keypassword");
        if (privateKeyPath != null && keystorePath != null) {
            throw new SOSHibernateConfigurationException("key path and keystore path found. These configuration items are exclusive. Please do configure only one of them.");
        }
        try {
            if (privateKeyPath != null) {
                if (privateKeyPath != null && !Files.exists(Paths.get(privateKeyPath, new String[0]), new LinkOption[0])) {
                    throw new SOSHibernateConfigurationException("File with path - " + privateKeyPath + " - does not exist.");
                }
                if (!SOSString.isEmpty((String)privateKeyPwd)) {
                    return KeyUtil.getPrivateKey((String)privateKeyPath, (String)privateKeyPwd);
                }
                return KeyUtil.getPrivateKey((String)privateKeyPath);
            }
            if (keystorePath != null) {
                if (keystorePath != null && !Files.exists(Paths.get(keystorePath, new String[0]), new LinkOption[0])) {
                    throw new SOSHibernateConfigurationException("File with path - " + keystorePath + " - does not exist.");
                }
                String keystoreType = this.getValue(configuration.getProperty("hibernate.sos.keystore_type"), this.getKeystoreType());
                String keystorePwd = this.getValue(configuration.getProperty("hibernate.sos.keystore_password"), this.getKeystorePassword());
                String keystoreKeyPwd = this.getValue(configuration.getProperty("hibernate.sos.keystore_keypassword"), this.getKeystoreKeyPassword());
                String keystoreAlias = this.getValue(configuration.getProperty("hibernate.sos.keystore_keyalias"), this.getKeystoreKeyAlias());
                return KeyUtil.getPrivateKey((String)keystorePath, (String)keystoreType, (String)keystorePwd, (String)keystoreKeyPwd, (String)keystoreAlias);
            }
        }
        catch (Throwable e) {
            throw new SOSHibernateConfigurationException(e.toString(), e);
        }
        return null;
    }

    private String getValue(String val, String defaultVal) {
        return val == null ? defaultVal : val;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String val) {
        this.keystorePath = val;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String val) {
        this.keystoreType = val;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String val) {
        this.keystorePassword = val;
    }

    public String getKeystoreKeyPassword() {
        return this.keystoreKeyPassword;
    }

    public void setKeystoreKeyPassword(String val) {
        this.keystoreKeyPassword = val;
    }

    public String getKeystoreKeyAlias() {
        return this.keystoreKeyAlias;
    }

    public void setKeystoreKeyAlias(String val) {
        this.keystoreKeyAlias = val;
    }

    private boolean hasEncryptedValue(String propertyValue) {
        return propertyValue != null && propertyValue.startsWith("enc:");
    }
}

