/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.configuration.resolver;

import com.sos.commons.hibernate.SOSHibernate;
import com.sos.commons.hibernate.SOSHibernateDatabaseMetaData;
import com.sos.commons.hibernate.configuration.resolver.ISOSHibernateConfigurationResolver;
import com.sos.commons.hibernate.configuration.resolver.dialect.SOSHibernateForceMySQLDialectResolver;
import com.sos.commons.hibernate.exception.SOSHibernateConfigurationException;
import com.sos.commons.util.SOSString;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateFinalPropertiesResolver
implements ISOSHibernateConfigurationResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateFinalPropertiesResolver.class);
    private static final String DIALECT_RESOLVER_FORCE_MYSQL = SOSHibernateForceMySQLDialectResolver.class.getName();
    private SOSHibernate.Dbms dbms;

    @Override
    public Configuration resolve(Configuration configuration) throws SOSHibernateConfigurationException {
        this.updateConnectionUrlForMysqlWithMariaDriver(configuration.getProperties());
        this.mapDialect(configuration);
        return configuration;
    }

    private void updateConnectionUrlForMysqlWithMariaDriver(Properties properties) {
        String driver = properties.getProperty("jakarta.persistence.jdbc.driver");
        Object connectionUrl = properties.getProperty("jakarta.persistence.jdbc.url");
        if (!SOSString.isEmpty((String)driver) && !SOSString.isEmpty((String)connectionUrl) && driver.toLowerCase().contains("mariadb") && this.isMySQLURL((String)connectionUrl)) {
            if (!((String)connectionUrl).contains("permitMysqlScheme")) {
                connectionUrl = ((String)connectionUrl).contains("?") ? (String)connectionUrl + "&amp;permitMysqlScheme" : (String)connectionUrl + "?permitMysqlScheme";
            }
            properties.setProperty("jakarta.persistence.jdbc.url", (String)connectionUrl);
            properties.setProperty("hibernate.jakarta.persistence.jdbc.url", (String)connectionUrl);
        }
    }

    private void mapDialect(Configuration configuration) {
        this.dbms = this.getDbms(configuration.getProperties());
        this.populateDbms(configuration);
        String dialect = configuration.getProperties().getProperty("hibernate.dialect");
        boolean allowMetadataOnBoot = this.isAllowMetadataOnBoot(configuration);
        switch (this.dbms) {
            case MYSQL: {
                if (dialect == null) {
                    if (!this.isMySQLURL(configuration)) break;
                    this.populateDialectResolverForceMySQL(configuration);
                    break;
                }
                if (dialect.equals(SOSHibernate.DEFAULT_DIALECT_MARIADB)) {
                    if (!this.isMySQLURL(configuration)) break;
                    this.removeProperty(configuration, "hibernate.dialect");
                    this.populateDialectResolverForceMySQL(configuration);
                    break;
                }
                this.mapDialect(configuration, allowMetadataOnBoot, dialect, SOSHibernate.DEFAULT_DIALECT_MYSQL);
                dialect = configuration.getProperties().getProperty("hibernate.dialect");
                if (dialect != null) break;
                this.populateDialectResolverForceMySQL(configuration);
                break;
            }
            case ORACLE: {
                this.mapDialect(configuration, allowMetadataOnBoot, dialect, SOSHibernate.DEFAULT_DIALECT_ORACLE);
                break;
            }
            case PGSQL: {
                this.mapDialect(configuration, allowMetadataOnBoot, dialect, SOSHibernate.DEFAULT_DIALECT_PGSQL);
                break;
            }
            case MSSQL: {
                this.mapDialect(configuration, allowMetadataOnBoot, dialect, SOSHibernate.DEFAULT_DIALECT_MSSQL);
                break;
            }
            case H2: {
                this.mapDialect(configuration, allowMetadataOnBoot, dialect, SOSHibernate.DEFAULT_DIALECT_H2);
                break;
            }
        }
    }

    private boolean isMySQLURL(Configuration configuration) {
        return this.isMySQLURL(configuration.getProperties().getProperty("jakarta.persistence.jdbc.url"));
    }

    private boolean isMySQLURL(String url) {
        if (url == null) {
            return false;
        }
        return url.contains("jdbc:mysql");
    }

    private boolean isAllowMetadataOnBoot(Configuration configuration) {
        return configuration.getProperties().getProperty("hibernate.boot.allow_jdbc_metadata_access").equals("true");
    }

    private String getConfiguredDialectOrDefault(Configuration configuration, String dialect, String defaultDialect) {
        if (dialect.startsWith(SOSHibernate.DEFAULT_DIALECT_PACKAGE)) {
            configuration.getProperties().setProperty("hibernate.dialect", defaultDialect);
            return defaultDialect;
        }
        return dialect;
    }

    private void populateDialectResolverForceMySQL(Configuration configuration) {
        this.setProperty(configuration, "hibernate.dialect_resolvers", DIALECT_RESOLVER_FORCE_MYSQL);
    }

    private void mapDialect(Configuration configuration, boolean allowMetadataOnBoot, String dialect, String defaultDialect) {
        if (dialect == null) {
            return;
        }
        if ((dialect = this.getConfiguredDialectOrDefault(configuration, dialect, defaultDialect)).equals(defaultDialect) && allowMetadataOnBoot) {
            this.removeProperty(configuration, "hibernate.dialect");
        }
    }

    private SOSHibernate.Dbms getDbms(Properties properties) {
        String dbmsProduct;
        SOSHibernate.Dbms dbms = SOSHibernate.Dbms.UNKNOWN;
        String connectionUrl = properties.getProperty("jakarta.persistence.jdbc.url");
        dbms = !SOSString.isEmpty((String)connectionUrl) ? SOSHibernate.JDBC_TO_DBMS.entrySet().stream().filter(entry -> SOSString.containsIgnoreCase((String)connectionUrl, (String)((String)entry.getKey()))).map(Map.Entry::getValue).findFirst().orElse(SOSHibernate.Dbms.UNKNOWN) : (!SOSString.isEmpty((String)(dbmsProduct = properties.getProperty("hibernate.sos.dbms_product"))) ? SOSHibernate.SOS_DBMS_PRODUCT_TO_DBMS.entrySet().stream().filter(entry -> dbmsProduct.equalsIgnoreCase((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(SOSHibernate.Dbms.UNKNOWN) : SOSHibernateFinalPropertiesResolver.getDbmsFromDialect(properties.getProperty("hibernate.dialect")));
        return dbms;
    }

    private void populateDbms(Configuration configuration) {
        this.setProperty(configuration, "sos.session_factory_var.dbms", (Object)this.dbms);
    }

    private static SOSHibernate.Dbms getDbmsFromDialect(String dialect) {
        if (SOSString.isEmpty((String)dialect)) {
            return SOSHibernate.Dbms.UNKNOWN;
        }
        return SOSHibernate.DIALECT_PART_TO_DBMS.entrySet().stream().filter(entry -> SOSString.containsIgnoreCase((String)dialect, (String)((String)entry.getKey()))).map(Map.Entry::getValue).findFirst().orElse(SOSHibernate.Dbms.UNKNOWN);
    }

    private static SOSHibernate.Dbms getDbms(Dialect dialect) {
        return SOSHibernateFinalPropertiesResolver.getDbmsFromDialect(dialect == null ? null : dialect.getClass().getSimpleName());
    }

    public static SOSHibernate.Dbms finalCheckAndSetDbms(SessionFactory f, Dialect dialect, SOSHibernate.Dbms dbms) {
        SOSHibernate.Dbms d = dbms;
        if (d == null) {
            d = SOSHibernate.Dbms.UNKNOWN;
        }
        if (f == null) {
            return d;
        }
        if (SOSHibernate.Dbms.UNKNOWN.equals((Object)d)) {
            d = SOSHibernateFinalPropertiesResolver.getDbms(dialect);
        }
        f.getProperties().put("sos.session_factory_var.dbms", d);
        return d;
    }

    public static SOSHibernate.Dbms retrieveDbms(SessionFactory f) {
        if (f == null) {
            return SOSHibernate.Dbms.UNKNOWN;
        }
        SOSHibernate.Dbms dbms = null;
        try {
            dbms = (SOSHibernate.Dbms)((Object)f.getProperties().get("sos.session_factory_var.dbms"));
        }
        catch (Throwable e) {
            LOGGER.warn(e.toString());
        }
        return dbms == null ? SOSHibernate.Dbms.UNKNOWN : dbms;
    }

    private static SOSHibernate.Dbms retrieveDbms(DialectResolutionInfo info) {
        Object o = info.getConfigurationValues().get("sos.session_factory_var.dbms");
        return o == null ? SOSHibernate.Dbms.UNKNOWN : (SOSHibernate.Dbms)((Object)o);
    }

    public static void populateDatabaseMetaData(DialectResolutionInfo info) {
        SOSHibernate.Dbms dbms = SOSHibernateFinalPropertiesResolver.retrieveDbms(info);
        info.getConfigurationValues().put("sos.session_factory_var.database_metadata", new SOSHibernateDatabaseMetaData(dbms, info.getDatabaseMetadata()));
    }

    public static SOSHibernateDatabaseMetaData retrieveDatabaseMetaData(SessionFactory f) {
        Object o = f.getProperties().get("sos.session_factory_var.database_metadata");
        if (o == null) {
            return null;
        }
        f.getProperties().remove("sos.session_factory_var.database_metadata");
        return (SOSHibernateDatabaseMetaData)o;
    }

    private void removeProperty(Configuration configuration, String key) {
        configuration.getProperties().remove(key);
        configuration.getStandardServiceRegistryBuilder().getSettings().remove(key);
    }

    private void setProperty(Configuration configuration, String key, Object value) {
        configuration.getProperties().put(key, value);
        configuration.getStandardServiceRegistryBuilder().getSettings().remove(key);
    }

    public SOSHibernate.Dbms getDbms() {
        return this.dbms;
    }
}

