/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.function.json;

import com.sos.commons.hibernate.SOSHibernate;
import com.sos.commons.hibernate.SOSHibernateFactory;
import com.sos.commons.util.SOSString;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.sql.internal.BasicValuedPathInterpretation;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.StandardBasicTypes;

public class SOSHibernateJsonExists
extends StandardSQLFunction {
    public static final String NAME = "SOS_JSON_EXISTS";
    private static final JsonCaseSensitivity DEFAULT_CASE_SENSITIVITY = JsonCaseSensitivity.INSENSITIVE;
    private SOSHibernateFactory factory;

    public SOSHibernateJsonExists(SOSHibernateFactory factory) {
        super(NAME, StandardBasicTypes.BOOLEAN);
        this.factory = factory;
    }

    public static String getOracleRegExExactSearch(String jsonPath, String search) {
        String jp = jsonPath.substring(2);
        return "\"" + jp + "\":\\s*\\[.*\"" + SOSHibernateJsonExists.patternQuote(search) + "\".*\\]";
    }

    public static String getOracleRegExLikeSearch(String jsonPath, String search) {
        String jp = jsonPath.substring(2);
        return "\"" + jp + "\":\\s*\\[.*\".*" + SOSHibernateJsonExists.patternQuote(SOSString.trim((String)search, (String[])new String[]{"%"})) + ".*\".*\\]";
    }

    private static String patternQuote(String val) {
        String[] specialChars;
        for (String ch : specialChars = new String[]{"\"", "\\", "^", "$", ".", "|", "?", "*", "+", "(", ")", "[", "]", "{", "}"}) {
            val = val.replace(ch, "\\" + ch);
        }
        return val;
    }

    public static String getFunction(String jsonColumn, String jsonPath, JsonPathType jsonPathType) {
        return SOSHibernateJsonExists.getFunction(jsonColumn, jsonPath, jsonPathType, null, null, DEFAULT_CASE_SENSITIVITY);
    }

    public static String getFunction(String jsonColumn, String jsonPath, JsonPathType jsonPathType, JsonCaseSensitivity caseSensitivity) {
        return SOSHibernateJsonExists.getFunction(jsonColumn, jsonPath, jsonPathType, null, null, caseSensitivity);
    }

    public static String getFunction(String jsonColumn, String jsonPath, JsonPathType jsonPathType, JsonOperator operator, Object value) {
        return SOSHibernateJsonExists.getFunction(jsonColumn, jsonPath, jsonPathType, operator, value, DEFAULT_CASE_SENSITIVITY);
    }

    public static String getFunction(String jsonColumn, String jsonPath, JsonPathType jsonPathType, JsonOperator operator, Object value, JsonCaseSensitivity caseSensitivity) {
        Object val = null;
        String valShouldBeQuoted = null;
        String valAsQueryParameterName = null;
        if (value == null) {
            val = null;
        } else {
            val = value.toString();
            if (((String)val).startsWith(":")) {
                valAsQueryParameterName = "'" + (String)val + "'";
            } else {
                val = "'" + (String)val + "'";
                valShouldBeQuoted = "'true'";
                if (value instanceof Boolean || value instanceof Number) {
                    valShouldBeQuoted = "'false'";
                }
            }
        }
        String op = operator == null ? null : "'" + operator.name() + "'";
        JsonCaseSensitivity cs = caseSensitivity == null ? DEFAULT_CASE_SENSITIVITY : caseSensitivity;
        return NAME + ("('" + cs.name() + "',") + jsonColumn + ",'" + jsonPath + "','" + jsonPathType.name() + "'," + op + "," + (String)val + ("," + valShouldBeQuoted + "," + valAsQueryParameterName + ")");
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) throws QueryException {
        if (arguments == null || arguments.size() < 7) {
            throw new QueryException("missing arguments", null, null);
        }
        boolean caseInsensitive = this.isCaseInsensitive(arguments.get(0));
        String jsonColumn = this.getColumn(arguments.get(1));
        String jsonPath = this.getLiteralValue(arguments.get(2));
        JsonPathType jsonPathType = this.getPathType(arguments.get(3));
        JsonOperator operator = this.getOperator(arguments.get(4));
        SqlAstNode valueNode = arguments.get(5);
        String value = this.getLiteralValue(valueNode);
        boolean valueShouldBeQuoted = this.quoteValue(arguments.get(6));
        String valueAsQueryParameterName = this.getLiteralValue(arguments.get(7));
        String valueAsQueryParameterNameVarName = valueAsQueryParameterName == null ? null : "SOS_VAR_" + valueAsQueryParameterName.substring(1).toUpperCase();
        switch (this.factory.getDbms()) {
            case ORACLE: {
                boolean useJsonExists = true;
                if (this.factory.getDatabaseMetaData().getOracle().getJson().fallbackToRegex() && operator != null && (value != null || valueAsQueryParameterName != null)) {
                    useJsonExists = false;
                    if (JsonOperator.NOT_EQUALS.equals((Object)operator)) {
                        sqlAppender.append((CharSequence)"NOT ");
                    }
                    sqlAppender.append((CharSequence)"REGEXP_LIKE(");
                    if (caseInsensitive) {
                        sqlAppender.append((CharSequence)("lower(" + jsonColumn + ")"));
                    } else {
                        sqlAppender.append((CharSequence)jsonColumn);
                    }
                    sqlAppender.append((CharSequence)",");
                    switch (operator) {
                        case EQUALS: {
                            if (value == null) {
                                valueNode.accept(translator);
                                break;
                            }
                            sqlAppender.append((CharSequence)SOSHibernateJsonExists.getOracleRegExExactSearch(jsonPath, value));
                            break;
                        }
                        case LIKE: {
                            if (value == null) {
                                valueNode.accept(translator);
                                break;
                            }
                            sqlAppender.append((CharSequence)SOSHibernateJsonExists.getOracleRegExLikeSearch(jsonPath, value));
                            break;
                        }
                        case GREATER_THAN: {
                            break;
                        }
                        case GREATER_THAN_OR_EQUALS: {
                            break;
                        }
                        case LESS_THAN: {
                            break;
                        }
                        case LESS_THAN_OR_EQUALS: {
                            break;
                        }
                        case NOT_EQUALS: {
                            break;
                        }
                    }
                    sqlAppender.append((CharSequence)")");
                }
                if (!useJsonExists) break;
                sqlAppender.append((CharSequence)"JSON_EXISTS(");
                if (caseInsensitive) {
                    jsonPath = jsonPath.toLowerCase();
                    if (value != null) {
                        value = value.toLowerCase();
                    }
                    sqlAppender.append((CharSequence)("lower(" + jsonColumn + ")"));
                } else {
                    sqlAppender.append((CharSequence)jsonColumn);
                }
                sqlAppender.append((CharSequence)",'");
                if (JsonPathType.ARRAY.equals((Object)jsonPathType)) {
                    sqlAppender.append((CharSequence)(jsonPath + "[*]"));
                } else {
                    sqlAppender.append((CharSequence)jsonPath);
                }
                if (operator != null && (value != null || valueAsQueryParameterName != null)) {
                    sqlAppender.append((CharSequence)"?(@");
                    sqlAppender.append((CharSequence)(" " + this.renderOperator(SOSHibernate.Dbms.ORACLE, operator)));
                    if (value == null) {
                        sqlAppender.append((CharSequence)(" $" + valueAsQueryParameterNameVarName));
                    } else {
                        sqlAppender.append((CharSequence)(" " + this.quote(value, valueShouldBeQuoted)));
                    }
                    sqlAppender.append((CharSequence)")");
                }
                sqlAppender.append((CharSequence)"'");
                if (valueAsQueryParameterName != null) {
                    sqlAppender.append((CharSequence)" PASSING ");
                    valueNode.accept(translator);
                    sqlAppender.append((CharSequence)(" AS \"" + valueAsQueryParameterNameVarName + "\""));
                }
                sqlAppender.append((CharSequence)")");
                break;
            }
            default: {
                throw new IllegalArgumentException("[" + this.factory.getDbms() + "][SOS_JSON_EXISTS]not implemented yet");
            }
        }
    }

    private String renderOperator(SOSHibernate.Dbms dbms, JsonOperator operator) {
        switch (dbms) {
            case ORACLE: {
                switch (operator) {
                    case GREATER_THAN: {
                        return ">";
                    }
                    case GREATER_THAN_OR_EQUALS: {
                        return ">=";
                    }
                    case LESS_THAN: {
                        return "<";
                    }
                    case LESS_THAN_OR_EQUALS: {
                        return "<=";
                    }
                    case LIKE: {
                        return "like";
                    }
                    case NOT_EQUALS: {
                        return "!=";
                    }
                }
                return "==";
            }
        }
        return null;
    }

    private String quote(String value, boolean valueShouldBeQuoted) {
        return valueShouldBeQuoted ? "\"" + value + "\"" : value;
    }

    private String getColumn(SqlAstNode arg) {
        return ((BasicValuedPathInterpretation)arg).getColumnReference().getExpressionText();
    }

    private JsonPathType getPathType(SqlAstNode arg) {
        return JsonPathType.valueOf(this.getLiteralValue(arg));
    }

    private JsonOperator getOperator(SqlAstNode arg) {
        String op = this.getLiteralValue(arg);
        return op == null ? null : JsonOperator.valueOf(op);
    }

    private boolean isCaseInsensitive(SqlAstNode arg) {
        String v = this.getLiteralValue(arg);
        JsonCaseSensitivity cs = v == null ? DEFAULT_CASE_SENSITIVITY : JsonCaseSensitivity.valueOf(v);
        return JsonCaseSensitivity.INSENSITIVE.equals((Object)cs);
    }

    private boolean quoteValue(SqlAstNode arg) {
        try {
            String q = this.getLiteralValue(arg);
            return q == null ? true : Boolean.parseBoolean(q);
        }
        catch (Throwable e) {
            return true;
        }
    }

    private String getLiteralValue(SqlAstNode arg) {
        if (arg == null || !(arg instanceof QueryLiteral)) {
            return null;
        }
        return (String)((QueryLiteral)arg).getLiteralValue();
    }

    public static enum JsonCaseSensitivity {
        SENSITIVE,
        INSENSITIVE;

    }

    public static enum JsonPathType {
        OBJECT,
        ARRAY;

    }

    public static enum JsonOperator {
        EQUALS,
        NOT_EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUALS,
        LESS_THAN,
        LESS_THAN_OR_EQUALS,
        LIKE;

    }
}

