/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.function.json.h2;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class Functions {
    public static final String NAME_JSON_VALUE = "SOS_JSON_VALUE";
    public static final String NAME_JSON_ARRAY_LENGTH = "SOS_JSON_ARRAY_LENGTH";

    public static String jsonValue(String jsonValue, String path) throws Exception {
        Optional<JsonValue> result = Functions.resolveJsonValue(jsonValue, path);
        return result.map(Functions::toStringValue).orElse(null);
    }

    public static int jsonArrayLength(String jsonValue, String path) throws Exception {
        Optional<JsonValue> result = Functions.resolveJsonValue(jsonValue, path);
        if (result.isPresent() && result.get().getValueType() == JsonValue.ValueType.ARRAY) {
            return result.get().asJsonArray().size();
        }
        return -1;
    }

    private static Optional<JsonValue> resolveJsonValue(String jsonValue, String path) throws Exception {
        JsonStructure json;
        if (jsonValue == null || jsonValue.isEmpty() || path == null || path.isEmpty()) {
            return Optional.empty();
        }
        try (JsonReader r = Json.createReader((Reader)new StringReader(jsonValue));){
            json = r.read();
        }
        try {
            if (json.getValueType() != JsonValue.ValueType.OBJECT) {
                if (path.equals("$")) {
                    return Optional.of(json);
                }
                return Optional.empty();
            }
            String p = path.startsWith("$.") ? path.substring(2) : path;
            return Functions.extractValue((JsonValue)json, Arrays.stream(p.split("\\.")).iterator());
        }
        catch (Throwable e) {
            System.err.println("[resolveJsonValue][" + jsonValue + "][" + path + "]" + e);
            return Optional.empty();
        }
    }

    private static Optional<JsonValue> extractValue(JsonValue current, Iterator<String> tokens) {
        if (!tokens.hasNext() || current == null) {
            return Optional.ofNullable(current);
        }
        String token = tokens.next();
        switch (current.getValueType()) {
            case OBJECT: {
                JsonObject obj = current.asJsonObject();
                if (token.contains("[")) {
                    String key = token.substring(0, token.indexOf("["));
                    int index = Functions.extractIndex(token);
                    return Optional.ofNullable((JsonValue)obj.get((Object)key)).flatMap(value -> Functions.extractValue(value, index, tokens));
                }
                return Optional.ofNullable((JsonValue)obj.get((Object)token)).flatMap(value -> Functions.extractValue(value, tokens));
            }
            case ARRAY: {
                int index = Functions.extractIndex(token);
                return Functions.extractValue(current, index, tokens);
            }
        }
        return Optional.empty();
    }

    private static Optional<JsonValue> extractValue(JsonValue value, int index, Iterator<String> tokens) {
        if (value == null || value.getValueType() != JsonValue.ValueType.ARRAY) {
            return Optional.empty();
        }
        JsonArray arr = value.asJsonArray();
        if (index < arr.size()) {
            return Functions.extractValue((JsonValue)arr.get(index), tokens);
        }
        return Optional.empty();
    }

    private static int extractIndex(String token) {
        int start = token.indexOf(91);
        int end = token.indexOf(93, start);
        if (start != -1 && end != -1) {
            return Integer.parseInt(token.substring(start + 1, end));
        }
        return -1;
    }

    private static String toStringValue(JsonValue value) {
        if (value == null) {
            return null;
        }
        switch (value.getValueType()) {
            case STRING: {
                String val = ((JsonString)value).getString();
                if (val.length() > 1 && val.startsWith("\"") && val.endsWith("\"")) {
                    val = val.substring(1, val.length() - 1);
                }
                return val;
            }
        }
        return value.toString();
    }
}

