/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.function.regex;

import com.sos.commons.hibernate.SOSHibernateFactory;
import com.sos.commons.util.SOSString;
import java.util.List;
import java.util.regex.Pattern;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.StandardBasicTypes;

public class SOSHibernateRegexp
extends StandardSQLFunction {
    public static final String NAME = "SOS_REGEXP";
    private SOSHibernateFactory factory;

    public SOSHibernateRegexp(SOSHibernateFactory factory) {
        super(NAME, StandardBasicTypes.INTEGER);
        this.factory = factory;
    }

    public static String getFunction(String property, String regexp) {
        return NAME + "(" + property + "," + SOSHibernateRegexp.quote(regexp) + ")=1";
    }

    public static String getFunction(String property, String regexp, String mssqlRegexp) {
        return NAME + "(" + property + "," + SOSHibernateRegexp.quote(regexp) + ("," + SOSHibernateRegexp.quote(mssqlRegexp) + ")=1");
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) throws QueryException {
        if (arguments == null || arguments.size() < 2) {
            throw new QueryException("missing arguments", null, null);
        }
        switch (this.factory.getDbms()) {
            case MYSQL: {
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)" REGEXP ");
                arguments.get(1).accept(translator);
                break;
            }
            case MSSQL: {
                String regexp = this.getLiteralValue(arguments.get(1));
                String mssqlRegexp = arguments.size() == 3 ? this.getLiteralValue(arguments.get(2)) : null;
                Object innRegexp = null;
                if (mssqlRegexp == null) {
                    if (!SOSString.isEmpty((String)regexp) && !regexp.equals("?")) {
                        innRegexp = regexp.replaceAll(Pattern.quote(".*"), "%");
                        if (((String)innRegexp).startsWith("^")) {
                            innRegexp = ((String)innRegexp).substring(1);
                        } else if (!((String)innRegexp).startsWith("%")) {
                            innRegexp = "%" + (String)innRegexp;
                        }
                        if (((String)innRegexp).endsWith("$")) {
                            innRegexp = ((String)innRegexp).substring(0, ((String)innRegexp).length() - 1);
                        } else if (!((String)innRegexp).endsWith("%")) {
                            innRegexp = (String)innRegexp + "%";
                        }
                    }
                } else {
                    innRegexp = mssqlRegexp;
                }
                sqlAppender.append((CharSequence)"(case when (");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)" like ");
                if (innRegexp == null) {
                    arguments.get(1).accept(translator);
                } else {
                    sqlAppender.append((CharSequence)"'");
                    sqlAppender.append((CharSequence)innRegexp);
                    sqlAppender.append((CharSequence)"'");
                }
                sqlAppender.append((CharSequence)") then 1 else 0 end)");
                break;
            }
            case ORACLE: {
                sqlAppender.append((CharSequence)"(case when (REGEXP_LIKE(");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)",");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)")) then 1 else 0 end)");
                break;
            }
            case PGSQL: {
                sqlAppender.append((CharSequence)"(case when (");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)" ~ ");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)") then 1 else 0 end)");
                break;
            }
            case H2: {
                sqlAppender.append((CharSequence)"(case when (REGEXP_LIKE(");
                arguments.get(0).accept(translator);
                sqlAppender.append((CharSequence)",");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)")) then 1 else 0 end)");
                break;
            }
            default: {
                sqlAppender.append((CharSequence)NAME);
            }
        }
    }

    private static String quote(String regexp) {
        if (regexp == null) {
            return "'null'";
        }
        return regexp.startsWith(":") ? regexp : "'" + regexp + "'";
    }

    private String getLiteralValue(SqlAstNode arg) {
        if (arg instanceof QueryLiteral) {
            return ((QueryLiteral)arg).getLiteralValue().toString();
        }
        return null;
    }
}

