/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.id;

import com.sos.commons.hibernate.id.SOSHibernateIdGenerator;
import java.lang.reflect.Member;
import java.util.EnumSet;
import java.util.Properties;
import org.hibernate.boot.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.id.insert.InsertReturningDelegate;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateIdGeneratorImpl
implements BeforeExecutionGenerator,
Configurable,
OnExecutionGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateIdGeneratorImpl.class);
    private static final long serialVersionUID = 1L;
    private final String sequenceName;
    private String sequenceCallSyntax;

    public SOSHibernateIdGeneratorImpl(SOSHibernateIdGenerator config, Member member, CustomIdGeneratorCreationContext creationContext) {
        this.sequenceName = config.sequenceName();
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        Dialect dialect = ((JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class)).getDialect();
        if (dialect instanceof OracleDialect || dialect instanceof PostgreSQLDialect) {
            this.sequenceCallSyntax = dialect.getSequenceSupport().getSequenceNextValString(this.sequenceName);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("sequenceCallSyntax=" + this.sequenceCallSyntax);
        }
    }

    public boolean generatedOnExecution() {
        return this.sequenceCallSyntax == null;
    }

    public InsertGeneratedIdentifierDelegate getGeneratedIdentifierDelegate(PostInsertIdentityPersister persister) {
        if (persister.getFactory().getSessionFactoryOptions().isGetGeneratedKeysEnabled()) {
            return new GetGeneratedKeysDelegate((EntityPersister)persister, false, EventType.INSERT);
        }
        return new InsertReturningDelegate((EntityPersister)persister, EventType.INSERT);
    }

    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        return session.createNativeQuery(this.sequenceCallSyntax, Long.class).uniqueResult();
    }

    public boolean referenceColumnsInSql(Dialect dialect) {
        return false;
    }

    public boolean writePropertyValue() {
        return false;
    }

    public String[] getReferencedColumnValues(Dialect dialect) {
        return null;
    }

    public EnumSet<EventType> getEventTypes() {
        return EventTypeSets.INSERT_ONLY;
    }
}

