/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.transform;

import com.sos.commons.util.SOSReflection;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.query.TupleTransformer;

public class SOSAliasToBeanResultTransformer<T>
implements TupleTransformer<T> {
    private final Class<T> resultClass;
    private Map<String, Method> setter = null;

    public SOSAliasToBeanResultTransformer(Class<T> resultClass) {
        this.resultClass = resultClass;
    }

    public T transformTuple(Object[] tuple, String[] aliases) {
        if (tuple.length != aliases.length) {
            throw new IllegalArgumentException("length of aliases array must match length of tuple array");
        }
        if (this.setter == null) {
            this.initialize();
        }
        T obj = this.newResultClassInstance();
        for (int i = 0; i < aliases.length; ++i) {
            this.invokeSetter(obj, aliases[i], tuple[i]);
        }
        return obj;
    }

    private void initialize() {
        try {
            this.setter = SOSReflection.getAllDeclaredMethodsAsMap(this.resultClass).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("set") && ((Method)e.getValue()).getParameterCount() == 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (Throwable e2) {
            throw new RuntimeException("[" + this.resultClass + "]failed to initialize setter methods", e2);
        }
    }

    private T newResultClassInstance() {
        T obj = null;
        try {
            obj = this.resultClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("[" + this.resultClass + "]failed to instantiate result class", e);
        }
        return obj;
    }

    private void invokeSetter(Object obj, String alias, Object value) {
        String setterName = SOSAliasToBeanResultTransformer.getSetterName(alias);
        Method m = this.setter.get(setterName);
        if (m == null) {
            throw new RuntimeException("[" + this.resultClass + "][alias=" + alias + "][setter=" + setterName + "]setter not found");
        }
        try {
            m.invoke(obj, value);
        }
        catch (Throwable e) {
            throw new RuntimeException("[" + this.resultClass + "][alias=" + alias + "][setter=" + setterName + " parameterType=" + this.getSetterParameterType(m) + "][value=" + value + ",type=" + this.getValueType(value) + "][failed to invoke setter method]" + e.toString(), e);
        }
    }

    private String getSetterParameterType(Method m) {
        Object type = "";
        try {
            type = m.getParameterTypes()[0].getName();
        }
        catch (Throwable e) {
            type = "<exception:" + e.toString() + ">";
        }
        return type;
    }

    private String getValueType(Object value) {
        if (value == null) {
            return "<null>";
        }
        return value.getClass().getName();
    }

    private static String getSetterName(String alias) {
        return "set" + alias.substring(0, 1).toUpperCase() + alias.substring(1);
    }
}

