/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.transform;

import com.sos.commons.util.SOSDate;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import org.hibernate.query.TupleTransformer;

public class SOSNativeQueryAliasToMapTransformer<T>
implements TupleTransformer<T> {
    private final boolean valueAsString;
    private final String dateTimeFormat;

    public SOSNativeQueryAliasToMapTransformer() {
        this(false, null);
    }

    public SOSNativeQueryAliasToMapTransformer(boolean valueAsString, String dateTimeFormat) {
        this.valueAsString = valueAsString;
        this.dateTimeFormat = dateTimeFormat;
    }

    public T transformTuple(Object[] tuple, String[] aliases) {
        if (aliases.length == 0) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(tuple.length);
        for (int i = 0; i < tuple.length; ++i) {
            String alias = aliases[i];
            if (alias == null) continue;
            Object origValue = tuple[i];
            if (this.valueAsString) {
                Object value = "";
                if (origValue != null) {
                    value = "" + origValue;
                    if (this.dateTimeFormat != null && origValue instanceof Timestamp) {
                        try {
                            value = SOSDate.format((String)value, (String)this.dateTimeFormat);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                result.put(alias.toLowerCase(), value);
                continue;
            }
            result.put(alias.toLowerCase(), origValue);
        }
        return (T)result;
    }
}

