/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.keystore;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509TrustManager;

public class CombinedX509TrustManager
implements X509TrustManager {
    private final List<X509TrustManager> delegates;

    public CombinedX509TrustManager(List<X509TrustManager> delegates) {
        this.delegates = Objects.requireNonNullElseGet(delegates, Collections::emptyList);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ArrayList<String> errors = new ArrayList<String>();
        for (X509TrustManager tm : this.delegates) {
            try {
                tm.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                errors.add(e.getMessage());
            }
        }
        throw new CertificateException("[No TrustManager trusted the client certificate]Reasons: " + String.join((CharSequence)" | ", errors));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ArrayList<String> errors = new ArrayList<String>();
        for (X509TrustManager tm : this.delegates) {
            try {
                tm.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                errors.add(e.getMessage());
            }
        }
        throw new CertificateException("[No TrustManager trusted the server certificate]Reasons: " + String.join((CharSequence)" | ", errors));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])this.delegates.stream().flatMap(tm -> Arrays.stream(tm.getAcceptedIssuers())).distinct().toArray(X509Certificate[]::new);
    }
}

