/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.keystore;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.keystore.KeyStoreContainer;
import com.sos.commons.util.keystore.KeyStoreType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class KeyStoreArguments
extends ASOSArguments {
    public static final String CLASS_KEY = "KEY_STORE";
    private static final String ALIASES_DELIMITER = ";";
    private SOSArgument<KeyStoreType> keyStoreType = new SOSArgument<KeyStoreType>("keystore_type", false, KeyStoreType.JKS);
    private SOSArgument<Path> keyStoreFile = new SOSArgument("keystore_file", false);
    private SOSArgument<String> keyStorePassword = new SOSArgument("keystore_password", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<String> keyStoreKeyPassword = new SOSArgument("keystore_key_password", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<String> keyStoreAlias = new SOSArgument("keystore_alias", false);
    private SOSArgument<KeyStoreType> trustStoreType = new SOSArgument<KeyStoreType>("truststore_type", false, KeyStoreType.JKS);
    private SOSArgument<Path> trustStoreFile = new SOSArgument("truststore_file", false);
    private SOSArgument<String> trustStorePassword = new SOSArgument("truststore_password", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<KeyStoreContainer> keyStoreContainer = new SOSArgument(null, false);
    private SOSArgument<List<KeyStoreContainer>> trustStoreContainers = new SOSArgument(null, false);

    public boolean isCustomStoresEnabled() {
        return this.isCustomTrustStoreEnabled() || this.isCustomKeyStoreEnabled();
    }

    public boolean isCustomTrustStoreEnabled() {
        return !this.trustStoreFile.isEmpty() || !this.trustStoreContainers.isEmpty();
    }

    public boolean isCustomKeyStoreEnabled() {
        return !this.keyStoreFile.isEmpty() || !this.keyStoreContainer.isEmpty();
    }

    public SOSArgument<KeyStoreType> getKeyStoreType() {
        return this.keyStoreType;
    }

    public SOSArgument<Path> getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public SOSArgument<String> getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public SOSArgument<String> getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public SOSArgument<String> getKeyStoreKeyPassword() {
        return this.keyStoreKeyPassword;
    }

    public void setKeyStoreContainer(KeyStoreContainer c) {
        this.keyStoreContainer.setValue(c);
        this.mapContainerToSingleKeyStoreFileArgument(this.keyStoreContainer.getValue());
    }

    public SOSArgument<KeyStoreContainer> getKeyStoreContainer() {
        if (this.isCustomKeyStoreEnabled() && this.keyStoreContainer.getValue() == null) {
            this.keyStoreContainer.setValue(this.mapSingleKeyStoreFileArgumentToContainer());
        }
        return this.keyStoreContainer;
    }

    public SOSArgument<KeyStoreType> getTrustStoreType() {
        return this.trustStoreType;
    }

    public SOSArgument<Path> getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public SOSArgument<String> getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStoreContainers(List<KeyStoreContainer> val) {
        this.trustStoreContainers.setValue(val);
    }

    public SOSArgument<List<KeyStoreContainer>> getTrustStoreContainers() {
        KeyStoreContainer c;
        if (this.isCustomTrustStoreEnabled() && this.trustStoreContainers.getValue() == null && (c = this.mapSingleTrustStoreFileArgumentToContainer()) != null) {
            this.trustStoreContainers.setValue(new ArrayList());
            this.trustStoreContainers.getValue().add(c);
        }
        return this.trustStoreContainers;
    }

    public void addTrustStoreContainer(KeyStoreContainer c) {
        if (c == null) {
            return;
        }
        if (this.getTrustStoreContainers().getValue() == null) {
            this.trustStoreContainers.setValue(new ArrayList());
        }
        if (c.getPath() == null) {
            if (c.getKeyStore() == null) {
                return;
            }
            this.trustStoreContainers.getValue().add(c);
        } else {
            boolean exists = this.trustStoreContainers.getValue().stream().anyMatch(e -> c.getPath().equals(e.getPath()));
            if (!exists) {
                this.trustStoreContainers.getValue().add(c);
            }
        }
    }

    private void mapContainerToSingleKeyStoreFileArgument(KeyStoreContainer c) {
        if (c == null || c.getPath() == null) {
            this.keyStoreFile.setValue(null);
            return;
        }
        this.keyStoreFile.setValue(c.getPath());
        this.keyStoreType.setValue(c.getType());
        this.keyStorePassword.setValue(c.getPassword());
        this.keyStoreKeyPassword.setValue(c.getKeyPassword());
        this.keyStoreAlias.setValue(SOSCollection.isEmpty(c.getAliases()) ? null : String.join((CharSequence)ALIASES_DELIMITER, c.getAliases()));
    }

    private KeyStoreContainer mapSingleKeyStoreFileArgumentToContainer() {
        if (this.keyStoreFile.isEmpty()) {
            return null;
        }
        KeyStoreContainer c = new KeyStoreContainer(this.keyStoreType.getValue(), this.keyStoreFile.getValue());
        c.setPassword(this.keyStorePassword.getValue());
        c.setAliases(this.aliasesToList(this.keyStoreAlias.getValue()));
        return c;
    }

    private List<String> aliasesToList(String input) {
        if (SOSString.isEmpty(input)) {
            return null;
        }
        return Arrays.stream(input.split(ALIASES_DELIMITER)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private KeyStoreContainer mapSingleTrustStoreFileArgumentToContainer() {
        if (this.trustStoreFile.isEmpty()) {
            return null;
        }
        KeyStoreContainer c = new KeyStoreContainer(this.trustStoreType.getValue(), this.trustStoreFile.getValue());
        c.setPassword(this.trustStorePassword.getValue());
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[keystore ").append((Object)this.keyStoreType.getValue());
        sb.append(" file=").append(this.keyStoreFile.getValue()).append("]");
        sb.append("[truststore ").append((Object)this.trustStoreType.getValue());
        sb.append(" file=").append(this.trustStoreFile.getValue()).append("]");
        return sb.toString();
    }
}

