/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.JmxCollector;
import io.prometheus.jmx.JmxMBeanPropertyCache;
import io.prometheus.jmx.ObjectNameAttributeFilter;
import io.prometheus.jmx.logger.Logger;
import io.prometheus.jmx.logger.LoggerFactory;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

class JmxScraper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxScraper.class);
    private final MBeanReceiver receiver;
    private final String jmxUrl;
    private final String username;
    private final String password;
    private final boolean ssl;
    private final List<ObjectName> includeObjectNames;
    private final List<ObjectName> excludeObjectNames;
    private final List<JmxCollector.MetricCustomizer> metricCustomizers;
    private final ObjectNameAttributeFilter objectNameAttributeFilter;
    private final JmxMBeanPropertyCache jmxMBeanPropertyCache;

    public JmxScraper(String jmxUrl, String username, String password, boolean ssl, List<ObjectName> includeObjectNames, List<ObjectName> excludeObjectNames, ObjectNameAttributeFilter objectNameAttributeFilter, List<JmxCollector.MetricCustomizer> metricCustomizers, MBeanReceiver receiver, JmxMBeanPropertyCache jmxMBeanPropertyCache) {
        this.jmxUrl = jmxUrl;
        this.receiver = receiver;
        this.username = username;
        this.password = password;
        this.ssl = ssl;
        this.includeObjectNames = includeObjectNames;
        this.excludeObjectNames = excludeObjectNames;
        this.metricCustomizers = metricCustomizers;
        this.objectNameAttributeFilter = objectNameAttributeFilter;
        this.jmxMBeanPropertyCache = jmxMBeanPropertyCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScrape() throws Exception {
        MBeanServerConnection beanConn;
        JMXConnector jmxc = null;
        if (this.jmxUrl.isEmpty()) {
            beanConn = ManagementFactory.getPlatformMBeanServer();
        } else {
            HashMap<String, Object> environment = new HashMap<String, Object>();
            if (this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty()) {
                String[] credent = new String[]{this.username, this.password};
                environment.put("jmx.remote.credentials", credent);
            }
            if (this.ssl) {
                environment.put("java.naming.security.protocol", "ssl");
                SslRMIClientSocketFactory clientSocketFactory = new SslRMIClientSocketFactory();
                environment.put("jmx.remote.rmi.client.socket.factory", clientSocketFactory);
                if (!"true".equalsIgnoreCase(System.getenv("RMI_REGISTRY_SSL_DISABLED"))) {
                    environment.put("com.sun.jndi.rmi.factory.socket", clientSocketFactory);
                }
            }
            jmxc = JMXConnectorFactory.connect(new JMXServiceURL(this.jmxUrl), environment);
            beanConn = jmxc.getMBeanServerConnection();
        }
        try {
            HashSet<ObjectName> mBeanNames = new HashSet<ObjectName>();
            for (ObjectName name : this.includeObjectNames) {
                for (ObjectInstance instance : beanConn.queryMBeans(name, null)) {
                    mBeanNames.add(instance.getObjectName());
                }
            }
            for (ObjectName name : this.excludeObjectNames) {
                for (ObjectInstance instance : beanConn.queryMBeans(name, null)) {
                    mBeanNames.remove(instance.getObjectName());
                }
            }
            this.jmxMBeanPropertyCache.onlyKeepMBeans(mBeanNames);
            this.objectNameAttributeFilter.onlyKeepMBeans(mBeanNames);
            for (ObjectName objectName : mBeanNames) {
                long start = System.nanoTime();
                this.scrapeBean(beanConn, objectName);
                LOGGER.trace("TIME: %d ns for %s", System.nanoTime() - start, objectName);
            }
        }
        finally {
            if (jmxc != null) {
                jmxc.close();
            }
        }
    }

    private void scrapeBean(MBeanServerConnection beanConn, ObjectName mBeanName) {
        AttributeList attributes;
        MBeanInfo mBeanInfo;
        try {
            mBeanInfo = beanConn.getMBeanInfo(mBeanName);
        }
        catch (IOException e) {
            LOGGER.trace("%s getMBeanInfo Fail: %s", mBeanName, e);
            return;
        }
        catch (JMException e) {
            LOGGER.trace("%s getMBeanInfo Fail: %s", mBeanName, e.getMessage());
            return;
        }
        MBeanAttributeInfo[] mBeanAttributeInfos = mBeanInfo.getAttributes();
        LinkedHashMap<String, MBeanAttributeInfo> name2MBeanAttributeInfo = new LinkedHashMap<String, MBeanAttributeInfo>();
        for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfos) {
            if (!mBeanAttributeInfo.isReadable()) {
                LOGGER.trace("%s_%s not readable", mBeanName, mBeanAttributeInfo.getName());
                continue;
            }
            if (this.objectNameAttributeFilter.exclude(mBeanName, mBeanAttributeInfo.getName())) continue;
            if (this.objectNameAttributeFilter.includeObjectNameAttributesIsEmpty()) {
                name2MBeanAttributeInfo.put(mBeanAttributeInfo.getName(), mBeanAttributeInfo);
                continue;
            }
            if (!this.objectNameAttributeFilter.include(mBeanName, mBeanAttributeInfo.getName())) continue;
            name2MBeanAttributeInfo.put(mBeanAttributeInfo.getName(), mBeanAttributeInfo);
        }
        if (name2MBeanAttributeInfo.isEmpty()) {
            return;
        }
        try {
            attributes = beanConn.getAttributes(mBeanName, name2MBeanAttributeInfo.keySet().toArray(new String[0]));
            if (attributes == null) {
                LOGGER.trace("%s getMBeanInfo Fail: attributes are null", (Object)mBeanName);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.warn("%s getAttributes Fail: processing one by one: %s", mBeanName, e.getMessage());
            this.processAttributesOneByOne(beanConn, mBeanName, name2MBeanAttributeInfo);
            return;
        }
        String mBeanNameString = mBeanName.toString();
        String mBeanDomain = mBeanName.getDomain();
        JmxCollector.MetricCustomizer metricCustomizer = this.getMetricCustomizer(mBeanName);
        Map<String, String> attributesAsLabelsWithValues = Collections.emptyMap();
        if (metricCustomizer != null) {
            if (metricCustomizer.attributesAsLabels != null) {
                attributesAsLabelsWithValues = this.getAttributesAsLabelsWithValues(metricCustomizer, attributes);
            }
            for (JmxCollector.ExtraMetric extraMetric : this.getExtraMetrics(metricCustomizer)) {
                this.processBeanValue(mBeanName, mBeanDomain, this.jmxMBeanPropertyCache.getKeyPropertyList(mBeanName), attributesAsLabelsWithValues, new LinkedList<String>(), extraMetric.name, "UNKNOWN", extraMetric.description, extraMetric.value);
            }
        }
        for (Object object : attributes) {
            if (object instanceof Attribute) {
                Attribute attribute = (Attribute)object;
                String attributeName = attribute.getName();
                if (mBeanNameString.equals("java.lang:type=Runtime") && (attributeName.equalsIgnoreCase("SystemProperties") || attributeName.equalsIgnoreCase("ClassPath") || attributeName.equalsIgnoreCase("BootClassPath") || attributeName.equalsIgnoreCase("LibraryPath")) || mBeanNameString.equals("jdk.management.jfr:type=FlightRecorder")) continue;
                MBeanAttributeInfo mBeanAttributeInfo = (MBeanAttributeInfo)name2MBeanAttributeInfo.get(attribute.getName());
                LOGGER.trace("%s_%s process", mBeanName, mBeanAttributeInfo.getName());
                this.processBeanValue(mBeanName, mBeanDomain, this.jmxMBeanPropertyCache.getKeyPropertyList(mBeanName), attributesAsLabelsWithValues, new LinkedList<String>(), mBeanAttributeInfo.getName(), mBeanAttributeInfo.getType(), mBeanAttributeInfo.getDescription(), attribute.getValue());
                continue;
            }
            if (object == null) {
                LOGGER.trace("%s object is NULL, not an instance javax.management.Attribute, skipping", (Object)mBeanName);
                continue;
            }
            LOGGER.trace("%s object [%s] isn't an instance javax.management.Attribute, skipping", mBeanName, object.getClass().getName());
        }
    }

    private List<JmxCollector.ExtraMetric> getExtraMetrics(JmxCollector.MetricCustomizer metricCustomizer) {
        return metricCustomizer.extraMetrics != null ? metricCustomizer.extraMetrics : Collections.emptyList();
    }

    private Map<String, String> getAttributesAsLabelsWithValues(JmxCollector.MetricCustomizer metricCustomizer, AttributeList attributes) {
        Map<String, Object> attributeMap = attributes.asList().stream().collect(Collectors.toMap(Attribute::getName, Attribute::getValue));
        HashMap<String, String> attributesAsLabelsWithValues = new HashMap<String, String>();
        for (String attributeAsLabel : metricCustomizer.attributesAsLabels) {
            Object attrValue = attributeMap.get(attributeAsLabel);
            if (attrValue == null) continue;
            attributesAsLabelsWithValues.put(attributeAsLabel, attrValue.toString());
        }
        return attributesAsLabelsWithValues;
    }

    private JmxCollector.MetricCustomizer getMetricCustomizer(ObjectName mBeanName) {
        if (!this.metricCustomizers.isEmpty()) {
            for (JmxCollector.MetricCustomizer metricCustomizer : this.metricCustomizers) {
                if (!this.filterMbeanByDomainAndProperties(mBeanName, metricCustomizer)) continue;
                return metricCustomizer;
            }
        }
        return null;
    }

    private boolean filterMbeanByDomainAndProperties(ObjectName mBeanName, JmxCollector.MetricCustomizer metricCustomizer) {
        return metricCustomizer.mbeanFilter.domain.equals(mBeanName.getDomain()) && mBeanName.getKeyPropertyList().entrySet().containsAll(metricCustomizer.mbeanFilter.properties.entrySet());
    }

    private void processAttributesOneByOne(MBeanServerConnection beanConn, ObjectName mbeanName, Map<String, MBeanAttributeInfo> name2AttrInfo) {
        for (MBeanAttributeInfo attr : name2AttrInfo.values()) {
            Object value;
            try {
                value = beanConn.getAttribute(mbeanName, attr.getName());
            }
            catch (Exception e) {
                LOGGER.trace("%s_%s Fail: %s", mbeanName, attr.getName(), e.getMessage());
                continue;
            }
            LOGGER.trace("%s_%s process", mbeanName, attr.getName());
            this.processBeanValue(mbeanName, mbeanName.getDomain(), this.jmxMBeanPropertyCache.getKeyPropertyList(mbeanName), new HashMap<String, String>(), new LinkedList<String>(), attr.getName(), attr.getType(), attr.getDescription(), value);
        }
    }

    private void processBeanValue(ObjectName objectName, String domain, LinkedHashMap<String, String> beanProperties, Map<String, String> attributesAsLabelsWithValues, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object value) {
        if (value == null) {
            LOGGER.trace("%s%s%s scrape: null", domain, beanProperties, attrName);
        } else if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Date) {
            if (value instanceof Date) {
                attrType = "java.lang.Double";
                value = (double)((Date)value).getTime() / 1000.0;
            }
            LOGGER.trace("%s%s%s scrape: %s", domain, beanProperties, attrName, value);
            this.receiver.recordBean(domain, beanProperties, attributesAsLabelsWithValues, attrKeys, attrName, attrType, attrDescription, value);
        } else if (value instanceof CompositeData) {
            LOGGER.trace("%s%s%s scrape: compositedata", domain, beanProperties, attrName);
            CompositeData composite = (CompositeData)value;
            CompositeType type = composite.getCompositeType();
            attrKeys = new LinkedList<String>(attrKeys);
            attrKeys.add(attrName);
            for (String key : type.keySet()) {
                String typeName = type.getType(key).getTypeName();
                Object compositeValue = composite.get(key);
                this.processBeanValue(objectName, domain, beanProperties, attributesAsLabelsWithValues, attrKeys, key, typeName, type.getDescription(), compositeValue);
            }
        } else if (value instanceof TabularData) {
            LOGGER.trace("%s%s%s scrape: tabulardata", domain, beanProperties, attrName);
            TabularData tds = (TabularData)value;
            TabularType tt = tds.getTabularType();
            List<String> rowKeys = tt.getIndexNames();
            CompositeType type = tt.getRowType();
            TreeSet<String> valueKeys = new TreeSet<String>(type.keySet());
            rowKeys.forEach(valueKeys::remove);
            LinkedList<String> extendedAttrKeys = new LinkedList<String>(attrKeys);
            extendedAttrKeys.add(attrName);
            for (Object compositeDataValue : tds.values()) {
                if (compositeDataValue instanceof CompositeData) {
                    CompositeData composite = (CompositeData)compositeDataValue;
                    LinkedHashMap<String, String> l2s = new LinkedHashMap<String, String>(beanProperties);
                    for (String idx : rowKeys) {
                        Object obj = composite.get(idx);
                        if (obj == null) continue;
                        while (l2s.containsKey(idx)) {
                            idx = idx + "_";
                        }
                        if (obj instanceof CompositeData) {
                            CompositeData compositeKey = (CompositeData)obj;
                            CompositeType ct = compositeKey.getCompositeType();
                            for (String compositeKeyIdx : ct.keySet()) {
                                l2s.put(idx + "_" + compositeKeyIdx, compositeKey.get(compositeKeyIdx).toString());
                            }
                            continue;
                        }
                        l2s.put(idx, obj.toString());
                    }
                    for (String valueIdx : valueKeys) {
                        LinkedList<String> attrNames = extendedAttrKeys;
                        String typeName = type.getType(valueIdx).getTypeName();
                        String name = valueIdx;
                        if (valueIdx.equalsIgnoreCase("value")) {
                            attrNames = attrKeys;
                            name = attrName;
                        }
                        this.processBeanValue(objectName, domain, l2s, attributesAsLabelsWithValues, attrNames, name, typeName, type.getDescription(), composite.get(valueIdx));
                    }
                    continue;
                }
                LOGGER.trace("%s scrape: not a correct tabulardata format", (Object)domain);
            }
        } else if (value.getClass().isArray()) {
            LOGGER.trace("%s scrape: arrays are unsupported", (Object)domain);
        } else if (value instanceof Optional) {
            LOGGER.trace("%s%s%s scrape: java.util.Optional", domain, beanProperties, attrName);
            Optional optional = (Optional)value;
            if (optional.isPresent()) {
                this.processBeanValue(objectName, domain, beanProperties, attributesAsLabelsWithValues, attrKeys, attrName, attrType, attrDescription, optional.get());
            }
        } else if (value.getClass().isEnum()) {
            LOGGER.trace("%s%s%s scrape: %s", domain, beanProperties, attrName, value);
            this.processBeanValue(objectName, domain, beanProperties, attributesAsLabelsWithValues, attrKeys, attrName, attrType, attrDescription, value.toString());
        } else {
            this.objectNameAttributeFilter.add(objectName, attrName);
            LOGGER.trace("%s%s scrape: %s not exported", domain, beanProperties, attrType);
        }
    }

    public static void main(String[] args) throws Exception {
        ObjectNameAttributeFilter objectNameAttributeFilter = ObjectNameAttributeFilter.create(new HashMap<String, Object>());
        LinkedList<ObjectName> objectNames = new LinkedList<ObjectName>();
        objectNames.add(null);
        if (args.length >= 3) {
            new JmxScraper(args[0], args[1], args[2], args.length > 3 && "ssl".equalsIgnoreCase(args[3]), objectNames, new LinkedList<ObjectName>(), objectNameAttributeFilter, new LinkedList<JmxCollector.MetricCustomizer>(), new StdoutWriter(), new JmxMBeanPropertyCache()).doScrape();
        } else if (args.length > 0) {
            new JmxScraper(args[0], "", "", false, objectNames, new LinkedList<ObjectName>(), objectNameAttributeFilter, new LinkedList<JmxCollector.MetricCustomizer>(), new StdoutWriter(), new JmxMBeanPropertyCache()).doScrape();
        } else {
            new JmxScraper("", "", "", false, objectNames, new LinkedList<ObjectName>(), objectNameAttributeFilter, new LinkedList<JmxCollector.MetricCustomizer>(), new StdoutWriter(), new JmxMBeanPropertyCache()).doScrape();
        }
    }

    public static interface MBeanReceiver {
        public void recordBean(String var1, LinkedHashMap<String, String> var2, Map<String, String> var3, LinkedList<String> var4, String var5, String var6, String var7, Object var8);
    }

    private static class StdoutWriter
    implements MBeanReceiver {
        private StdoutWriter() {
        }

        @Override
        public void recordBean(String domain, LinkedHashMap<String, String> beanProperties, Map<String, String> attributesAsLabelsWithValues, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object value) {
            System.out.println(domain + beanProperties + attrKeys + attrName + ": " + value);
        }
    }
}

