/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.MatchedRule;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MatchedRulesCache {
    private final Map<CacheKey, MatchedRule> cache = new ConcurrentHashMap<CacheKey, MatchedRule>();

    public void put(CacheKey key, MatchedRule matchedRule) {
        this.cache.put(key, matchedRule);
    }

    public MatchedRule get(CacheKey key) {
        return this.cache.get(key);
    }

    public void evictStaleEntries(StalenessTracker stalenessTracker) {
        for (CacheKey key : this.cache.keySet()) {
            if (stalenessTracker.isFresh(key)) continue;
            this.cache.remove(key);
        }
    }

    public static class CacheKey {
        private final String domain;
        private final LinkedHashMap<String, String> beanProperties;
        private final LinkedList<String> attrKeys;
        private final String attrName;

        public CacheKey(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName) {
            this.domain = domain;
            this.beanProperties = beanProperties;
            this.attrKeys = attrKeys;
            this.attrName = attrName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.domain, cacheKey.domain) && Objects.equals(this.beanProperties, cacheKey.beanProperties) && Objects.equals(this.attrKeys, cacheKey.attrKeys) && Objects.equals(this.attrName, cacheKey.attrName);
        }

        public int hashCode() {
            return Objects.hash(this.domain, this.beanProperties, this.attrKeys, this.attrName);
        }
    }

    public static class StalenessTracker {
        private final Set<CacheKey> freshEntries = new HashSet<CacheKey>();

        public void markAsFresh(CacheKey key) {
            this.freshEntries.add(key);
        }

        boolean isFresh(CacheKey key) {
            return this.freshEntries.contains(key);
        }

        public long freshCount() {
            return this.freshEntries.size();
        }
    }
}

