/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.logger;

import io.prometheus.jmx.logger.Level;
import io.prometheus.jmx.logger.LoggerFormatter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.SimpleFormatter;

public class Logger {
    private final java.util.logging.Logger LOGGER;
    private final boolean JMX_PROMETHEUS_EXPORTER_DEVELOPER_DEBUG = "true".equals(System.getenv("JMX_PROMETHEUS_EXPORTER_DEVELOPER_DEBUG")) || "true".equals(System.getProperty("jmx.prometheus.exporter.developer.debug"));
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));

    Logger(Class<?> clazz) {
        this.LOGGER = java.util.logging.Logger.getLogger(clazz.getName());
        for (Handler handler : this.LOGGER.getHandlers()) {
            if (!handler.getFormatter().getClass().getName().endsWith(SimpleFormatter.class.getName())) continue;
            handler.setFormatter(new LoggerFormatter());
        }
    }

    public boolean isTraceEnabled() {
        return this.isLoggable(Level.TRACE);
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.isLoggable(Level.ERROR);
    }

    public void trace(String message) {
        this.trace("%s", (Object)message);
    }

    public void trace(String format, Object object) {
        this.log(Level.TRACE, format, object);
    }

    public void trace(String format, Object ... objects) {
        this.log(Level.TRACE, format, objects);
    }

    public void info(String message) {
        this.info("%s", (Object)message);
    }

    public void info(String format, Object object) {
        this.log(Level.INFO, format, object);
    }

    public void info(String format, Object ... objects) {
        this.log(Level.INFO, format, objects);
    }

    public void warn(String message) {
        this.warn("%s", (Object)message);
    }

    public void warn(String format, Object object) {
        this.log(Level.WARN, format, object);
    }

    public void warn(String format, Object ... objects) {
        this.log(Level.WARN, format, objects);
    }

    public void error(String message) {
        this.error("%s", message);
    }

    public void error(String format, Object ... objects) {
        this.log(Level.ERROR, format, objects);
    }

    private boolean isLoggable(Level level) {
        java.util.logging.Level julLevel = Logger.decode(level);
        return julLevel != null && this.LOGGER.isLoggable(julLevel);
    }

    private void log(Level level, String format, Object ... objects) {
        java.util.logging.Level julLevel;
        if (this.isLoggable(level) && (julLevel = Logger.decode(level)) != null) {
            this.LOGGER.log(julLevel, String.format(format, objects));
        }
        if (this.JMX_PROMETHEUS_EXPORTER_DEVELOPER_DEBUG) {
            String timestamp = SIMPLE_DATE_FORMAT_THREAD_LOCAL.get().format(new Date());
            String threadName = Thread.currentThread().getName();
            String loggerName = this.LOGGER.getName();
            String message = String.format(format, objects);
            System.out.printf("%s | %s | %s | %s | %s%n", new Object[]{timestamp, threadName, Level.TRACE, loggerName, message});
        }
    }

    private static java.util.logging.Level decode(Level level) {
        java.util.logging.Level julLevel;
        switch (level) {
            case TRACE: {
                julLevel = java.util.logging.Level.FINEST;
                break;
            }
            case INFO: {
                julLevel = java.util.logging.Level.INFO;
                break;
            }
            case WARN: {
                julLevel = java.util.logging.Level.WARNING;
                break;
            }
            case ERROR: {
                julLevel = java.util.logging.Level.SEVERE;
                break;
            }
            default: {
                julLevel = null;
            }
        }
        return julLevel;
    }
}

