/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.encryption.executable;

import com.sos.commons.encryption.EncryptionUtils;
import com.sos.commons.exception.SOSException;
import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.sign.keys.key.KeyUtil;
import com.sos.exception.SOSKeyException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class Encrypt {
    private static final String HELP = "--help";
    private static final String HELP_SHORT = "-h";
    private static final String CERT = "--cert";
    private static final String IN = "--in";
    private static final String IN_FILE = "--infile";
    private static final String OUT_FILE = "--outfile";
    private static final String EXPIRE = "--check-expiration";
    private static String certPath;
    private static String filePath;
    private static String outfilePath;
    private static boolean checkExpiration;

    private static SecretKey createSecretKey() throws NoSuchAlgorithmException {
        return EncryptionUtils.generateSecretKey((int)128);
    }

    private static IvParameterSpec createIV() {
        return EncryptionUtils.generateIv();
    }

    public static String encrypt(X509Certificate cert, String input) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, SOSException {
        return Encrypt.encrypt(cert, null, input);
    }

    public static String encrypt(PublicKey pubKey, String input) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, SOSException {
        return Encrypt.encrypt(null, pubKey, input);
    }

    private static String encrypt(X509Certificate cert, PublicKey pubKey, String input) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, SOSException {
        IvParameterSpec iv = Encrypt.createIV();
        SecretKey key = Encrypt.createSecretKey();
        String encryptedKey = null;
        if (cert != null) {
            encryptedKey = new String(EncryptionUtils.encryptSymmetricKey((SecretKey)key, (X509Certificate)cert));
        } else if (pubKey != null) {
            encryptedKey = new String(EncryptionUtils.encryptSymmetricKey((SecretKey)key, (PublicKey)pubKey));
        }
        String ivBase64Encoded = new String(Base64.getEncoder().encode(iv.getIV()));
        String encryptedValue = com.sos.commons.encryption.encrypt.Encrypt.encrypt((String)"AES/CBC/PKCS5Padding", (String)input, (SecretKey)key, (IvParameterSpec)iv);
        String output = com.sos.commons.encryption.encrypt.Encrypt.concatOutput((String)encryptedKey, (String)ivBase64Encoded, (String)encryptedValue);
        return output;
    }

    public static String encryptFile(PublicKey pubKey, Path filePath, Path outfile) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, SOSException, IOException {
        return Encrypt.encryptFile(null, pubKey, filePath, outfile);
    }

    public static String encryptFile(X509Certificate cert, Path filePath, Path outfile) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, SOSException, IOException {
        return Encrypt.encryptFile(cert, null, filePath, outfile);
    }

    private static String encryptFile(X509Certificate cert, PublicKey pubKey, Path filePath, Path outfile) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, SOSException, InvalidAlgorithmParameterException, IOException {
        IvParameterSpec iv = Encrypt.createIV();
        SecretKey key = Encrypt.createSecretKey();
        String encryptedKey = null;
        if (cert != null) {
            encryptedKey = new String(EncryptionUtils.encryptSymmetricKey((SecretKey)key, (X509Certificate)cert));
        } else if (pubKey != null) {
            encryptedKey = new String(EncryptionUtils.encryptSymmetricKey((SecretKey)key, (PublicKey)pubKey));
        }
        String ivBase64Encoded = new String(Base64.getEncoder().encode(iv.getIV()));
        com.sos.commons.encryption.encrypt.Encrypt.encryptFile((String)"AES/CBC/PKCS5Padding", (SecretKey)key, (IvParameterSpec)iv, (Path)filePath, (Path)outfile);
        String output = encryptedKey.concat(" ").concat(ivBase64Encoded).concat(" ").concat(outfile.toString());
        return output;
    }

    public static String format(Date date) {
        String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setLenient(false);
        return df.format(date);
    }

    public static void main(String[] args) {
        X509Certificate cert = null;
        PublicKey pubKey = null;
        String input = null;
        try {
            if (args == null || args.length == 0 || args.length == 1 && (args[0].equalsIgnoreCase(HELP) || args[0].equalsIgnoreCase(HELP_SHORT))) {
                Encrypt.printUsage();
            } else {
                for (int i = 0; i < args.length; ++i) {
                    String[] split = args[i].split("=", 2);
                    if (args[i].startsWith("--cert=")) {
                        certPath = split[1];
                        String fileContent = new String(Files.readAllBytes(Paths.get(certPath, new String[0])), StandardCharsets.UTF_8);
                        if (fileContent.contains("CERTIFICATE")) {
                            cert = KeyUtil.getX509Certificate(fileContent);
                            continue;
                        }
                        try {
                            pubKey = KeyUtil.getRSAPublicKeyFromString(fileContent);
                        }
                        catch (Exception e) {
                            try {
                                pubKey = KeyUtil.getECDSAPublicKeyFromString(fileContent);
                            }
                            catch (Exception e1) {
                                try {
                                    pubKey = KeyUtil.convertToRSAPublicKey(KeyUtil.stripFormatFromPublicKey(fileContent).getBytes());
                                }
                                catch (Exception e2) {
                                    pubKey = KeyUtil.getECPublicKeyFromString(KeyUtil.stripFormatFromPublicKey(fileContent).getBytes());
                                }
                            }
                        }
                        continue;
                    }
                    if (args[i].startsWith("--in=")) {
                        input = split[1];
                        continue;
                    }
                    if (args[i].startsWith("--infile=")) {
                        filePath = split[1];
                        continue;
                    }
                    if (args[i].startsWith("--outfile=")) {
                        outfilePath = split[1];
                        continue;
                    }
                    if (!args[i].startsWith(EXPIRE)) continue;
                    checkExpiration = true;
                }
                if (checkExpiration) {
                    Date now = Date.from(Instant.now());
                    if (cert.getNotBefore().after(now) || cert.getNotAfter().before(now)) {
                        if (cert.getNotAfter().before(now)) {
                            throw new SOSKeyException("Certificate is expired since: " + Encrypt.format(cert.getNotAfter()));
                        }
                        if (cert.getNotBefore().after(now)) {
                            throw new SOSKeyException("Certificate is not valid until: " + Encrypt.format(cert.getNotBefore()));
                        }
                    }
                }
                if (certPath == null || input == null && filePath == null) {
                    if (certPath == null) {
                        if (input == null && filePath == null) {
                            throw new SOSMissingDataException("The parameter --cert and at least one of the parameters --in or --infile is required!");
                        }
                        throw new SOSMissingDataException("The parameter --cert is not set, but is required!");
                    }
                    if (input == null && filePath == null) {
                        throw new SOSMissingDataException("At least one of the parameters --in or --infile is required!");
                    }
                }
                if (input != null) {
                    if (cert != null) {
                        System.out.println(Encrypt.encrypt(cert, input));
                    } else {
                        System.out.println(Encrypt.encrypt(pubKey, input));
                    }
                } else if (filePath != null) {
                    if (outfilePath == null) {
                        throw new SOSMissingDataException("When the parameter --infile is used, the parameter --outfile is also required!");
                    }
                    if (cert != null) {
                        System.out.println(Encrypt.encryptFile(cert, Paths.get(filePath, new String[0]), Paths.get(outfilePath, new String[0])));
                    } else {
                        System.out.println(Encrypt.encryptFile(pubKey, Paths.get(filePath, new String[0]), Paths.get(outfilePath, new String[0])));
                    }
                }
            }
            System.exit(0);
        }
        catch (SOSMissingDataException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }

    public static void printUsage() {
        System.out.println();
        System.out.println("Usage: encrypt [Options] [Switches]");
        System.out.println();
        System.out.println("  Options:");
        System.out.printf("  %-29s | %s%n", "--cert=<path-to-certificate>", "path to the X.509 certificate or public key file used to encrypt the secret.");
        System.out.printf("  %-29s | %s%n", "--in=<secret>", "secret that should be encrypted.");
        System.out.printf("  %-29s | %s%n", "--infile=<path-to-file>", "path to input file that should be encrypted.");
        System.out.printf("  %-29s | %s%n", "--outfile=<path-to-file>", "path to output file with the encrypted content.");
        System.out.println();
        System.out.println("  Switches:");
        System.out.printf("  %-29s | %s%n", "--help | -h", "displays usage. This switch is exclusive without any [Options].");
        System.out.printf("  %-29s | %s%n", "--check-expirationvalidate a certificate\u2019s expiration date before performing cryptographic operations");
        System.out.println();
    }

    static {
        checkExpiration = false;
    }
}

