/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.sign.keys.sign;

import com.sos.commons.sign.keys.interfaces.StreamHandler;
import com.sos.commons.sign.keys.key.KeyUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openssl.PEMKeyPair;

public class SignObject {
    private static final int BUFFER_SIZE = 4096;

    public static String signPGP(String privateKey, String original, String passPhrase) throws IOException, PGPException {
        InputStream privateKeyStream = IOUtils.toInputStream((String)privateKey, (Charset)StandardCharsets.UTF_8);
        InputStream originalStream = IOUtils.toInputStream((String)original, (Charset)StandardCharsets.UTF_8);
        return SignObject.signPGP(privateKeyStream, originalStream, passPhrase);
    }

    public static String signPGP(Path privateKey, Path original, String passPhrase) throws IOException, PGPException {
        InputStream privateKeyPath = Files.newInputStream(privateKey, new OpenOption[0]);
        InputStream originalPath = Files.newInputStream(original, new OpenOption[0]);
        return SignObject.signPGP(privateKeyPath, originalPath, passPhrase);
    }

    public static String signPGP(InputStream privateKey, InputStream original, String passPhrase) throws IOException, PGPException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PGPSecretKey secretKey = KeyUtil.readSecretKey(privateKey);
        PGPPublicKey publicKey = secretKey.getPublicKey();
        PGPPrivateKey pgpPrivateKey = null;
        pgpPrivateKey = passPhrase != null ? secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(passPhrase.toCharArray())) : secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build("".toCharArray()));
        final PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(pgpPrivateKey.getPublicKeyPacket().getAlgorithm(), 8), publicKey);
        signatureGenerator.init(1, pgpPrivateKey);
        ByteArrayOutputStream signatureOutput = new ByteArrayOutputStream();
        try (BCPGOutputStream outputStream = new BCPGOutputStream((OutputStream)new ArmoredOutputStream((OutputStream)signatureOutput));){
            SignObject.processStream(original, new StreamHandler(){

                @Override
                public void handleStreamBuffer(byte[] buffer, int offset, int length) throws IOException {
                    signatureGenerator.update(buffer, offset, length);
                }
            });
            signatureGenerator.generate().encode((OutputStream)outputStream);
        }
        return new String(signatureOutput.toByteArray(), "UTF-8");
    }

    private static void processStream(InputStream is, StreamHandler handler) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = is.read(buffer)) != -1) {
            handler.handleStreamBuffer(buffer, 0, read);
        }
    }

    private static void processStringAsStream(String data, StreamHandler handler) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8.name()));
        SignObject.processStream(is, handler);
    }

    private static void processByteArrayAsStream(byte[] data, StreamHandler handler) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        SignObject.processStream(is, handler);
    }

    public static String signX509(PrivateKey privateKey, String original) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, IOException {
        Signature signature = Signature.getInstance("SHA256WithRSA");
        signature.initSign(privateKey);
        signature.update(original.getBytes("UTF-8"));
        return Base64.getMimeEncoder().encodeToString(signature.sign());
    }

    public static String signX509(String algorythm, PrivateKey privateKey, String original) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Signature signature = Signature.getInstance(algorythm);
        signature.initSign(privateKey);
        signature.update(original.getBytes("UTF-8"));
        return Base64.getMimeEncoder().encodeToString(signature.sign());
    }

    public static final String signX509(String privateKey, String original) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, DataLengthException, CryptoException {
        PEMKeyPair keyPair = KeyUtil.getPemKeyPairFromRSAPrivatKeyString(privateKey);
        PrivateKeyInfo pki = keyPair.getPrivateKeyInfo();
        AsymmetricKeyParameter akpPrivateKey = PrivateKeyFactory.createKey((PrivateKeyInfo)pki);
        RSADigestSigner signer = new RSADigestSigner((Digest)new SHA256Digest());
        signer.init(true, (CipherParameters)akpPrivateKey);
        signer.update(original.getBytes(), 0, original.getBytes().length);
        byte[] signature = signer.generateSignature();
        return Base64.getMimeEncoder().encodeToString(signature);
    }
}

