/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.sign;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JocKeyAlgorithm {
    PGP(0),
    RSA(1),
    ECDSA(2);

    private final Integer value;
    private static final Map<Integer, JocKeyAlgorithm> CONSTANTS;

    private JocKeyAlgorithm(Integer value) {
        this.value = value;
    }

    @JsonValue
    public Integer value() {
        return this.value;
    }

    @JsonCreator
    public static JocKeyAlgorithm fromValue(Integer value) {
        JocKeyAlgorithm constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("" + value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, JocKeyAlgorithm>();
        for (JocKeyAlgorithm c : JocKeyAlgorithm.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

