/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.azure.commons;

import com.sos.commons.httpclient.azure.AzureBlobStorageClient;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.vfs.azure.AzureBlobStorageProvider;
import com.sos.commons.vfs.azure.commons.AzureBlobStorageResource;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.xml.SOSXML;
import com.sos.commons.xml.transform.SOSXmlTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AzureBlobStorageProviderUtils {
    private static final String ROOT_FOLDER = "/";

    public static List<ProviderFile> selectFiles(AzureBlobStorageProvider provider, ProviderFileSelection selection, String containerName, String directoryPath, List<ProviderFile> result) throws Exception {
        int counterAdded = 0;
        AzureBlobStorageProviderUtils.list(provider, selection, containerName, directoryPath, result, counterAdded);
        return result;
    }

    public static AzureBlobStorageResource getResource(AzureBlobStorageProvider provider, String containerName, String blobPath, boolean directory, boolean recursive) throws Exception {
        if (directory) {
            HttpExecutionResult result = provider.getClient().executeGETBlobList(containerName, blobPath, false);
            result.formatWithResponseBody(true);
            int code = result.response().statusCode();
            if (provider.getLogger().isDebugEnabled()) {
                provider.getLogger().debug("%s[getResource][directory]%s", new Object[]{provider.getLogPrefix(), provider.getClient().formatExecutionResultForException(result)});
            }
            if (!HttpUtils.isSuccessful((int)code)) {
                if (HttpUtils.isNotFound((int)code)) {
                    return null;
                }
                throw new IOException(provider.getClient().formatExecutionResultForException(result));
            }
            List<AzureBlobStorageResource> resources = AzureBlobStorageProviderUtils.parseAzureBlobResources(provider, containerName, blobPath, (HttpExecutionResult<String>)result, recursive);
            return resources.isEmpty() ? null : resources.get(0);
        }
        HttpExecutionResult result = provider.getClient().executeHEADBlob(containerName, blobPath);
        result.formatWithResponseBody(true);
        int code = result.response().statusCode();
        if (provider.getLogger().isDebugEnabled()) {
            provider.getLogger().debug("%s[getResource][file]%s", new Object[]{provider.getLogPrefix(), provider.getClient().formatExecutionResultForException(result)});
        }
        if (!HttpUtils.isSuccessful((int)code)) {
            if (HttpUtils.isNotFound((int)code)) {
                return null;
            }
            throw new IOException(provider.getClient().formatExecutionResultForException(result));
        }
        return new AzureBlobStorageResource(containerName, blobPath, false, provider.getClient().getFileSize(result.response()), provider.getClient().getLastModifiedInMillis(result.response()));
    }

    private static int list(AzureBlobStorageProvider provider, ProviderFileSelection selection, String containerName, String directoryPath, List<ProviderFile> result, int counterAdded) throws Exception {
        directoryPath = SOSPathUtils.getUnixStyleDirectoryWithTrailingSeparator((String)directoryPath);
        HttpExecutionResult executeResult = provider.getClient().executeGETBlobList(containerName, directoryPath, false);
        executeResult.formatWithResponseBody(true);
        int code = executeResult.response().statusCode();
        if (provider.getLogger().isDebugEnabled()) {
            provider.getLogger().debug("%s[list][directoryPath=%s]%s", new Object[]{provider.getLogPrefix(), directoryPath, AzureBlobStorageClient.formatExecutionResult((HttpExecutionResult)executeResult)});
        }
        if (!HttpUtils.isSuccessful((int)code)) {
            if (HttpUtils.isNotFound((int)code)) {
                // empty if block
            }
            throw new IOException(provider.getClient().formatExecutionResultForException(executeResult));
        }
        HashSet<String> subDirectories = new HashSet<String>();
        int i = 0;
        for (AzureBlobStorageResource resource : AzureBlobStorageProviderUtils.parseAzureBlobResources(provider, containerName, directoryPath, (HttpExecutionResult<String>)executeResult, selection.getConfig().isRecursive())) {
            if (selection.maxFilesExceeded(counterAdded)) {
                return counterAdded;
            }
            ++i;
            if (provider.getLogger().isDebugEnabled()) {
                provider.getLogger().debug("%s[list][%s]%s", new Object[]{provider.getLogPrefix(), i, resource});
            }
            if (resource.isDirectory()) {
                if (!selection.getConfig().isRecursive() || AzureBlobStorageProviderUtils.isRootFolder(resource.getBlobPath()) || !selection.checkDirectory(resource.getBlobPath())) continue;
                subDirectories.add(resource.getBlobPath());
                continue;
            }
            if (!selection.checkFileName(SOSPathUtils.getName((String)resource.getBlobPath())) || !selection.isValidFileType(resource)) continue;
            ProviderFile file = provider.createProviderFile(resource);
            if (file == null) {
                if (!provider.getLogger().isDebugEnabled()) continue;
                provider.getLogger().debug("%s[list][%s][skip][fullPath=%s]ProviderFile is null", new Object[]{provider.getLogPrefix(), i, resource.getFullPath()});
                continue;
            }
            if (!selection.checkProviderFileMinMaxSize(file)) continue;
            file.setIndex(++counterAdded);
            result.add(file);
            if (!provider.getLogger().isDebugEnabled()) continue;
            provider.getLogger().debug("%s[list][%s][added][fullPath]%s", new Object[]{provider.getLogPrefix(), i, resource.getFullPath()});
        }
        for (String subDirectory : subDirectories) {
            if (selection.maxFilesExceeded(counterAdded)) {
                return counterAdded;
            }
            counterAdded = AzureBlobStorageProviderUtils.list(provider, selection, containerName, subDirectory, result, counterAdded);
        }
        return counterAdded;
    }

    private static List<AzureBlobStorageResource> parseAzureBlobResources(AzureBlobStorageProvider provider, String containerName, String blobPath, HttpExecutionResult<String> result, boolean recursive) throws Exception {
        boolean isDebugEnabled = provider.getLogger().isDebugEnabled();
        String body = SOSXML.removeBOMIfExists((String)((String)result.response().body()).trim());
        NodeList fileNodes = SOSXML.parse((String)body, (boolean)false).getElementsByTagName("Blob");
        if (isDebugEnabled) {
            provider.getLogger().debug("%s[parseAzureBlobResources][blobPath=%s]size=%s", new Object[]{provider.getLogPrefix(), blobPath, fileNodes.getLength()});
        }
        ArrayList<AzureBlobStorageResource> resources = new ArrayList<AzureBlobStorageResource>();
        for (int i = 0; i < fileNodes.getLength(); ++i) {
            String resourcePath;
            Element blob = (Element)fileNodes.item(i);
            if (isDebugEnabled) {
                provider.getLogger().debug("%s[parseAzureBlobResources][%s][file]%s", new Object[]{provider.getLogPrefix(), i, SOSXmlTransformer.nodeToString((Node)blob)});
            }
            if (SOSString.isEmpty((String)(resourcePath = SOSXML.getChildNodeValue((Element)blob, (String)"Name")))) {
                if (!isDebugEnabled) continue;
                provider.getLogger().debug("[parseAzureBlobResources][%s][file][skip]missing Name", new Object[]{i});
                continue;
            }
            resources.add(new AzureBlobStorageResource(containerName, resourcePath, false, AzureBlobStorageProviderUtils.extractSize(blob), AzureBlobStorageProviderUtils.extractLastModified(blob)));
        }
        if (recursive) {
            NodeList subDirectoryNodes = SOSXML.parse((String)body, (boolean)false).getElementsByTagName("BlobPrefix");
            for (int i = 0; i < subDirectoryNodes.getLength(); ++i) {
                String resourcePath;
                Element blob = (Element)subDirectoryNodes.item(i);
                if (isDebugEnabled) {
                    provider.getLogger().debug("%s[parseAzureBlobResources][%s][directory]%s", new Object[]{provider.getLogPrefix(), i, SOSXmlTransformer.nodeToString((Node)blob)});
                }
                if (SOSString.isEmpty((String)(resourcePath = SOSXML.getChildNodeValue((Element)blob, (String)"Name")))) {
                    if (!isDebugEnabled) continue;
                    provider.getLogger().debug("[parseAzureBlobResources][%s][directory][skip]missing Name", new Object[]{i});
                    continue;
                }
                if (AzureBlobStorageProviderUtils.isRootFolder(resourcePath)) continue;
                resources.add(new AzureBlobStorageResource(containerName, resourcePath, true, -1L, -1L));
            }
        }
        return resources;
    }

    private static long extractSize(Element blob) {
        String contentLength = SOSXML.getChildNodeValue((Element)blob, (String)"Content-Length");
        if (!SOSString.isEmpty((String)contentLength)) {
            try {
                return Long.parseLong(contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private static long extractLastModified(Element blob) {
        String lastModified = SOSXML.getChildNodeValue((Element)blob, (String)"Last-Modified");
        if (SOSString.isEmpty((String)lastModified)) {
            return -1L;
        }
        return HttpUtils.httpDateToMillis((String)lastModified);
    }

    private static boolean isRootFolder(String directoryPath) {
        if (directoryPath == null) {
            return true;
        }
        return ROOT_FOLDER.equals(directoryPath);
    }
}

