/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ftp.commons;

import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;

public class FTPProviderArguments
extends AProviderArguments {
    protected static final int DEFAULT_PORT = 21;
    private SOSArgument<String> keepAliveTimeout = new SOSArgument("KeepAliveTimeout", false, (Object)"180");
    private SOSArgument<Boolean> protocolCommandListener = new SOSArgument("ProtocolCommandListener", false, (Object)false);
    private SOSArgument<Boolean> passiveMode = new SOSArgument("PassiveMode", false, (Object)false);
    private SOSArgument<TransferMode> transferMode = new SOSArgument("TransferMode", false, (Object)TransferMode.BINARY);

    public FTPProviderArguments() {
        this.getProtocol().setValue((Object)AProviderArguments.Protocol.FTP);
        this.getPort().setDefaultValue((Object)21);
        this.getUser().setRequired(true);
    }

    protected FTPProviderArguments(Object dummy) {
        this.getUser().setRequired(true);
    }

    @Override
    public String getAccessInfo() throws ProviderInitializationException {
        return String.format("%s@%s:%s", this.getUser().getDisplayValue(), this.getHost().getDisplayValue(), this.getPort().getDisplayValue());
    }

    @Override
    public String getAdvancedAccessInfo() {
        return null;
    }

    public boolean isBinaryTransferMode() {
        return TransferMode.BINARY.equals(this.transferMode.getValue());
    }

    public boolean isPassiveMode() {
        return this.passiveMode.isTrue();
    }

    public SOSArgument<String> getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public int getKeepAliveTimeoutAsSeconds() {
        return (int)SOSArgumentHelper.asSeconds(this.keepAliveTimeout, (long)0L);
    }

    public SOSArgument<Boolean> getProtocolCommandListener() {
        return this.protocolCommandListener;
    }

    public SOSArgument<Boolean> getPassiveMode() {
        return this.passiveMode;
    }

    public SOSArgument<TransferMode> getTransferMode() {
        return this.transferMode;
    }

    public String getTransferModeValue() {
        return this.transferMode.getValue() == null ? null : ((TransferMode)((Object)this.transferMode.getValue())).name().toLowerCase();
    }

    public static enum TransferMode {
        ASCII,
        BINARY;


        public static TransferMode fromString(String type) {
            if (SOSString.isEmpty((String)type)) {
                return null;
            }
            return TransferMode.valueOf(type.trim().toUpperCase());
        }
    }
}

