/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.smb.smbj;

import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.vfs.smb.smbj.SMBJProviderUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

public class SMBJOutputStream
extends OutputStream {
    private final DiskShare share;
    private final boolean closeShare;
    private final File file;
    private final OutputStream os;

    public SMBJOutputStream(boolean accessMaskMaximumAllowed, DiskShare share, boolean closeShare, String smbPath, boolean append) throws IOException {
        this.share = share;
        this.closeShare = closeShare;
        this.file = SMBJProviderUtils.openFileWithWriteAccess(accessMaskMaximumAllowed, share, smbPath, append);
        this.os = this.file.getOutputStream(append);
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        SOSClassUtil.closeQuietly((Closeable)this.os);
        SOSClassUtil.closeQuietly((Closeable)this.file);
        if (this.closeShare) {
            SOSClassUtil.closeQuietly((AutoCloseable)this.share);
        }
        super.close();
    }
}

