/*
 * Decompiled with CFR 0.152.
 */
package com.sos.loganonymizer;

import com.sos.loganonymizer.classes.DefaultRulesTable;
import com.sos.loganonymizer.classes.Rule;
import com.sos.loganonymizer.classes.SOSRules;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class SOSLogAnonymizerExecuter
extends DefaultRulesTable {
    private static final String ANONYMIZED = "anonymized-";
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSLogAnonymizerExecuter.class);
    private Path outputDir;
    private List<String> listOfLogfileNames = new ArrayList<String>();
    private List<Rule> listOfDefaultRules;
    private List<Rule> listOfRules = new ArrayList<Rule>();

    public SOSLogAnonymizerExecuter() {
        this.initDefaultRules();
    }

    private void addRule(String item, String search, String ... replace) {
        if (this.listOfDefaultRules == null) {
            this.listOfDefaultRules = new ArrayList<Rule>();
        }
        Rule rule = new Rule();
        rule.setItem(item);
        rule.setReplace(replace);
        rule.setSearch(search);
        this.listOfDefaultRules.add(rule);
    }

    private void initDefaultRules() {
        this.listOfRules.addAll(this.listOfDefaultRules);
    }

    public void addLogfileName(String logfileName) {
        this.listOfLogfileNames.add(logfileName);
    }

    private String executeReplace(String line) {
        for (Rule rule : this.listOfRules) {
            Matcher m = Pattern.compile(rule.getSearch()).matcher(line);
            int start = 0;
            StringBuilder ret = new StringBuilder();
            while (m.find()) {
                for (int g = 1; g <= m.groupCount(); ++g) {
                    if (rule.getReplace().length < g) continue;
                    ret.append(line.substring(start, m.start(g)) + rule.getReplace()[g - 1]);
                    start = m.end(g);
                }
            }
            if (start <= 0) continue;
            ret.append(line.substring(start));
            line = ret.toString();
        }
        return line;
    }

    public static boolean isGZipped(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        in.mark(2);
        int magic = 0;
        try {
            magic = in.read() & 0xFF | in.read() << 8 & 0xFF00;
            in.reset();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            return false;
        }
        return magic == 35615;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSubstitution() {
        int ret = 0;
        for (String logFilename : this.listOfLogfileNames) {
            LOGGER.debug("input ---> " + logFilename);
            Path pLogFilename = Paths.get(logFilename, new String[0]);
            if (this.outputDir == null) {
                this.outputDir = pLogFilename.toAbsolutePath().normalize().getParent();
            }
            Path output = this.outputDir.resolve(ANONYMIZED + pLogFilename.getFileName().toString());
            BufferedReader r = null;
            BufferedWriter writer = null;
            InputStream is = null;
            try {
                is = Files.newInputStream(pLogFilename, new OpenOption[0]);
                if (SOSLogAnonymizerExecuter.isGZipped(is)) {
                    FileInputStream fileInputStream = new FileInputStream(logFilename);
                    GZIPInputStream gzipInputStream = new GZIPInputStream(fileInputStream);
                    InputStreamReader isReader = new InputStreamReader((InputStream)gzipInputStream, StandardCharsets.UTF_8);
                    r = new BufferedReader(isReader);
                    if (logFilename.endsWith(".gz")) {
                        output = this.outputDir.resolve(ANONYMIZED + Paths.get(logFilename.substring(0, logFilename.length() - 3), new String[0]).getFileName().toString());
                    }
                } else {
                    r = Files.newBufferedReader(pLogFilename);
                }
                writer = Files.newBufferedWriter(output, new OpenOption[0]);
                LOGGER.info("Output file " + output.toString());
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        String replacedLine = this.executeReplace(line);
                        writer.write(replacedLine);
                        writer.newLine();
                        if (line.equals(replacedLine)) continue;
                        LOGGER.debug(line);
                        LOGGER.debug(replacedLine);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
                ++ret;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                if (r == null) continue;
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    public void setRules(String rules) throws Exception {
        if (rules == null || rules.isEmpty()) {
            throw new IOException("No rule file specified.");
        }
        this.listOfRules.clear();
        LoaderOptions loaderOptions = new LoaderOptions();
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(SOSRules.class, loaderOptions));
        Path rulesPath = Paths.get(rules, new String[0]);
        if (!Files.exists(rulesPath, new LinkOption[0])) {
            throw new FileNotFoundException(rules + " doesn't exist.");
        }
        SOSRules sosRules = (SOSRules)yaml.load(Files.newInputStream(rulesPath, new OpenOption[0]));
        if (sosRules.getRules() != null) {
            this.listOfRules.addAll(sosRules.getRules());
        }
    }

    public void setLogfiles(String logfileName) {
        block33: {
            LOGGER.debug("Adding log file:" + logfileName);
            if (logfileName != null && !logfileName.isEmpty()) {
                if (this.listOfLogfileNames == null) {
                    this.listOfLogfileNames = new ArrayList<String>();
                }
                boolean isDirectory = false;
                boolean isFile = false;
                Path path = null;
                try {
                    path = Paths.get(logfileName, new String[0]);
                    isDirectory = Files.isDirectory(path, new LinkOption[0]);
                    isFile = Files.isRegularFile(path, new LinkOption[0]);
                    if (isFile) {
                        LOGGER.debug("is file");
                        if (Files.exists(path, new LinkOption[0])) {
                            if (!path.getFileName().toString().startsWith(ANONYMIZED)) {
                                this.listOfLogfileNames.add(path.toString());
                            }
                        } else {
                            LOGGER.info("File not found: " + path.toString());
                        }
                        break block33;
                    }
                    if (isDirectory) {
                        LOGGER.debug("is directory");
                        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(logfileName, new String[0]));){
                            dirStream.forEach(pathLogfile -> {
                                if (Files.isRegularFile(pathLogfile, new LinkOption[0]) && !pathLogfile.getFileName().toString().startsWith(ANONYMIZED)) {
                                    this.listOfLogfileNames.add(pathLogfile.toString());
                                }
                            });
                            break block33;
                        }
                        catch (IOException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                        break block33;
                    }
                    logfileName = logfileName.replace('\\', '/');
                    String[] logfileParts = logfileName.split("/");
                    String lastPart = logfileParts[logfileParts.length - 1];
                    String s = logfileName.replace("/" + lastPart, "");
                    LOGGER.debug("wildcard:" + lastPart);
                    try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(s, new String[0]), lastPart);){
                        dirStream.forEach(pathLogfile -> {
                            if (Files.isRegularFile(pathLogfile, new LinkOption[0]) && !pathLogfile.getFileName().toString().startsWith(ANONYMIZED)) {
                                this.listOfLogfileNames.add(pathLogfile.toString());
                            }
                        });
                    }
                    catch (IOException e3) {
                        LOGGER.error("", (Throwable)e3);
                    }
                }
                catch (InvalidPathException e) {
                    logfileName = logfileName.replace('\\', '/');
                    String[] logfileParts = logfileName.split("/");
                    String lastPart = logfileParts[logfileParts.length - 1];
                    String s = logfileName.replace("/" + lastPart, "");
                    LOGGER.debug("Exception. try wildcard " + lastPart);
                    try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(s, new String[0]), lastPart);){
                        dirStream.forEach(pathLogfile -> {
                            if (Files.isRegularFile(pathLogfile, new LinkOption[0]) && !pathLogfile.getFileName().toString().startsWith(ANONYMIZED)) {
                                this.listOfLogfileNames.add(pathLogfile.toString());
                            }
                        });
                    }
                    catch (IOException e2) {
                        LOGGER.error("", (Throwable)e2);
                    }
                }
            }
        }
    }

    public void exportRules(String exportFile) throws IOException {
        if (exportFile == null || exportFile.isEmpty()) {
            throw new IOException("No export file is specified.");
        }
        Path exportPath = Paths.get(exportFile, new String[0]);
        if (Files.isDirectory(exportPath, new LinkOption[0])) {
            throw new IOException(exportFile + " is a directory.");
        }
        Path parent = exportPath.toAbsolutePath().normalize().getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        options.setProcessComments(true);
        options.setCanonical(false);
        Representer representer = new Representer(options);
        representer.addClassTag(SOSRules.class, Tag.MAP);
        Yaml yaml = new Yaml(representer);
        SOSRules defaultRules = new SOSRules();
        defaultRules.getRules().addAll(this.listOfDefaultRules);
        yaml.dump((Object)defaultRules, (Writer)Files.newBufferedWriter(exportPath, new OpenOption[0]));
    }

    public List<Rule> getListOfRules() {
        return this.listOfRules;
    }

    @Override
    protected void add(String item, String search, String ... replace) {
        this.addRule(item, search, replace);
    }

    public void setOutputdir(String outputDir) throws IOException {
        if (outputDir != null && !outputDir.isEmpty()) {
            this.outputDir = Paths.get(outputDir, new String[0]);
            if (!Files.isDirectory(this.outputDir, new LinkOption[0])) {
                throw new IOException(outputDir + " is not a directory");
            }
        }
    }
}

