/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.commons;

import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.util.beans.SOSEnv;
import com.sos.commons.util.beans.SOSTimeout;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.util.proxy.ProxyConfig;
import com.sos.commons.util.proxy.ProxyConfigArguments;
import com.sos.commons.util.ssl.SslArguments;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.commons.AProviderContext;
import com.sos.commons.vfs.commons.AProviderReusableResource;
import com.sos.commons.vfs.commons.IProvider;
import com.sos.commons.vfs.commons.ProviderCredentialStoreResolver;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.ProviderFileBuilder;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelectionConfig;
import com.sos.commons.vfs.exceptions.ProviderConnectException;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;

public abstract class AProvider<A extends AProviderArguments>
implements IProvider {
    public static long DEFAULT_FILE_ATTR_VALUE = -1L;
    private final ISOSLogger logger;
    private final A arguments;
    private final ProxyConfig proxyConfig;
    private Function<ProviderFileBuilder, ProviderFile> providerFileCreator = builder -> builder.build(this);
    private AProviderContext context;
    private AProviderReusableResource<?> reusableResource;
    private String accessInfo;
    private String label;

    public AProvider(ISOSLogger logger, A arguments, SOSArgument<?> ... additionalCredentialStoreArg) throws ProviderInitializationException {
        this.logger = logger;
        this.arguments = arguments;
        this.resolveCredentialStore(additionalCredentialStoreArg);
        this.proxyConfig = this.arguments == null ? null : ProxyConfig.createInstance((ProxyConfigArguments)((AProviderArguments)((Object)this.arguments)).getProxy());
    }

    public abstract void validatePrerequisites(String var1) throws ProviderException;

    @Override
    public void setProviderFileCreator(Function<ProviderFileBuilder, ProviderFile> val) {
        this.providerFileCreator = val;
    }

    @Override
    public void setContext(AProviderContext val) {
        this.context = val;
    }

    @Override
    public AProviderContext getContext() {
        return this.context;
    }

    @Override
    public void ensureConnected() throws ProviderConnectException {
        if (!this.isConnected()) {
            this.disconnect();
            this.connect();
        }
    }

    @Override
    public boolean createDirectoriesIfNotExists(Collection<String> paths) throws ProviderException {
        if (SOSCollection.isEmpty(paths)) {
            return false;
        }
        this.validatePrerequisites("createDirectoriesIfNotExists");
        boolean result = false;
        for (String path : paths) {
            if (!this.createDirectoriesIfNotExists(path)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public ProviderFile rereadFileIfExists(ProviderFile file) throws ProviderException {
        this.validatePrerequisites("rereadFileIfExists");
        try {
            return this.refreshFileMetadata(file, this.getFileIfExists(file.getFullPath()));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(file.getFullPath()), e);
        }
    }

    @Override
    public String toPathStyle(String path) {
        return SOSPathUtils.isUnixStylePathSeparator((String)this.getPathSeparator()) ? SOSPathUtils.toUnixStyle((String)path) : SOSPathUtils.toWindowsStyle((String)path);
    }

    @Override
    public void onInputStreamClosed(String path) throws ProviderException {
    }

    @Override
    public void onOutputStreamClosed(String path) throws ProviderException {
    }

    @Override
    public SOSCommandResult executeCommand(String command) {
        return this.executeCommand(command, null, null);
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout) {
        return this.executeCommand(command, timeout, null);
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSEnv env) {
        return this.executeCommand(command, null, env);
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout, SOSEnv env) {
        this.logNotImpementedMethod("executeCommand", "[command]" + command);
        return null;
    }

    @Override
    public SOSCommandResult cancelCommands() {
        return null;
    }

    public void enableReusableResource() {
    }

    public void enableReusableResource(AProviderReusableResource<?> resource) throws Exception {
        this.reusableResource = resource;
    }

    public AProviderReusableResource<?> getReusableResource() {
        return this.reusableResource;
    }

    public void disableReusableResource() {
        if (this.reusableResource != null) {
            SOSClassUtil.closeQuietly(this.reusableResource);
            this.reusableResource = null;
        }
    }

    public Properties getConfigurationPropertiesFromFiles() {
        if (SOSCollection.isEmpty((Collection)((Collection)((AProviderArguments)((Object)this.getArguments())).getConfigurationFiles().getValue()))) {
            return null;
        }
        String method = "getConfigurationPropertiesFromFiles";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[%s][%s]%s", new Object[]{this.getLabel(), method, SOSString.join((Collection)((Collection)((AProviderArguments)((Object)this.getArguments())).getConfigurationFiles().getValue()), (String)",", f -> f.toString())});
        }
        Properties p = new Properties();
        for (Path file : (List)((AProviderArguments)((Object)this.getArguments())).getConfigurationFiles().getValue()) {
            if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    p.load(reader);
                    this.logger.info("[%s][%s][%s]loaded", new Object[]{this.getLabel(), method, file});
                }
                catch (Throwable e) {
                    this.logger.warn("[%s][%s][%s][failed]%s", new Object[]{this.getLabel(), method, file, e.toString()});
                }
                continue;
            }
            this.logger.warn("[%s][%s][%s]does not exist or is not a regular file", new Object[]{this.getLabel(), method, file});
        }
        if (this.logger.isDebugEnabled()) {
            for (String n : p.stringPropertyNames()) {
                String v = p.getProperty(n);
                this.logger.debug("[%s][%s]%s=%s", new Object[]{this.getLabel(), method, n, v});
            }
        }
        return p;
    }

    public ProviderFile createProviderFile(String fullPath, long size, long lastModifiedMillis) {
        return this.providerFileCreator.apply(new ProviderFileBuilder().fullPath(fullPath).size(size).lastModifiedMillis(lastModifiedMillis));
    }

    public List<ProviderFile> selectFiles(String directory) throws ProviderException {
        return this.selectFiles(new ProviderFileSelection(new ProviderFileSelectionConfig.Builder().directory(directory).build()));
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.context == null ? "" : this.context.getLabel();
        }
        return this.label;
    }

    public String getPathOperationPrefix(String path) {
        return this.getLogPrefix() + "[" + path + "]";
    }

    public String getLogPrefix() {
        return SOSString.isEmpty((String)this.getLabel()) ? "" : "[" + this.getLabel() + "]";
    }

    public ProviderFile refreshFileMetadata(ProviderFile file, ProviderFile fileAfterReread) {
        if (fileAfterReread == null || file == null) {
            return null;
        }
        file.setSize(fileAfterReread.getSize());
        file.setLastModifiedMillis(fileAfterReread.getLastModifiedMillis());
        return file;
    }

    public void validateArgument(String method, String argValue, String msg) throws ProviderException {
        if (SOSString.isEmpty((String)argValue)) {
            throw new ProviderException(this.getLogPrefix() + "[" + method + "]" + msg + " missing");
        }
    }

    public void validateArgument(String method, InputStream argValue, String msg) throws ProviderException {
        if (argValue == null) {
            throw new ProviderException(this.getLogPrefix() + "[" + method + "]" + msg + " missing");
        }
    }

    public void validateModificationTime(String path, long milliseconds) throws ProviderException {
        if (!AProvider.isValidModificationTime(milliseconds)) {
            throw new ProviderException(this.getLogPrefix() + "[" + path + "][" + milliseconds + "]not valid modification time");
        }
    }

    public Function<ProviderFileBuilder, ProviderFile> getProviderFileCreator() {
        return this.providerFileCreator;
    }

    public ISOSLogger getLogger() {
        return this.logger;
    }

    public A getArguments() {
        return this.arguments;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public String getConnectMsg() {
        return String.format("%s[connect]%s ...", this.getLogPrefix(), this.accessInfo);
    }

    public String getConnectedMsg() {
        return this.getConnectedMsg(null);
    }

    public String getConnectedMsg(String additionalInfos) {
        String add = SOSString.isEmpty((String)additionalInfos) ? this.accessInfo : "[" + this.accessInfo + "]" + additionalInfos;
        return String.format("%s[connected]%s", this.getLogPrefix(), add);
    }

    public String getDisconnectedMsg() {
        return String.format("%s[disconnected]%s", this.getLogPrefix(), this.accessInfo);
    }

    public String getAccessInfo() {
        return this.accessInfo;
    }

    public void setAccessInfo(String val) {
        this.accessInfo = this.proxyConfig == null ? val : "[proxy " + this.proxyConfig.getAccessInfo() + "]" + val;
    }

    public String getDirectoryNotFoundMsg(String directory) {
        return this.getLogPrefix() + "[Directory]" + directory;
    }

    public static String millis2string(int val) {
        if (val <= 0) {
            return String.valueOf(val).concat("ms");
        }
        try {
            return String.valueOf(Math.round(val / 1000)).concat("s");
        }
        catch (Throwable e) {
            return String.valueOf(val).concat("ms");
        }
    }

    public static boolean isValidFileSize(long fileSize) {
        return fileSize >= 0L;
    }

    public static boolean isValidModificationTime(long milliseconds) {
        return milliseconds > 0L;
    }

    public void logIfHostnameVerificationDisabled(SslArguments args) {
        if (!args.getUntrustedSslVerifyCertificateHostname().isTrue()) {
            String name = args.getUntrustedSslVerifyCertificateHostname().getName();
            Boolean val = (Boolean)args.getUntrustedSslVerifyCertificateHostname().getValue();
            if (args.getUntrustedSslVerifyCertificateHostnameOppositeName() != null) {
                name = args.getUntrustedSslVerifyCertificateHostnameOppositeName();
                val = val == false;
            }
            this.logger.info((Object)"*********************** Security warning *********************************************************************");
            this.logger.info("\"%s\" is currently \"%s\" for %s connections. ", new Object[]{name, val, ((AProviderArguments)((Object)this.getArguments())).getProtocol().getValue()});
            this.logger.info((Object)"The certificate verification process will not verify the DNS name of the certificate presented by the server,");
            this.logger.info((Object)"with the hostname of the server used by the client connection.");
            this.logger.info((Object)"**************************************************************************************************************");
        }
    }

    public void logNotImpementedMethod(String methodName, String add) {
        this.logger.info("[%s][%s][%s][not implemented yet]%s", new Object[]{this.getLabel(), this.getClass().getSimpleName(), methodName, add});
    }

    public void onCredentialStoreResolved() throws Exception {
    }

    private void resolveCredentialStore(SOSArgument<?> ... additionalCredentialStoreArg) throws ProviderInitializationException {
        if (this.arguments == null) {
            return;
        }
        try {
            if (ProviderCredentialStoreResolver.resolve(this.arguments, ((AProviderArguments)((Object)this.arguments)).getProxy(), additionalCredentialStoreArg)) {
                this.onCredentialStoreResolved();
            }
        }
        catch (Throwable e) {
            throw new ProviderInitializationException(e);
        }
    }
}

