/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.commons.file;

import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.commons.IProvider;
import java.util.TimeZone;

public class ProviderFile {
    private String fullPath;
    private String name;
    private long size;
    private long lastModifiedMillis;
    private int index;

    public ProviderFile(IProvider provider, String fullPath, long size, long lastModifiedMillis) {
        this.setFullPath(provider, fullPath);
        if (this.fullPath != null) {
            this.size = size;
            this.lastModifiedMillis = lastModifiedMillis;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    private void setFullPath(IProvider provider, String val) {
        if (val == null) {
            this.fullPath = null;
            this.name = null;
            this.size = AProvider.DEFAULT_FILE_ATTR_VALUE;
            this.lastModifiedMillis = AProvider.DEFAULT_FILE_ATTR_VALUE;
        } else {
            this.fullPath = provider.toPathStyle(val);
            this.name = SOSPathUtils.getName((String)this.fullPath);
        }
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long val) {
        this.size = val;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int val) {
        this.index = val;
    }

    public long getLastModifiedMillis() {
        return this.lastModifiedMillis;
    }

    public void setLastModifiedMillis(long val) {
        this.lastModifiedMillis = val;
    }

    public String getLastModifiedAsUTCString() {
        return AProvider.isValidModificationTime(this.lastModifiedMillis) ? SOSDate.tryGetDateTimeAsString((long)this.lastModifiedMillis, (TimeZone)TimeZone.getTimeZone("Etc/UTC")) : String.valueOf(this.lastModifiedMillis);
    }
}

