/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.local;

import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.util.beans.SOSEnv;
import com.sos.commons.util.beans.SOSTimeout;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exceptions.ProviderConnectException;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.exceptions.ProviderNoSuchFileException;
import com.sos.commons.vfs.local.commons.LocalProviderArguments;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LocalProvider
extends AProvider<LocalProviderArguments> {
    public LocalProvider(ISOSLogger logger, LocalProviderArguments args) throws ProviderInitializationException {
        super(logger, args, new SOSArgument[0]);
        this.setAccessInfo(((LocalProviderArguments)((Object)this.getArguments())).getAccessInfo());
    }

    @Override
    public String getPathSeparator() {
        return FileSystems.getDefault().getSeparator();
    }

    @Override
    public boolean isAbsolutePath(String path) {
        return SOSPathUtils.isAbsoluteFileSystemPath((String)path);
    }

    @Override
    public String normalizePath(String path) {
        return this.toPathStyle(this.getAbsoluteNormalizedPath(path).toString());
    }

    @Override
    public void connect() throws ProviderConnectException {
        this.getLogger().info((Object)this.getAccessInfo());
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public List<ProviderFile> selectFiles(ProviderFileSelection selection) throws ProviderException {
        selection = ProviderFileSelection.createIfNull(selection);
        selection.setFileTypeChecker(fileRepresentator -> {
            if (fileRepresentator == null) {
                return false;
            }
            BasicFileAttributes r = (BasicFileAttributes)fileRepresentator;
            return r.isRegularFile() && ((EnumSet)((LocalProviderArguments)((Object)((Object)this.getArguments()))).getValidFileTypes().getValue()).contains((Object)AProviderArguments.FileType.REGULAR) || r.isSymbolicLink() && ((EnumSet)((LocalProviderArguments)((Object)((Object)this.getArguments()))).getValidFileTypes().getValue()).contains((Object)AProviderArguments.FileType.SYMLINK);
        });
        Path directory = Paths.get(selection.getConfig().getDirectory() == null ? "" : selection.getConfig().getDirectory(), new String[0]);
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new ProviderNoSuchFileException(this.getDirectoryNotFoundMsg(directory.toString()));
        }
        try {
            List<ProviderFile> result = selection.getConfig().isRecursive() ? this.selectFilesRecursive(selection, directory) : this.selectFilesNonRecursive(selection, directory);
            return result;
        }
        catch (Exception e) {
            throw new ProviderException(this.getPathOperationPrefix(directory.toString()), e);
        }
    }

    @Override
    public boolean exists(String path) throws ProviderException {
        this.validateArgument("exists", path, "path");
        try {
            return this.exists(this.getAbsoluteNormalizedPath(path));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean createDirectoriesIfNotExists(String path) throws ProviderException {
        this.validateArgument("createDirectoriesIfNotExists", path, "path");
        try {
            Path p = this.getAbsoluteNormalizedPath(path);
            if (this.exists(p)) {
                return false;
            }
            Files.createDirectories(p, new FileAttribute[0]);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("%s[createDirectoriesIfNotExists][%s]created", new Object[]{this.getLogPrefix(), path});
            }
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean deleteIfExists(String path) throws ProviderException {
        this.validateArgument("deleteIfExists", path, "path");
        try {
            return SOSPath.deleteIfExists((Path)this.getAbsoluteNormalizedPath(path));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean deleteFileIfExists(String path) throws ProviderException {
        this.validateArgument("deleteFileIfExists", path, "path");
        try {
            return Files.deleteIfExists(this.getAbsoluteNormalizedPath(path));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean renameFileIfSourceExists(String source, String target) throws ProviderException {
        this.validateArgument("renameFileIfSourceExists", source, "source");
        this.validateArgument("renameFileIfSourceExists", target, "target");
        try {
            Path p = this.getAbsoluteNormalizedPath(source);
            if (this.exists(p)) {
                SOSPath.renameTo((Path)p, (Path)this.getAbsoluteNormalizedPath(target));
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(source + "->" + target), e);
        }
    }

    @Override
    public ProviderFile getFileIfExists(String path) throws ProviderException {
        this.validateArgument("getFileIfExists", path, "path");
        try {
            Path normalizedPath = this.getAbsoluteNormalizedPath(path);
            if (!this.exists(normalizedPath)) {
                return null;
            }
            return this.createProviderFile(normalizedPath);
        }
        catch (IOException e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public String getFileContentIfExists(String path) throws ProviderException {
        this.validateArgument("getFileContentIfExists", path, "path");
        try {
            Path p = this.getAbsoluteNormalizedPath(path);
            if (!this.exists(p)) {
                return null;
            }
            return SOSPath.readFile((Path)p);
        }
        catch (IOException e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void writeFile(String path, String content) throws ProviderException {
        this.validateArgument("writeFile", path, "path");
        try {
            SOSPath.overwrite((Path)this.getAbsoluteNormalizedPath(path), (String)content);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void setFileLastModifiedFromMillis(String path, long milliseconds) throws ProviderException {
        this.validateArgument("setFileLastModifiedFromMillis", path, "path");
        this.validateModificationTime(path, milliseconds);
        try {
            SOSPath.setLastModifiedFromMillis((String)path, (long)milliseconds);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public InputStream getInputStream(String path) throws ProviderException {
        this.validateArgument("getInputStream", path, "path");
        try {
            return Files.newInputStream(this.getAbsoluteNormalizedPath(path), new OpenOption[0]);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append) throws ProviderException {
        this.validateArgument("getOutputStream", path, "path");
        try {
            Path p = this.getAbsoluteNormalizedPath(path);
            if (append) {
                return Files.newOutputStream(p, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            return Files.newOutputStream(p, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout, SOSEnv env) {
        return SOSShell.executeCommand((String)command, (SOSTimeout)timeout, (SOSEnv)env);
    }

    @Override
    public SOSCommandResult cancelCommands() {
        return new SOSCommandResult("nop");
    }

    @Override
    public void validatePrerequisites(String method) throws ProviderException {
    }

    private Path getAbsoluteNormalizedPath(String path) {
        return SOSPath.toAbsoluteNormalizedPath((String)path);
    }

    private boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    private ProviderFile createProviderFile(Path path) throws IOException {
        return this.createProviderFile(path, this.readFileAttributes(path));
    }

    private ProviderFile createProviderFile(Path path, BasicFileAttributes attr) throws IOException {
        return this.createProviderFile(path.toAbsolutePath().normalize().toString(), attr.size(), this.getFileLastModifiedMillis(attr));
    }

    private BasicFileAttributes readFileAttributes(Path path) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
    }

    private long getFileLastModifiedMillis(BasicFileAttributes attr) {
        return attr.lastModifiedTime().to(TimeUnit.MILLISECONDS);
    }

    private List<ProviderFile> selectFilesRecursive(final ProviderFileSelection selection, Path directory) throws Exception {
        final boolean isDebugEnabled = this.getLogger().isDebugEnabled();
        final boolean isTraceEnabled = this.getLogger().isTraceEnabled();
        final ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            int counterAdded = 0;

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                if (selection.maxFilesExceeded(this.counterAdded)) {
                    if (isDebugEnabled) {
                        LocalProvider.this.getLogger().debug((Object)String.format("%s[skip][preVisitDirectory][maxFiles=%s]exceeded", LocalProvider.this.getPathOperationPrefix(path.toString()), selection.getConfig().getMaxFiles()));
                    }
                    return FileVisitResult.TERMINATE;
                }
                if (selection.checkDirectory(path.toAbsolutePath().toString())) {
                    return FileVisitResult.CONTINUE;
                }
                if (isDebugEnabled) {
                    LocalProvider.this.getLogger().debug((Object)String.format("%s[preVisitDirectory][match][excludedDirectories=%s]", LocalProvider.this.getPathOperationPrefix(path.toString()), selection.getConfig().getExcludedDirectoriesPattern().pattern()));
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isDirectory()) {
                    ProviderFile file;
                    BasicFileAttributes attr;
                    String fileName;
                    if (selection.maxFilesExceeded(this.counterAdded)) {
                        if (isDebugEnabled) {
                            LocalProvider.this.getLogger().debug((Object)String.format("%s[skip][preVisitDirectory][maxFiles=%s]exceeded", LocalProvider.this.getPathOperationPrefix(path.toString()), selection.getConfig().getMaxFiles()));
                        }
                        return FileVisitResult.TERMINATE;
                    }
                    if (isTraceEnabled) {
                        LocalProvider.this.getLogger().trace((Object)String.format("%s[visitFile]", LocalProvider.this.getPathOperationPrefix(path.toString())));
                    }
                    if (selection.checkFileName(fileName = path.getFileName().toString()) && selection.isValidFileType(attr = LocalProvider.this.readFileAttributes(path)) && (file = LocalProvider.this.createProviderFile(path, attr)) != null && selection.checkProviderFileMinMaxSize(file)) {
                        ++this.counterAdded;
                        file.setIndex(this.counterAdded);
                        result.add(file);
                        if (isDebugEnabled) {
                            LocalProvider.this.getLogger().debug((Object)(LocalProvider.this.getPathOperationPrefix(path.toString()) + "added"));
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }

    private List<ProviderFile> selectFilesNonRecursive(ProviderFileSelection selection, Path directory) throws Exception {
        boolean isDebugEnabled = this.getLogger().isDebugEnabled();
        boolean isTraceEnabled = this.getLogger().isTraceEnabled();
        if (isDebugEnabled) {
            this.getLogger().debug((Object)SOSString.toString((Object)selection.getConfig(), (boolean)true));
        }
        ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
        int counterAdded = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path path : stream) {
                ProviderFile file;
                BasicFileAttributes attr;
                String fileName;
                if (selection.maxFilesExceeded(counterAdded)) {
                    if (isDebugEnabled) {
                        this.getLogger().debug((Object)String.format("%s[skip][preVisitDirectory][maxFiles=%s]exceeded", this.getPathOperationPrefix(path.toString()), selection.getConfig().getMaxFiles()));
                    }
                    ArrayList<ProviderFile> arrayList = result;
                    return arrayList;
                }
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                if (isTraceEnabled) {
                    this.getLogger().trace((Object)this.getPathOperationPrefix(path.toString()));
                }
                if (!selection.checkFileName(fileName = path.getFileName().toString()) || !selection.isValidFileType(attr = this.readFileAttributes(path)) || (file = this.createProviderFile(path, attr)) == null || !selection.checkProviderFileMinMaxSize(file)) continue;
                file.setIndex(++counterAdded);
                result.add(file);
                if (!isDebugEnabled) continue;
                this.getLogger().debug((Object)(this.getPathOperationPrefix(path.toString()) + "added"));
            }
        }
        return result;
    }
}

