/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.smb.smbj;

import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.vfs.smb.smbj.SMBJProviderUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class SMBJInputStream
extends InputStream {
    private final DiskShare share;
    private final boolean closeShare;
    private final File file;
    private final InputStream is;

    public SMBJInputStream(boolean accessMaskMaximumAllowed, DiskShare share, boolean closeShare, String smbPath) throws Exception {
        this.share = share;
        this.closeShare = closeShare;
        if (!this.share.fileExists(smbPath)) {
            throw new SOSNoSuchFileException(smbPath, (Throwable)new Exception(smbPath));
        }
        this.file = SMBJProviderUtils.openFileWithReadAccess(accessMaskMaximumAllowed, share, smbPath);
        this.is = this.file.getInputStream();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            SOSClassUtil.closeQuietly((Closeable)this.is);
            SOSClassUtil.closeQuietly((Closeable)this.file);
            if (this.closeShare) {
                SOSClassUtil.closeQuietly((AutoCloseable)this.share);
            }
        }
    }
}

