/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.checkhistory;

import com.sos.jitl.jobs.checkhistory.CheckHistoryJobArguments;
import com.sos.jitl.jobs.checkhistory.HistoryInfo;
import com.sos.jitl.jobs.checkhistory.classes.HistoryItem;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepOutcome;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class CheckHistoryJob
extends Job<CheckHistoryJobArguments> {
    public CheckHistoryJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void processOrder(OrderProcessStep<CheckHistoryJobArguments> step) throws Exception {
        this.process(step, (CheckHistoryJobArguments)step.getDeclaredArguments());
    }

    private OrderProcessStepOutcome process(OrderProcessStep<CheckHistoryJobArguments> step, CheckHistoryJobArguments args) throws Exception {
        OrderProcessStepOutcome outcome = step.getOutcome();
        outcome.putVariable("js7CheckHistoryResult", (Object)false);
        outcome.putVariable("js7CheckHistoryResultControllerId", (Object)"");
        outcome.putVariable("js7CheckHistoryResultWorkflow", (Object)"");
        outcome.putVariable("js7CheckHistoryResultJob", (Object)"");
        outcome.putVariable("js7CheckHistoryResultStarted", (Object)"");
        outcome.putVariable("js7CheckHistoryResultCompleted", (Object)"");
        String query = args.getQuery();
        outcome.putVariable("js7CheckHistoryQuery", (Object)query);
        outcome.putVariable("js7CheckHistoryQueryControllerId", (Object)args.getControllerId());
        outcome.putVariable("js7CheckHistoryQueryWorkflow", (Object)args.getWorkflow());
        outcome.putVariable("js7CheckHistoryQueryJob", (Object)args.getJob());
        step.getLogger().debug((Object)String.format("check history: %s will be executed.", query));
        HistoryInfo historyInfo = new HistoryInfo(step);
        HistoryItem historyItem = historyInfo.queryHistory();
        Object name = args.getWorkflow();
        if (name == null) {
            name = args.getJob();
        } else if (args.getJob() != null) {
            name = (String)name + "<" + args.getJob() + ">";
        }
        if (historyItem != null) {
            boolean result = historyItem.getResult();
            if (result) {
                String s = args.getQuery() + "(" + (String)name + ") ==> true";
                step.getLogger().debug((Object)s);
                outcome.putVariable("js7CheckHistoryResultString", (Object)s);
                outcome.putVariable("js7CheckHistoryResult", (Object)true);
                outcome.putVariable("js7CheckHistoryResultControllerId", (Object)historyItem.getControllerId());
                outcome.putVariable("js7CheckHistoryResultStarted", (Object)historyItem.getStartTime());
                outcome.putVariable("js7CheckHistoryResultCompleted", (Object)historyItem.getEndTime());
                outcome.putVariable("js7CheckHistoryResultWorkflow", (Object)historyItem.getWorkflow());
                outcome.putVariable("js7CheckHistoryResultJob", (Object)historyItem.getJob());
                outcome.setReturnCode(Integer.valueOf(0));
            } else {
                String s = args.getQuery() + "(" + (String)name + ") ==> false";
                step.getLogger().debug((Object)s);
                outcome.putVariable("js7CheckHistoryResultString", (Object)s);
                outcome.putVariable("js7CheckHistoryResult", (Object)false);
                outcome.setReturnCode(Integer.valueOf(1));
            }
        }
        return outcome;
    }
}

