/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.checkhistory.classes;

import com.sos.joc.model.common.HistoryState;
import com.sos.joc.model.job.TaskHistory;
import com.sos.joc.model.job.TaskHistoryItem;
import com.sos.joc.model.order.OrderHistory;
import com.sos.joc.model.order.OrderHistoryItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class HistoryItem {
    private String controllerId;
    private String job;
    private String workflow;
    private String orderId;
    private String startTime;
    private String endTime;
    private String position;
    private HistoryState state;
    private Long taskId;
    private Integer exitCode;
    private boolean historyItemFound = false;
    private boolean result = false;
    private int count = 0;

    private String getIso8601String(Date d) {
        if (d != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf.format(d);
        }
        return "1900-01-01T00:00:00.000";
    }

    public HistoryItem(OrderHistory orderHistory) {
        this.result = orderHistory != null;
        boolean bl = this.historyItemFound = orderHistory != null;
        if (this.result) {
            this.count = orderHistory.getHistory().size();
            OrderHistoryItem orderHistoryItem = (OrderHistoryItem)orderHistory.getHistory().get(0);
            this.controllerId = orderHistoryItem.getControllerId();
            this.job = "";
            this.workflow = orderHistoryItem.getWorkflow();
            this.orderId = orderHistoryItem.getOrderId();
            this.startTime = this.getIso8601String(orderHistoryItem.getStartTime());
            this.endTime = this.getIso8601String(orderHistoryItem.getEndTime());
            this.position = orderHistoryItem.getPosition();
            this.state = orderHistoryItem.getState();
            this.taskId = 0L;
        }
    }

    public HistoryItem(TaskHistory taskHistory) {
        this.result = taskHistory != null;
        boolean bl = this.historyItemFound = taskHistory != null;
        if (this.result) {
            this.count = taskHistory.getHistory().size();
            TaskHistoryItem taskHistoryItem = (TaskHistoryItem)taskHistory.getHistory().get(0);
            this.controllerId = taskHistoryItem.getControllerId();
            this.job = taskHistoryItem.getJob();
            this.workflow = taskHistoryItem.getWorkflow();
            this.orderId = taskHistoryItem.getOrderId();
            this.startTime = this.getIso8601String(taskHistoryItem.getStartTime());
            this.endTime = this.getIso8601String(taskHistoryItem.getEndTime());
            this.position = taskHistoryItem.getPosition();
            this.state = taskHistoryItem.getState();
            this.taskId = taskHistoryItem.getTaskId();
        }
    }

    public boolean getHistoryItemFound() {
        return this.historyItemFound;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public String getControllerId() {
        return this.controllerId;
    }

    public String getJob() {
        return this.job;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getPosition() {
        return this.position;
    }

    public HistoryState getState() {
        return this.state;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public int getCount() {
        return this.count;
    }

    public void setResult(boolean result) {
        this.result = result;
    }
}

