/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.checkhistory.classes;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.joc.model.job.JobsFilter;
import com.sos.joc.model.job.TaskHistory;
import com.sos.joc.model.job.TaskHistoryItem;
import com.sos.joc.model.order.OrderHistory;
import com.sos.joc.model.order.OrderHistoryItem;
import com.sos.joc.model.order.OrdersFilter;
import com.sos.js7.job.JobHelper;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;

public class HistoryWebserviceExecuter {
    private final ISOSLogger logger;
    private final ApiExecutor apiExecutor;

    public HistoryWebserviceExecuter(ISOSLogger logger, ApiExecutor apiExecutor) {
        this.logger = logger;
        this.apiExecutor = apiExecutor;
    }

    public OrderHistory getWorkflowHistoryEntry(OrdersFilter ordersFilter, String accessToken) throws Exception {
        String body = JobHelper.OBJECT_MAPPER.writeValueAsString((Object)ordersFilter);
        ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/orders/history/", body);
        String answer = null;
        if (apiResponse.getStatusCode() != 200) {
            if (apiResponse.getException() != null) {
                throw apiResponse.getException();
            }
            throw new Exception(apiResponse.getResponseBody());
        }
        answer = apiResponse.getResponseBody();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)body);
            this.logger.debug("answer=%s", new Object[]{answer});
        }
        OrderHistory orderHistory = new OrderHistory();
        orderHistory = (OrderHistory)JobHelper.OBJECT_MAPPER.readValue(answer, OrderHistory.class);
        if (orderHistory.getHistory().size() == 0) {
            return null;
        }
        OrderHistoryItem h = (OrderHistoryItem)orderHistory.getHistory().get(0);
        if (h.getHistoryId() == null) {
            return null;
        }
        return orderHistory;
    }

    public TaskHistory getJobHistoryEntry(JobsFilter jobsFilter, String accessToken) throws Exception {
        String body = JobHelper.OBJECT_MAPPER.writeValueAsString((Object)jobsFilter);
        ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/tasks/history", body);
        String answer = null;
        if (apiResponse.getStatusCode() != 200) {
            if (apiResponse.getException() != null) {
                throw apiResponse.getException();
            }
            throw new Exception(apiResponse.getResponseBody());
        }
        answer = apiResponse.getResponseBody();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)body);
            this.logger.debug("answer=%s", new Object[]{answer});
        }
        TaskHistory taskHistory = new TaskHistory();
        taskHistory = (TaskHistory)JobHelper.OBJECT_MAPPER.readValue(answer, TaskHistory.class);
        if (taskHistory.getHistory().size() == 0) {
            return null;
        }
        TaskHistoryItem h = (TaskHistoryItem)taskHistory.getHistory().get(0);
        if (h.getTaskId() == null) {
            return null;
        }
        return taskHistory;
    }
}

