/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.checklicense.classes;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.checklicense.CheckLicenseJobArguments;
import com.sos.jitl.jobs.checklicense.classes.CheckLicenseWebserviceExecuter;
import com.sos.joc.model.joc.Js7LicenseInfo;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;
import java.util.Date;
import java.util.Map;

public class CheckLicense {
    private final CheckLicenseJobArguments args;
    private final Map<String, DetailValue> jobResources;
    private final OrderProcessStep<CheckLicenseJobArguments> step;
    private int exit;
    private String body;
    private String subject;

    public CheckLicense(OrderProcessStep<CheckLicenseJobArguments> step) {
        this.args = (CheckLicenseJobArguments)step.getDeclaredArguments();
        this.jobResources = step.getJobResourcesArgumentsAsNameDetailValueMap();
        this.step = step;
    }

    private void log(String s) {
        this.step.getLogger().info((Object)s);
        this.body = this.body + s + "\r\n";
    }

    public void execute() throws Exception {
        ApiExecutor apiExecutor = new ApiExecutor(this.step);
        apiExecutor.setJobResources(this.jobResources);
        String accessToken = null;
        this.exit = 0;
        this.body = "";
        this.subject = "";
        try {
            ApiResponse apiResponse = apiExecutor.login();
            accessToken = apiResponse.getAccessToken();
            CheckLicenseWebserviceExecuter checkLicenceWebserviceExecuter = new CheckLicenseWebserviceExecuter(apiExecutor);
            Js7LicenseInfo js7LicenseInfo = checkLicenceWebserviceExecuter.getLicence((ISOSLogger)this.step.getLogger(), accessToken);
            this.log(".. Check License for validity period of " + this.args.getValidityDays().shortValue() + " days");
            this.log(".. Licence tpye: " + js7LicenseInfo.getType());
            if (js7LicenseInfo.getValid() != null && js7LicenseInfo.getValid().booleanValue()) {
                this.subject = "JS7 JobScheduler License Check: " + js7LicenseInfo.getType();
                this.log(".. License valid: " + js7LicenseInfo.getValid());
                if (js7LicenseInfo.getValidFrom() != null && js7LicenseInfo.getValidUntil() != null) {
                    Date now = new Date();
                    this.log(".. License valid from: " + js7LicenseInfo.getValidFrom());
                    this.log(".. License valid to: " + js7LicenseInfo.getValidUntil());
                    if (js7LicenseInfo.getValidUntil().before(now)) {
                        this.log("License Check failed: license expired on " + js7LicenseInfo.getValidUntil());
                        this.subject = "JS7 JobScheduler Notification: license expired";
                        this.exit = 2;
                    }
                    long timeUntilExpiration = (js7LicenseInfo.getValidUntil().getTime() - now.getTime()) / 86400000L;
                    long daysMs = this.args.getValidityDays().intValue();
                    if (this.step.getLogger().isDebugEnabled()) {
                        this.step.getLogger().debug("now: %s", new Object[]{now.getTime()});
                        this.step.getLogger().debug("daysMs: %s", new Object[]{daysMs});
                        this.step.getLogger().debug("timeUntilExpiration: %s", new Object[]{timeUntilExpiration});
                    }
                    if (timeUntilExpiration < daysMs) {
                        this.log("License Check warning: license will expire on " + js7LicenseInfo.getValidUntil());
                        this.subject = "JS7 JobScheduler Notification: license expiration warning";
                        this.exit = 3;
                    }
                }
            } else {
                this.log(".. License valid not applicable");
                this.log("License Check failed: license check not applicable for open source license");
                this.subject = "JS7 JobScheduler License Check failed";
                this.exit = 2;
            }
        }
        catch (Exception e) {
            this.step.getLogger().error((Throwable)e);
            this.exit = 4;
            throw e;
        }
        finally {
            if (accessToken != null) {
                apiExecutor.logout(accessToken);
            }
            apiExecutor.close();
        }
    }

    public int getExit() {
        return this.exit;
    }

    public String getBody() {
        return this.body;
    }

    public String getSubject() {
        return this.subject;
    }
}

