/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.checklog.classes;

import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.sap.common.Globals;
import com.sos.joc.model.job.JobsFilter;
import com.sos.joc.model.job.RunningTaskLogFilter;
import com.sos.joc.model.job.TaskHistory;
import com.sos.joc.model.order.OrderFilter;
import com.sos.joc.model.order.OrderHistoryFilter;
import com.sos.joc.model.order.OrderHistoryItemChildren;
import com.sos.joc.model.order.OrderV;
import com.sos.joc.model.workflow.Workflow;
import com.sos.joc.model.workflow.WorkflowFilter;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;
import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class CheckLogWebserviceExecuter {
    private final ISOSLogger logger;
    private final ApiExecutor apiExecutor;

    public CheckLogWebserviceExecuter(ISOSLogger logger, ApiExecutor apiExecutor) {
        this.logger = logger;
        this.apiExecutor = apiExecutor;
    }

    public Workflow getWorkflow(WorkflowFilter workflowFilter, String accessToken) throws Exception {
        String body = Globals.objectMapper.writeValueAsString((Object)workflowFilter);
        ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/workflow", body);
        String answer = null;
        if (apiResponse.getStatusCode() != 200) {
            if (apiResponse.getException() != null) {
                throw apiResponse.getException();
            }
            throw new Exception(apiResponse.getResponseBody());
        }
        answer = apiResponse.getResponseBody();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)body);
            this.logger.debug("answer=%s", new Object[]{answer});
        }
        Workflow workflow = new Workflow();
        workflow = (Workflow)Globals.objectMapper.readValue(answer, Workflow.class);
        if (workflow == null || workflow.getWorkflow() == null || workflow.getWorkflow().getJobs() == null || workflow.getWorkflow().getJobs().getAdditionalProperties() == null) {
            return null;
        }
        return workflow;
    }

    public OrderV getOrder(OrderFilter orderFilter, String accessToken) throws Exception {
        String body = Globals.objectMapper.writeValueAsString((Object)orderFilter);
        ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/order", body);
        String answer = null;
        if (apiResponse.getStatusCode() != 200) {
            if (apiResponse.getException() != null) {
                throw apiResponse.getException();
            }
            JsonReader jsonReaderConfigurationResponse = Json.createReader((Reader)new StringReader(apiResponse.getResponseBody()));
            JsonObject jsonConfigurationResponse = jsonReaderConfigurationResponse.readObject();
            JsonObject jsonConfigurationResponseError = jsonConfigurationResponse.getJsonObject("error");
            if (jsonConfigurationResponseError != null) {
                String code = jsonConfigurationResponseError.getString("code", "");
                String message = jsonConfigurationResponseError.getString("message", "");
                this.logger.info("code: %s", new Object[]{code});
                this.logger.info("message: %s", new Object[]{message});
                if (code.equals("JOC-400") && message.startsWith("ControllerObjectNotExistException:")) {
                    throw new SOSMissingDataException(apiResponse.getResponseBody());
                }
            }
            throw new Exception(apiResponse.getResponseBody());
        }
        answer = apiResponse.getResponseBody();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)body);
            this.logger.debug("answer=%s", new Object[]{answer});
        }
        OrderV order = new OrderV();
        order = (OrderV)Globals.objectMapper.readValue(answer, OrderV.class);
        return order;
    }

    public OrderHistoryItemChildren getOrderHistory(OrderHistoryFilter orderHistoryFilter, String accessToken) throws Exception {
        String body = Globals.objectMapper.writeValueAsString((Object)orderHistoryFilter);
        ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/order/history", body);
        String answer = null;
        if (apiResponse.getStatusCode() != 200) {
            if (apiResponse.getException() != null) {
                throw apiResponse.getException();
            }
            throw new Exception(apiResponse.getResponseBody());
        }
        answer = apiResponse.getResponseBody();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)body);
            this.logger.debug("answer=%s", new Object[]{answer});
        }
        OrderHistoryItemChildren orderHistoryItemChildren = new OrderHistoryItemChildren();
        orderHistoryItemChildren = (OrderHistoryItemChildren)Globals.objectMapper.readValue(answer, OrderHistoryItemChildren.class);
        return orderHistoryItemChildren;
    }

    public TaskHistory getTaskHistory(JobsFilter jobsFilter, String accessToken) throws Exception {
        String body = Globals.objectMapper.writeValueAsString((Object)jobsFilter);
        ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/tasks/history", body);
        String answer = null;
        if (apiResponse.getStatusCode() != 200) {
            if (apiResponse.getException() != null) {
                throw apiResponse.getException();
            }
            throw new Exception(apiResponse.getResponseBody());
        }
        answer = apiResponse.getResponseBody();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)body);
            this.logger.debug("answer=%s", new Object[]{answer});
        }
        TaskHistory taskHistory = new TaskHistory();
        taskHistory = (TaskHistory)Globals.objectMapper.readValue(answer, TaskHistory.class);
        return taskHistory;
    }

    public String getTaskLog(RunningTaskLogFilter runningTaskLogFilter, String accessToken) throws Exception {
        String body = Globals.objectMapper.writeValueAsString((Object)runningTaskLogFilter);
        ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/task/log", body);
        String answer = null;
        if (apiResponse.getStatusCode() != 200) {
            if (apiResponse.getException() != null) {
                throw apiResponse.getException();
            }
            throw new Exception(apiResponse.getResponseBody());
        }
        answer = apiResponse.getResponseBody();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)body);
            this.logger.debug("answer=%s", new Object[]{answer});
        }
        return answer;
    }
}

