/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db;

import com.sos.commons.hibernate.SOSHibernateFactory;
import com.sos.commons.hibernate.SOSHibernateSQLExecutor;
import com.sos.commons.hibernate.SOSHibernateSession;
import com.sos.commons.util.SOSParameterSubstitutor;
import com.sos.jitl.jobs.db.SQLExecutorJobArguments;
import com.sos.jitl.jobs.db.common.CancelableDatabaseJob;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepOutcome;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class SQLExecutorJob
extends CancelableDatabaseJob<SQLExecutorJobArguments> {
    public SQLExecutorJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void processOrder(OrderProcessStep<SQLExecutorJobArguments> step) throws Exception {
        SOSHibernateFactory factory = null;
        SOSHibernateSession session = null;
        try {
            factory = new SOSHibernateFactory((Path)((SQLExecutorJobArguments)step.getDeclaredArguments()).getHibernateFile().getValue());
            factory.setIdentifier(SQLExecutorJob.class.getSimpleName());
            factory.build();
            session = factory.openStatelessSession();
            this.addCancelableResource(step, session);
            this.process(step, session);
            step.getLogger().info((Object)("result: " + step.getOutcome().getVariables()));
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (factory != null) {
                factory.close();
            }
        }
    }

    private void process(OrderProcessStep<SQLExecutorJobArguments> step, SOSHibernateSession session) throws Exception {
        SQLExecutorJobArguments args = (SQLExecutorJobArguments)step.getDeclaredArguments();
        SOSHibernateSQLExecutor executor = session.getSQLExecutor();
        List statements = null;
        try {
            Path path = Paths.get(args.getCommand(), new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                step.getLogger().debug("[load from file]%s", new Object[]{path});
                statements = executor.getStatements(this.replaceVars(step, path));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (statements == null) {
            statements = executor.getStatements(args.getCommand());
        }
        session.beginTransaction();
        for (String statement : statements) {
            step.getLogger().info("executing database statement: %s", new Object[]{statement});
            if (SOSHibernateSQLExecutor.isResultListQuery((String)statement, (boolean)args.getExecReturnsResultset())) {
                this.executeResultSet(step, executor, statement, step.getOutcome());
                continue;
            }
            executor.executeUpdate(new String[]{statement});
        }
        session.commit();
    }

    public String replaceVars(OrderProcessStep<SQLExecutorJobArguments> step, Path path) throws Exception {
        Map vars = step.getAllArgumentsAsNameValueMap();
        this.put(vars, "js7ControllerId", step.getControllerId());
        this.put(vars, "js7OrderId", step.getOrderId());
        this.put(vars, "js7WorkflowPath", step.getWorkflowName());
        this.put(vars, "js7WorkflowPosition", step.getWorkflowPosition());
        this.put(vars, "js7Label", step.getJobInstructionLabel());
        this.put(vars, "js7JobName", step.getJobName());
        SOSParameterSubstitutor ps = new SOSParameterSubstitutor(true, "${", "}");
        vars.entrySet().forEach(e -> ps.addKey((String)e.getKey(), e.getValue().toString()));
        return ps.replace(path);
    }

    private void put(Map<String, Object> map, String name, Object value) {
        if (value != null) {
            map.put(name, value);
        }
    }

    /*
     * Exception decompiling
     */
    private void executeResultSet(OrderProcessStep<SQLExecutorJobArguments> step, SOSHibernateSQLExecutor executor, String statement, OrderProcessStepOutcome outcome) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

